/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.RefactoringUtils;
import org.eclipse.rcptt.ui.refactoring.rename.UpdateTagReferenceChange;

public class RenameTagProcessor
extends RenameProcessor {
    private Tag tag;
    private String newTagName;

    public RenameTagProcessor(Tag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must not be null");
        }
        this.tag = tag;
        this.setNewTagName(tag.getValue());
    }

    public String getNewTagName() {
        return this.newTagName;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setNewTagName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newTagName = newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return RefactoringUtils.validateTagInSync(this.tag);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            Tag tag = this.tag;
            synchronized (tag) {
                String taskName = this.tag.getPath().equals(this.tag.getValue()) ? NLS.bind((String)Messages.RenameTagProcessor_TaskName, (Object)this.tag.getValue()) : NLS.bind((String)Messages.RenameTagProcessor_TaskName_SubTag, (Object)this.tag.getValue(), (Object)this.tag.getPath());
                CompositeChange composite = new CompositeChange(taskName);
                String path = this.tag.getPath();
                int i = path.lastIndexOf(this.tag.getValue());
                String newPath = String.valueOf(path.substring(0, i)) + this.newTagName;
                for (IQ7NamedElement ref : this.tag.getRefs()) {
                    composite.add((Change)new UpdateTagReferenceChange(ref, this.tag.getPath(), newPath));
                }
                this.collectUpdates(composite, (List<Tag>)this.tag.getTags(), this.tag.getPath(), newPath);
                CompositeChange compositeChange = composite;
                return compositeChange;
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectUpdates(CompositeChange composite, List<Tag> tags, String oldPath, String newPath) {
        for (Tag t : tags) {
            String oldPath2 = t.getPath();
            String newPath2 = String.valueOf(newPath) + oldPath2.substring(oldPath.length(), oldPath2.length());
            Tag tag = t;
            synchronized (tag) {
                for (IQ7NamedElement ref : t.getRefs()) {
                    composite.add((Change)new UpdateTagReferenceChange(ref, oldPath2, newPath2));
                }
                this.collectUpdates(composite, (List<Tag>)t.getTags(), oldPath2, newPath2);
            }
        }
    }

    public String getIdentifier() {
        return "org.eclipse.rcptt.ui.refactoring.rename.renameTagProcessor";
    }

    public String getProcessorName() {
        return Messages.RenameTagProcessor_ProcessorName;
    }

    public boolean isApplicable() {
        return this.tag != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public Object[] getElements() {
        return new Object[]{this.tag};
    }

    public RefactoringStatus validateNewTagName(String text) {
        if (text == null || text.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)"");
        }
        if (text.equals(this.tag.getValue())) {
            return RefactoringStatus.createFatalErrorStatus((String)"");
        }
        return new RefactoringStatus();
    }
}

