/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchAction
extends Action {
    private IProduct fProduct;
    private String fMode;
    private String fPath;
    private Map<String, IPluginConfiguration> fPluginConfigurations;

    public LaunchAction(IProduct product, String path, String mode) {
        this.fProduct = product;
        this.fMode = mode;
        this.fPath = path;
        this.fPluginConfigurations = new HashMap<String, IPluginConfiguration>();
        IPluginConfiguration[] configurations = this.fProduct.getPluginConfigurations();
        int i = 0;
        while (i < configurations.length) {
            IPluginConfiguration config = configurations[i];
            this.fPluginConfigurations.put(config.getId(), config);
            ++i;
        }
    }

    public void run() {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration();
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)this.fMode);
            }
        }
        catch (CoreException coreException) {}
    }

    private ILaunchConfiguration findLaunchConfiguration() throws CoreException {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations();
        if (configs.length == 0) {
            return this.createConfiguration();
        }
        ILaunchConfiguration config = null;
        config = configs.length == 1 ? configs[0] : this.chooseConfiguration(configs);
        if (config != null) {
            config = this.refreshConfiguration(config.getWorkingCopy());
        }
        return config;
    }

    private ILaunchConfiguration refreshConfiguration(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        wc.setAttribute("product", this.fProduct.getProductId());
        wc.setAttribute("application", this.fProduct.getApplication());
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArguments(os, arch));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJREContainer(os));
        StringBuffer wsplugins = new StringBuffer();
        StringBuffer explugins = new StringBuffer();
        IPluginModelBase[] models = this.getModels();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            if (model.getUnderlyingResource() == null) {
                this.appendBundle(explugins, model);
            } else {
                this.appendBundle(wsplugins, model);
            }
            ++i;
        }
        wc.setAttribute("selected_workspace_plugins", wsplugins.toString());
        wc.setAttribute("selected_target_plugins", explugins.toString());
        String configIni = this.getTemplateConfigIni(os);
        wc.setAttribute("useDefaultConfig", configIni == null);
        if (configIni != null) {
            wc.setAttribute("templateConfig", configIni);
        }
        return wc.doSave();
    }

    private void appendBundle(StringBuffer buffer, IPluginModelBase model) {
        IPluginConfiguration configuration = this.fPluginConfigurations.get(model.getPluginBase().getId());
        String sl = "default";
        String autostart = "default";
        if (configuration != null) {
            sl = Integer.toString(configuration.getStartLevel());
            sl = sl.equals("0") ? "default" : sl;
            autostart = Boolean.toString(configuration.isAutoStart());
        }
        String entry = BundleLauncherHelper.writeBundleEntry((IPluginModelBase)model, (String)sl, (String)autostart);
        buffer.append(entry);
        buffer.append(',');
    }

    private String getProgramArguments(String os, String arch) {
        StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialProgramArguments());
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteProgramArguments(os, arch)) : "";
        return this.concatArgs(buffer, userArgs);
    }

    private String getVMArguments(String os, String arch) {
        StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialVMArguments());
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        String userArgs = info != null ? CoreUtility.normalize((String)info.getCompleteVMArguments(os, arch)) : "";
        return this.concatArgs(buffer, userArgs);
    }

    private String concatArgs(StringBuffer initialArgs, String userArgs) {
        List<String> initialArgsList = Arrays.asList(DebugPlugin.parseArguments((String)initialArgs.toString()));
        if (userArgs != null && userArgs.length() > 0) {
            List<String> userArgsList = Arrays.asList(DebugPlugin.parseArguments((String)userArgs));
            for (String userArg : userArgsList) {
                if (initialArgsList.contains(userArg)) continue;
                initialArgs.append(' ');
                initialArgs.append((Object)userArg);
            }
        }
        return initialArgs.toString();
    }

    private String getJREContainer(String os) {
        IPath jrePath;
        IJREInfo info = this.fProduct.getJREInfo();
        if (info != null && (jrePath = info.getJREContainerPath(os)) != null) {
            return jrePath.toPortableString();
        }
        return null;
    }

    private IPluginModelBase[] getModels() {
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        if (this.fProduct.useFeatures()) {
            IFeatureModel[] features = this.getUniqueFeatures();
            int i = 0;
            while (i < features.length) {
                this.addFeaturePlugins(features[i].getFeature(), launchPlugins);
                ++i;
            }
        } else {
            IProductPlugin[] plugins = this.fProduct.getPlugins();
            int i = 0;
            while (i < plugins.length) {
                IPluginModelBase model;
                String id = plugins[i].getId();
                if (id != null && (model = PluginRegistry.findModel((String)id)) != null && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
                ++i;
            }
        }
        return launchPlugins.toArray(new IPluginModelBase[launchPlugins.size()]);
    }

    private IFeatureModel[] getUniqueFeatures() {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IProductFeature[] features = this.fProduct.getFeatures();
        int i = 0;
        while (i < features.length) {
            String id = features[i].getId();
            String version = features[i].getVersion();
            this.addFeatureAndChildren(id, version, list);
            ++i;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private void addFeatureAndChildren(String id, String version, List<IFeatureModel> list) {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.findFeatureModel(id, version);
        if (model == null || list.contains(model)) {
            return;
        }
        list.add(model);
        IFeatureChild[] children = model.getFeature().getIncludedFeatures();
        int i = 0;
        while (i < children.length) {
            this.addFeatureAndChildren(children[i].getId(), children[i].getVersion(), list);
            ++i;
        }
    }

    private void addFeaturePlugins(IFeature feature, Set<IPluginModelBase> launchPlugins) {
        IFeaturePlugin[] plugins = feature.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getId();
            String version = plugins[i].getVersion();
            if (id != null && version != null) {
                IPluginModelBase model = PluginRegistry.findModel((String)id, (String)version, (int)1, null);
                if (model == null) {
                    model = PluginRegistry.findModel((String)id);
                }
                if (model != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
            }
            ++i;
        }
    }

    private String getTemplateConfigIni(String os) {
        IConfigurationFileInfo info = this.fProduct.getConfigurationFileInfo();
        if (info != null) {
            File file;
            String expandedPath;
            String path = info.getPath(os);
            if (path == null) {
                path = info.getPath(null);
            }
            if (path != null && (expandedPath = this.getExpandedPath(path)) != null && (file = new File(expandedPath)).exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDEPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEUIMessages.RuntimeWorkbenchShortcut_title);
        if (this.fMode.equals("debug")) {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_debug);
        } else {
            dialog.setMessage(PDEUIMessages.RuntimeWorkbenchShortcut_select_run);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration() throws CoreException {
        ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
        String computedName = this.getComputedName(new Path(this.fPath).lastSegment());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
        wc.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)computedName));
        wc.setAttribute("usefeatures", false);
        wc.setAttribute("default", false);
        wc.setAttribute("clearws", false);
        wc.setAttribute("clearwslog", false);
        wc.setAttribute("append.args", true);
        wc.setAttribute("askclear", true);
        wc.setAttribute("useProduct", true);
        wc.setAttribute("automaticAdd", false);
        wc.setAttribute("productFile", this.fPath);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        return this.refreshConfiguration(wc);
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateLaunchConfigurationName(prefix);
    }

    private ILaunchConfiguration[] getLaunchConfigurations() throws CoreException {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configs.length) {
            String path;
            if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i]) && new Path(this.fPath).equals((Object)new Path(path = configs[i].getAttribute("productFile", "")))) {
                result.add(configs[i]);
            }
            ++i;
        }
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
    }
}

