/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.gef;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFeatures;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.gef.DirectEditorContainer;
import org.eclipse.rcptt.tesla.gef.GefProcessor;
import org.eclipse.rcptt.tesla.gef.GefUtils;
import org.eclipse.rcptt.tesla.gef.TeslaGefAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.recording.aspects.draw2d.Draw2DEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.draw2d.IDraw2DEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.gef.GefEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.gef.IGefEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.gef.RecordingGefActivator;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessorExtension;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefFigureLocator;
import org.eclipse.rcptt.tesla.recording.core.gef.GefRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.gef.IGMFRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.ICanvasDiagramHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.rcptt.util.ReflectionUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GefEventRecorder
implements IRecordingProcessor,
IGefEventListener,
ICanvasDiagramHelper,
IRecordingProcessorExtension {
    private TeslaRecorder recorder;
    private boolean collectChildren = false;
    private final List<EditPart> childrens = new ArrayList<EditPart>();
    private SWTEventRecorder eventRecorder = null;
    private final Set<EditPartViewer> workingWidgets = new HashSet<EditPartViewer>();
    private boolean down = false;
    private final GefFigureLocator locator = new GefFigureLocator(this);
    private boolean wasMouseMove = false;
    private int inDrag = 0;
    protected Set<EditPart> dragPart = new HashSet<EditPart>();
    private EditPart directEditPart = null;

    public GefEventRecorder() {
        GefEventManager.addListener((IGefEventListener)this);
        Draw2DEventManager.addListener((IDraw2DEventListener)new IDraw2DEventListener(){

            public void mouseReleased(SWTEventDispatcher disp, MouseEvent event) {
                try {
                    GraphicalViewer viewer = GefEventRecorder.this.getGraphicalViewer(event.widget);
                    if (viewer != null) {
                        GefEventRecorder.this.mouseUp(null, event, (EditPartViewer)viewer);
                    }
                }
                catch (Throwable e) {
                    RecordingGefActivator.log((Throwable)e);
                }
            }

            public void mousePressed(SWTEventDispatcher disp, MouseEvent event) {
                try {
                    GraphicalViewer viewer = GefEventRecorder.this.getGraphicalViewer(event.widget);
                    if (viewer != null) {
                        GefEventRecorder.this.mouseDown(null, event, (EditPartViewer)viewer);
                    }
                }
                catch (Throwable e) {
                    RecordingGefActivator.log((Throwable)e);
                }
            }

            public void mouseMoved(SWTEventDispatcher disp, MouseEvent event) {
                try {
                    GraphicalViewer viewer = GefEventRecorder.this.getGraphicalViewer(event.widget);
                    if (viewer != null) {
                        GefEventRecorder.this.mouseMove(null, event, (EditPartViewer)viewer);
                    }
                }
                catch (Throwable e) {
                    RecordingGefActivator.log((Throwable)e);
                }
            }

            public void mouseHover(SWTEventDispatcher disp, MouseEvent event) {
                try {
                    GraphicalViewer viewer = GefEventRecorder.this.getGraphicalViewer(event.widget);
                    if (viewer != null) {
                        GefEventRecorder.this.mouseHover(null, event, (EditPartViewer)viewer);
                    }
                }
                catch (Throwable e) {
                    RecordingGefActivator.log((Throwable)e);
                }
            }

            public void mouseExited(SWTEventDispatcher disp, MouseEvent event) {
            }

            public void mouseEntered(SWTEventDispatcher disp, MouseEvent event) {
            }

            public void mouseDoubleClick(SWTEventDispatcher disp, MouseEvent event) {
                try {
                    GraphicalViewer viewer = GefEventRecorder.this.getGraphicalViewer(event.widget);
                    if (viewer != null) {
                        GefEventRecorder.this.mouseDoubleClick(null, event, (EditPartViewer)viewer);
                    }
                }
                catch (Throwable e) {
                    RecordingGefActivator.log((Throwable)e);
                }
            }
        });
    }

    private GraphicalViewer getGraphicalViewer(Widget widget) {
        if (widget instanceof Canvas) {
            return (GraphicalViewer)TeslaSWTAccess.getThis(GraphicalViewer.class, (Widget)widget, (int)12);
        }
        return null;
    }

    public void performRequest(EditPart part, Request request) {
    }

    public void toolActivate(Tool tool) {
    }

    public void setActiveTool(EditDomain domain, Tool tool) {
    }

    public int getInitLevel() {
        return 1000;
    }

    public void notifyAddChild(AbstractEditPart part, EditPart child, int index) {
        if (this.collectChildren) {
            this.childrens.add(child);
        }
        GefRecordingHelper.getHelper().clear();
    }

    public void notifyRemoveChild(AbstractEditPart part, EditPart child, int index) {
        GefRecordingHelper.getHelper().clear();
    }

    public synchronized void doDiagramEventOp(EditDomain domain, EditPartViewer viewer, IDiagramEventHandler handler) {
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null) {
            SWTUIPlayer player = this.eventRecorder.getPlayer();
            handler.run(player, entry.diagramViewer, entry.lowerParent);
        }
    }

    public boolean isSkipDiagramOperations() {
        return TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use") && !TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use.raw.canvas.only");
    }

    public synchronized SWTEventRecorder getEventRecorder() {
        if (this.eventRecorder == null) {
            this.eventRecorder = (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.eventRecorder;
    }

    public void mouseDown(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        boolean cts = this.workingWidgets.contains(viewer);
        this.workingWidgets.add(viewer);
        this.down = true;
        if (!cts) {
            this.mouseMove(domain, mouseEvent, viewer);
        }
        if (this.wasMouseMove) {
            this.mouseMove(domain, mouseEvent, viewer, true);
        }
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null) {
            EditPart editPart = viewer.getRootEditPart() == null ? null : viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
            this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.DOWN, viewer);
        }
        this.wasMouseMove = false;
    }

    public IGMFRecordingProcessor[] getHelpers() {
        List processors = this.recorder.getProcessors(IGMFRecordingProcessor.class);
        return processors.toArray(new IGMFRecordingProcessor[processors.size()]);
    }

    private void doMouseFigureOperation(MouseEvent mouseEvent, DiagramViewerUIElement diagramViewer, EditPart editPart, MouseCommandKind op, EditPartViewer viewer) {
        Canvas cv = (Canvas)viewer.getControl();
        if (editPart != null) {
            IFigure figure;
            IFigure resultFigure;
            Map visualPartMap = viewer.getVisualPartMap();
            Set keySet = visualPartMap.entrySet();
            AbstractHandle handle = null;
            for (Map.Entry object : keySet) {
                AbstractHandle h;
                if (!object.getValue().equals(editPart) || !(object.getKey() instanceof AbstractHandle) || !(h = (AbstractHandle)object.getKey()).containsPoint(mouseEvent.x, mouseEvent.y)) continue;
                handle = h;
                break;
            }
            if (handle == null && editPart.equals(viewer.getRootEditPart()) && cv instanceof FigureCanvas && (resultFigure = (figure = ((FigureCanvas)cv).getContents()).findFigureAt(mouseEvent.x, mouseEvent.y)) instanceof AbstractHandle) {
                handle = (AbstractHandle)resultFigure;
            }
            if (handle != null) {
                GefUtils.FigureAddress hfa = GefUtils.getAddress(handle);
                IGMFRecordingProcessor[] iGMFRecordingProcessorArray = this.getHelpers();
                int n = iGMFRecordingProcessorArray.length;
                int h = 0;
                while (h < n) {
                    IGMFRecordingProcessor helper = iGMFRecordingProcessorArray[h];
                    if (helper.isIgnored((IFigure)handle)) {
                        return;
                    }
                    GefUtils.FigureAddress addr = helper.getHandleAddress(handle);
                    if (addr != null) {
                        EditPart part = helper.getEditPart((IFigure)handle);
                        if (part != null) {
                            this.doEditPartOp(mouseEvent, diagramViewer, editPart, op, this.locator.find(part, viewer, diagramViewer, false), (IFigure)handle, addr.path);
                            return;
                        }
                        hfa = addr;
                    }
                    ++h;
                }
                if (handle instanceof AbstractHandle) {
                    EditPart part = TeslaGefAccess.getEditPart(handle);
                    FigureUIElement element = this.getLocator().find(part, viewer, diagramViewer, false);
                    int indexOf = 0;
                    List children = GefProcessor.findAbstractHandles((GraphicalViewer)((GraphicalViewer)viewer));
                    for (Object object : children) {
                        if (object.equals(handle)) break;
                        if (!(object instanceof AbstractHandle) || !((AbstractHandle)object).isVisible() || !object.getClass().equals(handle.getClass()) || !part.equals(TeslaGefAccess.getEditPart((AbstractHandle)((AbstractHandle)object)))) continue;
                        ++indexOf;
                    }
                    FigureUIElement handleFigure = this.getHandleFigure(handle, element, indexOf);
                    Rectangle bounds = handle.getBounds().getCopy();
                    handle.translateToAbsolute((Translatable)bounds);
                    int px = mouseEvent.x - bounds.x;
                    int py = mouseEvent.y - bounds.y;
                    org.eclipse.swt.graphics.Rectangle bounds2 = cv.getBounds();
                    handleFigure.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, null, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
                    return;
                }
                if (hfa != null) {
                    this.performOp(mouseEvent, diagramViewer, op, cv, hfa.lastFigure, hfa.path);
                    return;
                }
            }
            if (editPart != null && editPart != viewer.getRootEditPart()) {
                FigureUIElement address = this.locator.find(editPart, viewer, diagramViewer, false);
                GraphicalEditPart gep = (GraphicalEditPart)editPart;
                IFigure figure2 = gep.getFigure();
                IFigure figureAt = figure2.findFigureAt(mouseEvent.x, mouseEvent.y);
                figureAt = this.skipFlowFigures(figureAt, figure2);
                figureAt = this.skipEditPartFigures(figureAt, figure2, viewer);
                List faAddress = GefUtils.getAddress((IFigure)figureAt, (IFigure)figure2);
                if (figureAt != null && !figureAt.getParent().isEnabled()) {
                    figureAt = figure2;
                    faAddress.clear();
                }
                if (figureAt == null) {
                    figureAt = figure2;
                }
                this.doEditPartOp(mouseEvent, diagramViewer, editPart, op, address, figureAt, faAddress);
                return;
            }
        }
        IFigure figure = null;
        if (cv instanceof FigureCanvas) {
            figure = ((FigureCanvas)cv).getContents();
        } else {
            GraphicalViewer graphicalViewer = (GraphicalViewer)TeslaSWTAccess.getThis(GraphicalViewer.class, (Widget)cv, (int)12);
            if (graphicalViewer != null) {
                figure = (IFigure)TeslaSWTAccess.getField(IFigure.class, (Object)graphicalViewer, (String)"rootFigure");
            }
        }
        if (figure != null) {
            IFigure resultFigure = figure.findFigureAt(mouseEvent.x, mouseEvent.y);
            resultFigure = this.skipEditPartFigures(resultFigure, figure, viewer);
            List<Integer> faAddress = GefUtils.getAddress((IFigure)resultFigure, (IFigure)figure);
            IGMFRecordingProcessor[] iGMFRecordingProcessorArray = this.getHelpers();
            int n = iGMFRecordingProcessorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGMFRecordingProcessor helper = iGMFRecordingProcessorArray[n2];
                if (helper.isIgnored(resultFigure)) {
                    return;
                }
                List<Integer> addr = helper.getFigureAddress(resultFigure);
                if (addr != null) {
                    EditPart part = helper.getEditPart(resultFigure);
                    if (part != null) {
                        this.doEditPartOp(mouseEvent, diagramViewer, part, op, this.locator.find(part, viewer, diagramViewer, false), resultFigure, addr);
                        return;
                    }
                    faAddress = addr;
                }
                ++n2;
            }
            if (resultFigure != null && !resultFigure.getParent().isEnabled() || editPart == null && op.equals((Object)MouseCommandKind.DRAG)) {
                resultFigure = figure;
                faAddress.clear();
            }
            if (resultFigure == null) {
                resultFigure = figure;
            }
            this.performOp(mouseEvent, diagramViewer, op, cv, resultFigure, faAddress);
        }
    }

    private FigureUIElement getHandleFigure(AbstractHandle handle, FigureUIElement parentElement, int indexOf) {
        BasicRecordingHelper.ElementEntry el = GefRecordingHelper.getHelper().get(handle);
        FigureUIElement element = null;
        if (el != null) {
            element = new FigureUIElement(el.getElement(), (UIPlayer)this.recorder);
        } else {
            element = parentElement.handleByClass(handle.getClass().getSimpleName(), indexOf == 0 ? null : Integer.valueOf(indexOf));
            GefRecordingHelper.getHelper().put(handle, new BasicRecordingHelper.ElementEntry(element.getElement()));
        }
        return element;
    }

    private IFigure skipEditPartFigures(IFigure resultFigure, IFigure figure, EditPartViewer viewer) {
        HashSet<IFigure> allEditPartFigures = new HashSet<IFigure>();
        if (viewer.getRootEditPart() != null) {
            this.fillEditPartFigures(allEditPartFigures, viewer.getContents());
        }
        ArrayList<IFigure> parentsList = new ArrayList<IFigure>();
        IFigure i = resultFigure;
        while (i != null) {
            parentsList.add(0, i);
            if (i.equals(figure)) break;
            i = i.getParent();
        }
        for (IFigure iFigure : parentsList) {
            if (!allEditPartFigures.contains(iFigure) && iFigure.isEnabled()) continue;
            return figure;
        }
        return resultFigure;
    }

    private void fillEditPartFigures(Set<IFigure> allEditPartFigures, EditPart contents) {
        List children = contents.getChildren();
        for (EditPart editPart : children) {
            if (editPart instanceof GraphicalEditPart) {
                allEditPartFigures.add(((GraphicalEditPart)editPart).getFigure());
            }
            this.fillEditPartFigures(allEditPartFigures, editPart);
        }
    }

    private IFigure skipFlowFigures(IFigure figureAt, IFigure figure) {
        while (figureAt instanceof FlowFigure) {
            if (figure.equals(figureAt = figureAt.getParent())) break;
        }
        return figureAt;
    }

    private void doEditPartOp(MouseEvent mouseEvent, DiagramViewerUIElement diagramViewer, EditPart editPart, MouseCommandKind op, FigureUIElement address, IFigure figureAt, List<Integer> faAddress) {
        Control control = editPart.getViewer().getControl();
        FigureCanvas canvas = (FigureCanvas)control;
        Rectangle bounds = figureAt.getBounds().getCopy();
        Point mouseEventRelativeCoords = new Point(mouseEvent.x, mouseEvent.y);
        figureAt.translateToRelative((Translatable)mouseEventRelativeCoords);
        int px = mouseEventRelativeCoords.x - bounds.x;
        int py = mouseEventRelativeCoords.y - bounds.y;
        figureAt.translateToRelative((Translatable)mouseEventRelativeCoords);
        org.eclipse.swt.graphics.Rectangle bounds2 = canvas.getBounds();
        if (address != null) {
            if (faAddress != null && faAddress.size() > 0) {
                FigureUIElement element = this.getFigureByAddress(address, figureAt, faAddress);
                element.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, null, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
                return;
            }
            address.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, null, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
            return;
        }
        diagramViewer.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, faAddress, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
    }

    private FigureUIElement getFigureByAddress(FigureUIElement diagramViewer, IFigure figure, List<Integer> address) {
        BasicRecordingHelper.ElementEntry el = GefRecordingHelper.getHelper().get(figure);
        FigureUIElement element = null;
        if (el != null) {
            element = new FigureUIElement(el.getElement(), (UIPlayer)this.recorder);
        } else {
            element = diagramViewer.rawFigure(address);
            GefRecordingHelper.getHelper().put(figure, new BasicRecordingHelper.ElementEntry(element.getElement()));
        }
        return element;
    }

    private void performOp(MouseEvent mouseEvent, DiagramViewerUIElement diagramViewer, MouseCommandKind op, Canvas cv, IFigure lastFigure, List<Integer> figureAddress) {
        Rectangle bounds = lastFigure.getBounds().getCopy();
        int px = mouseEvent.x - bounds.x;
        int py = mouseEvent.y - bounds.y;
        org.eclipse.swt.graphics.Rectangle bounds2 = cv.getBounds();
        if (figureAddress != null && figureAddress.size() > 0) {
            FigureUIElement element = this.getFigureByAddress((FigureUIElement)diagramViewer, lastFigure, figureAddress);
            element.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, null, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
            return;
        }
        diagramViewer.executeFigureMouseCommand(px, py, mouseEvent.button, op, null, figureAddress, bounds2.width, bounds2.height, bounds.width, bounds.height, mouseEvent.stateMask);
    }

    public void mouseUp(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.workingWidgets.add(viewer);
        this.down = false;
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null) {
            EditPart editPart = null;
            if (this.inDrag > 0) {
                HashSet exclude = new HashSet();
                editPart = viewer.findObjectAtExcluding(new Point(mouseEvent.x, mouseEvent.y), exclude, new EditPartViewer.Conditional(){

                    public boolean evaluate(EditPart editpart) {
                        while (editpart != null) {
                            if (GefEventRecorder.this.dragPart.contains(editpart)) {
                                return false;
                            }
                            editpart = editpart.getParent();
                        }
                        return true;
                    }
                });
                this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.DRAG, viewer);
            }
            if (editPart == null && viewer.getRootEditPart() != null) {
                editPart = viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
            }
            this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.UP, viewer);
            this.inDrag = 0;
        }
        this.collectChildren = true;
        this.childrens.clear();
        this.wasMouseMove = false;
    }

    public void afterMouseUp(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
    }

    public void mouseDoubleClick(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.workingWidgets.add(viewer);
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null) {
            EditPart editPart = viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
            this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.DOUBLE_CLICK, viewer);
        }
    }

    public void mouseDrag(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.workingWidgets.add(viewer);
        if (this.inDrag == 0) {
            if (this.isSkipDiagramOperations()) {
                return;
            }
            GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
            if (entry != null) {
                ++this.inDrag;
                EditPart editPart = viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
                this.fillDragParts(editPart, this.dragPart, viewer);
                this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.DRAG, viewer);
                mouseEvent.x += 6;
                mouseEvent.y += 6;
                this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, null, MouseCommandKind.DRAG, viewer);
            }
        } else {
            this.fillDragParts(null, this.dragPart, viewer);
        }
    }

    public void mouseHover(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.inDrag > 0) {
            return;
        }
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        if (!TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.mouse.hover.support")) {
            return;
        }
        if (!this.workingWidgets.contains(viewer)) {
            return;
        }
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null) {
            EditPart editPart = viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
            this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.HOVER, viewer);
        }
    }

    public void mouseMove(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        this.mouseMove(domain, mouseEvent, viewer, false);
    }

    private static DiagramFeatures.MouseMoveMode getMouseMoveMode() {
        return DiagramFeatures.MouseMoveMode.valueOf((String)TeslaFeatures.getInstance().getValue("org.eclipse.rcptt.tesla.protocol.diagram.mouse.move.mode"));
    }

    public void mouseMove(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer, boolean forceRecord) {
        boolean shouldRecord;
        this.wasMouseMove = true;
        DiagramFeatures.MouseMoveMode mode = GefEventRecorder.getMouseMoveMode();
        boolean bl = shouldRecord = forceRecord || (mouseEvent.stateMask & SWT.BUTTON_MASK) != 0 || mode == DiagramFeatures.MouseMoveMode.Always;
        if (this.inDrag > 0) {
            if (domain != null && domain.getActiveTool() instanceof AbstractTool) {
                AbstractTool tool = (AbstractTool)domain.getActiveTool();
                AbstractTool.Input input = TeslaGefAccess.getCurrentInput((AbstractTool)tool);
                if (input == null) {
                    input = new AbstractTool.Input();
                }
                if (!this.isInputSynched(input, mouseEvent)) {
                    boolean b1 = input.isMouseButtonDown(1);
                    boolean b2 = input.isMouseButtonDown(2);
                    boolean b3 = input.isMouseButtonDown(3);
                    boolean b4 = input.isMouseButtonDown(4);
                    boolean b5 = input.isMouseButtonDown(5);
                    if (b1) {
                        mouseEvent.button = 1;
                        this.mouseUp(domain, mouseEvent, viewer);
                    }
                    if (b2) {
                        mouseEvent.button = 2;
                        this.mouseUp(domain, mouseEvent, viewer);
                    }
                    if (b3) {
                        mouseEvent.button = 3;
                        this.mouseUp(domain, mouseEvent, viewer);
                    }
                    if (b4) {
                        mouseEvent.button = 4;
                        this.mouseUp(domain, mouseEvent, viewer);
                    }
                    if (b5) {
                        mouseEvent.button = 5;
                        this.mouseUp(domain, mouseEvent, viewer);
                    }
                    return;
                }
            }
            return;
        }
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        if (this.isSkipDiagramOperations()) {
            return;
        }
        GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
        if (entry != null && viewer.getRootEditPart() != null) {
            IFigure figure;
            EventListenerList listeners;
            EditPart editPart = viewer.findObjectAt(new Point(mouseEvent.x, mouseEvent.y));
            if (editPart instanceof GraphicalEditPart && !shouldRecord && (listeners = (EventListenerList)ReflectionUtil.getField((Object)(figure = ((GraphicalEditPart)editPart).getFigure()), (String)"eventListeners")) != null && listeners.getListeners(MouseMotionListener.class).hasNext()) {
                boolean bl2 = shouldRecord = mode == DiagramFeatures.MouseMoveMode.Smart;
            }
            if (shouldRecord) {
                this.doMouseFigureOperation(mouseEvent, entry.diagramViewer, editPart, MouseCommandKind.MOVE, viewer);
            }
        }
    }

    private boolean isInputSynched(AbstractTool.Input input, MouseEvent event) {
        return input.isMouseButtonDown(1) == ((event.stateMask & 0x80000) != 0) && input.isMouseButtonDown(2) == ((event.stateMask & 0x100000) != 0) && input.isMouseButtonDown(3) == ((event.stateMask & 0x200000) != 0) && input.isMouseButtonDown(4) == ((event.stateMask & 0x800000) != 0) && input.isMouseButtonDown(5) == ((event.stateMask & 0x2000000) != 0);
    }

    public void mouseWheelScrolled(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
    }

    public void afterMouseDown(EditDomain domain, MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
    }

    public void executeCommand(Command command) {
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    public void clear() {
        GefRecordingHelper.getHelper().clear();
        this.childrens.clear();
        this.inDrag = 0;
        this.directEditPart = null;
        this.workingWidgets.clear();
    }

    public void nativeDragFinished(EditDomain domain, DragSourceEvent event, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
    }

    public void nativeDragStarted(EditDomain domain, DragSourceEvent event, EditPartViewer viewer) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
    }

    public void forceDirectEdit(DirectEditManager manager) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        Object source = this.getDirectEditSource(manager);
        if (source != null && source instanceof EditPart) {
            FigureUIElement partElement;
            EditPart part = (EditPart)source;
            if (TeslaGefAccess.isPalleteEditPart((EditPart)part) && TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.palette.entry")) {
                return;
            }
            if (this.directEditPart != null && this.directEditPart.equals(part)) {
                return;
            }
            this.directEditPart = part;
            EditPartViewer viewer = part.getViewer();
            if (this.isSkipDiagramOperations()) {
                return;
            }
            GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
            if (entry != null && (partElement = this.locator.find(part, viewer, entry.diagramViewer, false)) != null) {
                partElement.forceDirectEdit(null);
            }
        }
    }

    private Object getDirectEditSource(DirectEditManager manager) {
        return TeslaGefAccess.getDirectEditSource((DirectEditManager)manager);
    }

    public void cancelDirectEdit(DirectEditorContainer container) {
        GraphicalViewer viewer;
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        CellEditor cellEditor = container.getCellEditor();
        if (cellEditor != null) {
            SWTEventRecorder eventRecorder;
            SWTUIPlayer player;
            GraphicalViewer viewer2;
            Composite parent;
            Control control = cellEditor.getControl();
            if (control != null && (parent = control.getParent()) instanceof FigureCanvas && (viewer2 = GefProcessor.findDiagramViewer((SWTUIElement)(player = (eventRecorder = this.getEventRecorder()).getPlayer()).wrap((Object)parent), GraphicalViewer.class, null, (SWTUIPlayer)player)) != null) {
                if (this.isSkipDiagramOperations()) {
                    return;
                }
                GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement((EditPartViewer)viewer2);
                if (entry != null) {
                    entry.diagramViewer.cancelDirectEdit();
                }
            }
        } else if (this.directEditPart != null && (viewer = (GraphicalViewer)this.directEditPart.getViewer()) != null) {
            if (this.isSkipDiagramOperations()) {
                return;
            }
            GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement((EditPartViewer)viewer);
            if (entry != null) {
                entry.diagramViewer.cancelDirectEdit();
            }
        }
        this.directEditPart = null;
    }

    public void commitDirectEdit(DirectEditorContainer container) {
        GraphicalViewer viewer;
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        CellEditor cellEditor = container.getCellEditor();
        if (cellEditor != null) {
            SWTEventRecorder eventRecorder;
            SWTUIPlayer player;
            GraphicalViewer viewer2;
            Composite parent;
            Control control = cellEditor.getControl();
            if (control != null && (parent = control.getParent()) instanceof FigureCanvas && (viewer2 = GefProcessor.findDiagramViewer((SWTUIElement)(player = (eventRecorder = this.getEventRecorder()).getPlayer()).wrap((Object)parent), GraphicalViewer.class, null, (SWTUIPlayer)player)) != null) {
                if (this.isSkipDiagramOperations()) {
                    return;
                }
                GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement((EditPartViewer)viewer2);
                if (entry != null) {
                    entry.diagramViewer.commitDirectEdit();
                }
            }
        } else if (this.directEditPart != null && (viewer = (GraphicalViewer)this.directEditPart.getViewer()) != null) {
            if (this.isSkipDiagramOperations()) {
                return;
            }
            GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement((EditPartViewer)viewer);
            if (entry != null) {
                entry.diagramViewer.commitDirectEdit();
            }
        }
        this.directEditPart = null;
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    private void fillDragParts(EditPart editPart, Set<EditPart> dragParts, EditPartViewer viewer) {
        DragTracker dragTracker;
        Tool tool;
        if (editPart != null) {
            dragParts.clear();
            dragParts.add(editPart);
        }
        if (viewer.getEditDomain() != null && (tool = viewer.getEditDomain().getActiveTool()) != null && tool instanceof SelectionTool && (dragTracker = this.getDragTracker(tool)) != null) {
            Object field;
            if (dragTracker instanceof SelectEditPartTracker && (field = this.getEditPartField(dragTracker)) != null) {
                dragParts.add((EditPart)field);
            }
            List processors = this.recorder.getProcessors(IGMFRecordingProcessor.class);
            for (IGMFRecordingProcessor pr : processors) {
                pr.updateDragParts(dragParts, dragTracker);
            }
            List operationSet = this.getOperationSet(dragTracker);
            if (operationSet != null) {
                for (Object object : operationSet) {
                    if (!(object instanceof EditPart)) continue;
                    dragParts.add((EditPart)object);
                }
            }
        }
        dragParts.remove(viewer.getContents());
    }

    private List getOperationSet(DragTracker dragTracker) {
        return TeslaGefAccess.getOperationSet((DragTracker)dragTracker);
    }

    private Object getEditPartField(DragTracker dragTracker) {
        return TeslaGefAccess.getEditPartField((DragTracker)dragTracker);
    }

    private DragTracker getDragTracker(Tool tool) {
        return TeslaGefAccess.getDragTracker((Tool)tool);
    }

    public void handleDelayedDirectEdit(Object helper) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        EditPart value = this.getEditPart(helper);
        if (this.directEditPart != null && this.directEditPart.equals(value)) {
            return;
        }
        if (TeslaGefAccess.isPalleteEditPart((EditPart)value) && TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.palette.entry")) {
            return;
        }
        this.directEditPart = value;
        Object activeHelper = this.getActiveHelper(helper);
        if (activeHelper != null && value != null && value.isActive()) {
            FigureUIElement partElement;
            EditPartViewer viewer = value.getViewer();
            if (this.isSkipDiagramOperations()) {
                return;
            }
            GefRecordingHelper.GraphicalViewerEntry entry = this.locator.getDiagramUIElement(viewer);
            if (entry != null && (partElement = this.locator.find(value, viewer, entry.diagramViewer, false)) != null) {
                partElement.activateDirectEdit(null);
            }
        }
    }

    private Object getActiveHelper(Object helper) {
        return TeslaGefAccess.getActiveHelper((Object)helper);
    }

    private EditPart getEditPart(Object helper) {
        return TeslaGefAccess.getEditPart((Object)helper);
    }

    public TeslaRecorder getRecorder() {
        return this.recorder;
    }

    public GefFigureLocator getLocator() {
        return this.locator;
    }

    public Element findDiagramElement(Canvas canvas) {
        GefRecordingHelper.GraphicalViewerEntry entry;
        Object canvasOwner;
        if (canvas instanceof FigureCanvas && (canvasOwner = TeslaSWTAccess.getThis(EditPartViewer.class, (Widget)canvas, (int)12)) instanceof EditPartViewer && (entry = this.locator.getDiagramUIElement((EditPartViewer)canvasOwner)) != null) {
            return entry.diagramViewer.getElement();
        }
        return null;
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper<?> getHelper() {
        return GefRecordingHelper.getHelper();
    }

    public boolean isNotCanvas(Object widget, int type, Object event) {
        return this.isNotDraw2d(widget);
    }

    public boolean isIgnored(Object widget, int type, Object event) {
        return false;
    }

    public boolean isNotDraw2d(Object widget) {
        return widget instanceof Widget && this.getGraphicalViewer((Widget)widget) != null;
    }

    private static class GefViewerCacheEntry {
        SWTUIElement lowerParent;
        DiagramViewerUIElement diagramViewer;

        private GefViewerCacheEntry() {
        }
    }

    public static interface IDiagramEventHandler {
        public void run(SWTUIPlayer var1, DiagramViewerUIElement var2, SWTUIElement var3);
    }
}

