/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.ui.internal.ValidationUIPlugin;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.emf.validation.ui.internal.preferences.CategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.ConstraintDetailsHelper;
import org.eclipse.emf.validation.ui.internal.preferences.ConstraintNode;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ConstraintsSelectionBlock {
    private static final String LOCK_ICON = "full/lock.gif";
    static final String CATEGORIES_PROMPT = ValidationUIMessages.prefs_categories_prompt;
    static final String CONSTRAINTS_PROMPT = ValidationUIMessages.prefs_constraints_prompt;
    static final String NO_SELECTION = ValidationUIMessages.prefs_no_selection;
    static final String NO_CATEGORY_DESCRIPTION = ValidationUIMessages.prefs_no_description_category;
    private CheckboxTreeViewer categoryTree;
    private CheckboxTableViewer constraintList;
    private StyledText detailsArea;
    private Mediator mediator;
    private ICategoryTreeNode rootcategory;
    private final IConstraintFilter filter;

    static {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    public ConstraintsSelectionBlock() {
        this(IConstraintFilter.IDENTITY_INSTANCE);
    }

    public ConstraintsSelectionBlock(IConstraintFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        this.filter = filter;
    }

    public Composite createComposite(Composite parent) {
        SashForm result = new SashForm(parent, 512);
        result.setFont(parent.getFont());
        SashForm topPart = new SashForm((Composite)result, 256);
        this.createCategoryTree((Composite)topPart);
        this.createConstraintList((Composite)topPart);
        this.createDetailsArea((Composite)result);
        result.setWeights(new int[]{70, 30});
        return result;
    }

    private Control createCategoryTree(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CATEGORIES_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.categoryTree = new CheckboxTreeViewer(form);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.categoryTree.getControl().setLayoutData((Object)data);
        this.rootcategory = CategoryTreeNode.createRoot(this.categoryTree, this.filter);
        this.categoryTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final Image lockImage = ValidationUIPlugin.getImageDescriptor("full/lock.gif").createImage(true);

            public void dispose() {
                this.lockImage.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (node.getCategory() != null && node.getCategory().isMandatory()) {
                    return this.lockImage;
                }
                return null;
            }
        });
        this.categoryTree.setContentProvider((IContentProvider)new CategoryTreeContents());
        this.categoryTree.setInput((Object)this.rootcategory);
        this.markEnabledCategories(this.rootcategory);
        this.categoryTree.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.categoryTree.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.categoryTree.getTree();
    }

    private Control createConstraintList(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CONSTRAINTS_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.constraintList = CheckboxTableViewer.newCheckList((Composite)form, (int)2080);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.constraintList.getControl().setLayoutData((Object)data);
        this.constraintList.setContentProvider((IContentProvider)new ConstraintListContents());
        this.constraintList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final Image lockImage = ValidationUIPlugin.getImageDescriptor("full/lock.gif").createImage(true);

            public void dispose() {
                this.lockImage.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                IConstraintNode constraint = (IConstraintNode)element;
                if (constraint.isErrored()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                if (constraint.isMandatory()) {
                    return this.lockImage;
                }
                return null;
            }

            public String getText(Object element) {
                return ((IConstraintNode)element).getName();
            }
        });
        this.constraintList.setSorter(new ViewerSorter());
        this.constraintList.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.constraintList.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.constraintList.getControl();
    }

    private Control createDetailsArea(Composite parent) {
        this.detailsArea = new StyledText(parent, 2634);
        this.getMediator().clearDetailsArea();
        return this.detailsArea;
    }

    private CheckboxTreeViewer getCategoryTree() {
        return this.categoryTree;
    }

    private CheckboxTableViewer getConstraintList() {
        return this.constraintList;
    }

    private StyledText getDetailsArea() {
        return this.detailsArea;
    }

    private Mediator getMediator() {
        if (this.mediator == null) {
            this.mediator = new Mediator();
        }
        return this.mediator;
    }

    public boolean performOk() {
        this.rootcategory.applyToPreferences();
        EMFModelValidationPreferences.save();
        return true;
    }

    public void performDefaults() {
        Object[] elements;
        this.rootcategory.restoreDefaults();
        CheckboxTableViewer viewer = this.getConstraintList();
        Object input = viewer.getInput();
        if (input != null && (elements = ((IStructuredContentProvider)this.getConstraintList().getContentProvider()).getElements(input)) != null) {
            int length = elements.length;
            int i = 0;
            while (i < length) {
                IConstraintNode node = (IConstraintNode)elements[i];
                viewer.setChecked((Object)node, node.isChecked());
                ++i;
            }
        }
    }

    private Category getCurrentCategorySelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getCategoryTree().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return ((ICategoryTreeNode)selection.getFirstElement()).getCategory();
    }

    private void markEnabledCategories(ICategoryTreeNode root) {
        this.markEnabledCategories(root.getChildren());
    }

    private void markEnabledCategories(ICategoryTreeNode[] categories) {
        ICategoryTreeNode[] iCategoryTreeNodeArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode next = iCategoryTreeNodeArray[n2];
            this.getCategoryTree().setChecked((Object)next, next.isChecked());
            this.getCategoryTree().setGrayed((Object)next, next.isGrayed());
            this.markEnabledCategories(next.getChildren());
            ++n2;
        }
    }

    public void dispose() {
        ConstraintNode.flushCache();
    }

    private class CategoryTreeContents
    implements ITreeContentProvider {
        private CategoryTreeContents() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((ICategoryTreeNode)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((ICategoryTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((ICategoryTreeNode)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ConstraintListContents
    implements IStructuredContentProvider,
    ICheckStateListener {
        private CheckboxTableViewer viewer;
        private ICategoryTreeNode category;

        private ConstraintListContents() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            this.category = (ICategoryTreeNode)inputElement;
            return this.category.getConstraints().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
            if (this.viewer != null) {
                this.viewer.removeCheckStateListener((ICheckStateListener)this);
            }
            this.viewer = (CheckboxTableViewer)newViewer;
            this.category = (ICategoryTreeNode)newInput;
            if (this.viewer != null) {
                this.viewer.addCheckStateListener((ICheckStateListener)this);
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.category.updateCheckState((IConstraintNode)event.getElement());
        }
    }

    private class Mediator
    implements ISelectionChangedListener,
    ICheckStateListener {
        private boolean respondingToUserSelection;

        private Mediator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ICategoryTreeNode) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (this.respondingToUserSelection) return;
                this.respondingToUserSelection = true;
                try {
                    node.checkStateChanged(event);
                    IStructuredSelection selection = (IStructuredSelection)ConstraintsSelectionBlock.this.getCategoryTree().getSelection();
                    if (selection.isEmpty()) return;
                    this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
                    return;
                }
                finally {
                    this.respondingToUserSelection = false;
                }
            }
            IConstraintNode node = (IConstraintNode)element;
            if (this.respondingToUserSelection) return;
            this.respondingToUserSelection = true;
            try {
                node.checkStateChanged(event);
                return;
            }
            finally {
                this.respondingToUserSelection = false;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (event.getSource().equals(ConstraintsSelectionBlock.this.getCategoryTree())) {
                this.handleCategorySelection(selection);
            } else if (event.getSource().equals(ConstraintsSelectionBlock.this.getConstraintList())) {
                this.handleConstraintSelection(selection);
            }
        }

        private void handleCategorySelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
            } else {
                ConstraintsSelectionBlock.this.getConstraintList().setInput(null);
                this.clearDetailsArea();
            }
        }

        private void selectCategory(ICategoryTreeNode category) {
            ConstraintsSelectionBlock.this.getConstraintList().setInput((Object)category);
            this.selectConstraints(category);
            this.setDetails(category);
        }

        private void selectConstraints(ICategoryTreeNode categoryNode) {
            ConstraintsSelectionBlock.this.getConstraintList().setCheckedElements((Object[])categoryNode.getSelectedConstraints());
        }

        private void handleConstraintSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.setDetails((IConstraintNode)selection.getFirstElement());
            } else {
                this.clearDetailsArea();
            }
        }

        void clearDetailsArea() {
            ConstraintsSelectionBlock.this.getDetailsArea().setText(NO_SELECTION);
        }

        private void setDetails(ICategoryTreeNode category) {
            Category actualCategory;
            String description;
            String string = description = category == null ? null : category.getDescription();
            if (description == null) {
                description = NO_CATEGORY_DESCRIPTION;
            }
            if ((actualCategory = category.getCategory()) != null && actualCategory.isMandatory()) {
                ConstraintsSelectionBlock.this.getDetailsArea().setText(MessageFormat.format(ValidationUIMessages.prefs_mandatory_category, description));
            } else {
                ConstraintsSelectionBlock.this.getDetailsArea().setText(description);
            }
        }

        private void setDetails(IConstraintNode constraint) {
            ArrayList styles = new ArrayList(32);
            String text = ConstraintDetailsHelper.formatConstraintDescription(constraint, ConstraintsSelectionBlock.this.getCurrentCategorySelection(), styles);
            ConstraintsSelectionBlock.this.getDetailsArea().setText(text);
            ConstraintsSelectionBlock.this.getDetailsArea().setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
        }
    }
}

