/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.UIStats;

public class EarlyStartupRunnable
extends SafeRunnable {
    private IExtension extension;

    public EarlyStartupRunnable(IExtension extension) {
        this.extension = extension;
    }

    public void run() throws Exception {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = this.extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element != null && element.getName().equals("startup")) {
                this.runEarlyStartup(this.getExecutableExtension(element));
            }
            ++n2;
        }
    }

    public void handleException(Throwable exception) {
        Status status = new Status(4, this.extension.getNamespaceIdentifier(), 0, "Unable to execute early startup code for an extension", exception);
        WorkbenchPlugin.log((IStatus)status);
    }

    private void runEarlyStartup(Object executableExtension) {
        if (executableExtension instanceof IStartup) {
            String methodName = String.valueOf(executableExtension.getClass().getName()) + ".earlyStartup";
            try {
                UIStats.start(15, methodName);
                ((IStartup)executableExtension).earlyStartup();
            }
            finally {
                UIStats.end(15, executableExtension, methodName);
            }
        } else {
            String message = executableExtension == null ? "The startup extension does not provide a valid class attribute." : MessageFormat.format((String)"Startup class {0} must implement org.eclipse.ui.IStartup", (Object[])new Object[]{executableExtension.getClass().getName()});
            Status status = new Status(4, this.extension.getNamespaceIdentifier(), 0, message, null);
            WorkbenchPlugin.log((IStatus)status);
        }
    }

    private Object getExecutableExtension(IConfigurationElement element) throws CoreException {
        return WorkbenchPlugin.createExtension(element, "class");
    }
}

