/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class JarEntryEditorInput
implements IStorageEditorInput {
    private IStorage fJarEntryFile;

    public JarEntryEditorInput(IStorage jarEntryFile) {
        this.fJarEntryFile = jarEntryFile;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarEntryEditorInput)) {
            return false;
        }
        JarEntryEditorInput other = (JarEntryEditorInput)obj;
        return this.fJarEntryFile.equals(other.fJarEntryFile);
    }

    public int hashCode() {
        return this.fJarEntryFile.hashCode();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getName() {
        return this.fJarEntryFile.getName();
    }

    public String getFullPath() {
        return this.fJarEntryFile.getFullPath().toString();
    }

    public String getContentType() {
        return this.fJarEntryFile.getFullPath().getFileExtension();
    }

    public String getToolTipText() {
        File file = (File)this.fJarEntryFile.getAdapter(File.class);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return this.fJarEntryFile.getFullPath().toString();
    }

    public ImageDescriptor getImageDescriptor() {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        return registry.getImageDescriptor(this.fJarEntryFile.getFullPath().getFileExtension());
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(File.class)) {
            return this.fJarEntryFile.getAdapter(File.class);
        }
        return null;
    }

    public IStorage getStorage() {
        return this.fJarEntryFile;
    }
}

