/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileNameFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigurationSection
extends PDESection {
    private Button fDefault;
    private Button fCustom;
    private FormEntry fCustomEntry;
    private boolean fBlockChanges;
    private static final String[] TAB_LABELS = new String[]{"linux", "macosx", "solaris", "win32"};
    private static final String[] TAB_OS = new String[]{"linux", "macosx", "solaris", "win32"};
    private CTabFolder fTabFolder;
    private int fLastTab;

    public ConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(768);
        section.setLayoutData((Object)sectionData);
        section.setText(PDEUIMessages.ConfigurationSection_title);
        section.setDescription(PDEUIMessages.ConfigurationSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationSection.this.fCustomEntry.isDirty()) {
                    ConfigurationSection.this.fCustomEntry.commit();
                }
                ConfigurationSection.this.refresh();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        this.fDefault = toolkit.createButton(client, PDEUIMessages.ConfigurationSection_default, 16);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fDefault.setLayoutData((Object)gd);
        this.fDefault.setEnabled(this.isEditable());
        this.fDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ConfigurationSection.this.fBlockChanges) {
                    boolean selected = ConfigurationSection.this.fDefault.getSelection();
                    IConfigurationFileInfo info = ConfigurationSection.this.getConfigurationFileInfo();
                    String os = ConfigurationSection.this.getOS(ConfigurationSection.this.fLastTab);
                    info.setUse(os, selected ? "default" : "custom");
                    info.setPath(os, selected ? null : ConfigurationSection.this.fCustomEntry.getValue());
                    ConfigurationSection.this.fCustomEntry.setValue(selected ? null : ConfigurationSection.this.fCustomEntry.getValue(), true);
                    ConfigurationSection.this.fCustomEntry.setEditable(!selected);
                }
            }
        });
        this.fCustom = toolkit.createButton(client, PDEUIMessages.ConfigurationSection_existing, 16);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fCustom.setLayoutData((Object)gd);
        this.fCustom.setEnabled(this.isEditable());
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fCustomEntry = new FormEntry(client, toolkit, PDEUIMessages.ConfigurationSection_file, PDEUIMessages.ConfigurationSection_browse, this.isEditable(), 35);
        this.fCustomEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (!ConfigurationSection.this.fBlockChanges) {
                    IConfigurationFileInfo info = ConfigurationSection.this.getConfigurationFileInfo();
                    String os = ConfigurationSection.this.getOS(ConfigurationSection.this.fLastTab);
                    info.setUse(os, "custom");
                    info.setPath(os, entry.getValue());
                }
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                ConfigurationSection.this.handleBrowse();
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                ConfigurationSection.this.handleOpen();
            }
        });
        this.fCustomEntry.setEditable(this.isEditable());
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.ConfigurationSection_selection);
        dialog.setMessage(PDEUIMessages.ConfigurationSection_message);
        dialog.addFilter((ViewerFilter)new FileNameFilter("config.ini"));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.fCustomEntry.setValue(file.getFullPath().toString());
        }
    }

    public void refresh() {
        this.fBlockChanges = true;
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        IConfigurationFileInfo info = this.getConfigurationFileInfo();
        String os = this.getOS(this.fLastTab);
        this.fDefault.setEnabled(this.isEditable());
        if (info == null) {
            this.fDefault.setSelection(true);
            this.fCustomEntry.setEditable(false);
        } else {
            boolean custom = "custom".equals(info.getUse(os));
            this.fDefault.setSelection(!custom);
            this.fCustom.setSelection(custom);
            this.fCustomEntry.setValue(custom ? info.getPath(os) : null, true);
            this.fCustomEntry.setEditable(this.isEditable() && custom);
        }
        super.refresh();
        this.fBlockChanges = false;
    }

    private IConfigurationFileInfo getConfigurationFileInfo() {
        IConfigurationFileInfo info = this.getProduct().getConfigurationFileInfo();
        if (info == null) {
            info = this.getModel().getFactory().createConfigFileInfo();
            this.getProduct().setConfigurationFileInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void commit(boolean onSave) {
        this.fCustomEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fCustomEntry.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    private void handleOpen() {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        Path path = new Path(this.fCustomEntry.getValue());
        if (path.isEmpty()) {
            MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_emptyPath);
            return;
        }
        IResource resource = root.findMember((IPath)path);
        try {
            if (resource != null && resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            } else {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_warning);
            }
        }
        catch (PartInitException partInitException) {}
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (this.fCustomEntry.getText().isDisposed()) {
            return;
        }
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fCustomEntry.getText());
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
        String currentTarget = TargetPlatform.getOS();
        if ("win32".equals(currentTarget)) {
            this.fTabFolder.setSelection(3);
        } else if ("macosx".equals(currentTarget)) {
            this.fTabFolder.setSelection(1);
        } else if ("solaris".equals(currentTarget)) {
            this.fTabFolder.setSelection(2);
        }
    }

    private String getOS(int tab) {
        if (tab >= 0 && tab < TAB_OS.length) {
            return TAB_OS[tab];
        }
        return null;
    }
}

