/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class RefreshAction
extends WorkspaceAction {
    public static final String ID = "org.eclipse.ui.RefreshAction";

    @Deprecated
    public RefreshAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RefreshAction_text);
        this.initAction();
    }

    public RefreshAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.RefreshAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RefreshAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.refresh_action_context");
    }

    void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        IFileInfo location = IDEResourceInfoUtils.getFileInfo(project.getLocationURI());
        if (!location.exists()) {
            String message = NLS.bind((String)IDEWorkbenchMessages.RefreshAction_locationDeletedMessage, (Object)project.getName(), (Object)location.toString());
            final MessageDialog dialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.RefreshAction_dialogTitle, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() == 0) {
                project.delete(true, true, null);
            }
        }
    }

    @Override
    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RefreshAction_progressMessage;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RefreshAction_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RefreshAction_problemTitle;
    }

    @Override
    protected List getSelectedResources() {
        ArrayList<IWorkspaceRoot> resources = super.getSelectedResources();
        if (resources.isEmpty()) {
            resources = new ArrayList<IWorkspaceRoot>();
            resources.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        return resources;
    }

    @Override
    protected boolean updateSelection(IStructuredSelection s) {
        return (super.updateSelection(s) || s.isEmpty()) && this.getSelectedNonResources().size() == 0;
    }

    public void handleKeyReleased(KeyEvent event) {
        if (event.keyCode == 0x100000E && event.stateMask == 0) {
            this.refreshAll();
        }
    }

    public final void refreshAll() {
        IStructuredSelection currentSelection = this.getStructuredSelection();
        this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.run();
        this.selectionChanged(currentSelection);
    }

    @Override
    protected final IRunnableWithProgress createOperation(final IStatus[] errorStatus) {
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        List actionResources = new ArrayList(this.getActionResources());
        if (this.shouldPerformResourcePruning()) {
            actionResources = this.pruneResources(actionResources);
        }
        final ArrayList resources = actionResources;
        Iterator res = resources.iterator();
        while (res.hasNext()) {
            rule = MultiRule.combine(rule, (ISchedulingRule)factory.refreshRule((IResource)res.next()));
        }
        return new WorkspaceModifyOperation(rule){

            @Override
            public void execute(IProgressMonitor monitor) {
                MultiStatus errors = null;
                monitor.beginTask("", resources.size() * 1000);
                monitor.setTaskName(RefreshAction.this.getOperationMessage());
                Iterator resourcesEnum = resources.iterator();
                try {
                    while (resourcesEnum.hasNext()) {
                        try {
                            IResource resource = (IResource)resourcesEnum.next();
                            RefreshAction.this.refreshResource(resource, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        }
                        catch (CoreException e) {
                            errors = RefreshAction.this.recordError(errors, e);
                        }
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    if (errors != null) {
                        errorStatus[0] = errors;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    protected void refreshResource(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource.getType() == 4) {
            this.checkLocationDeleted((IProject)resource);
        } else if (resource.getType() == 8) {
            IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
            int i = 0;
            while (i < projects.length) {
                this.checkLocationDeleted(projects[i]);
                ++i;
            }
        }
        resource.refreshLocal(2, monitor);
    }

    @Override
    public void run() {
        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
        final WorkspaceModifyOperation op = (WorkspaceModifyOperation)this.createOperation(errorStatus);
        WorkspaceJob job = new WorkspaceJob("refresh"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    op.run(monitor);
                }
                catch (InvocationTargetException e) {
                    String msg = NLS.bind((String)IDEWorkbenchMessages.WorkspaceAction_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)e.getTargetException());
                    throw new CoreException(StatusUtil.newStatus(4, msg, e.getTargetException()));
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return errorStatus[0];
            }
        };
        ISchedulingRule rule = op.getRule();
        if (rule != null) {
            job.setRule(rule);
        }
        job.setUser(true);
        job.schedule();
    }
}

