/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfsRepositoryBuilder<B extends DfsRepositoryBuilder, R extends DfsRepository>
extends BaseRepositoryBuilder<B, R> {
    private DfsReaderOptions readerOptions;
    private DfsRepositoryDescription repoDesc;

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    public B setReaderOptions(DfsReaderOptions opt) {
        this.readerOptions = opt;
        return (B)((DfsRepositoryBuilder)this.self());
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public B setRepositoryDescription(DfsRepositoryDescription desc) {
        this.repoDesc = desc;
        return (B)((DfsRepositoryBuilder)this.self());
    }

    @Override
    public B setup() throws IllegalArgumentException, IOException {
        super.setup();
        if (this.getReaderOptions() == null) {
            this.setReaderOptions(new DfsReaderOptions());
        }
        if (this.getRepositoryDescription() == null) {
            this.setRepositoryDescription(new DfsRepositoryDescription());
        }
        return (B)((DfsRepositoryBuilder)this.self());
    }

    @Override
    public abstract R build() throws IOException;

    @Override
    public B setGitDir(File gitDir) {
        if (gitDir != null) {
            throw new IllegalArgumentException();
        }
        return (B)((DfsRepositoryBuilder)this.self());
    }

    @Override
    public B setObjectDirectory(File objectDirectory) {
        if (objectDirectory != null) {
            throw new IllegalArgumentException();
        }
        return (B)((DfsRepositoryBuilder)this.self());
    }

    @Override
    public B addAlternateObjectDirectory(File other) {
        throw new UnsupportedOperationException("Alternates not supported");
    }

    @Override
    public B setWorkTree(File workTree) {
        if (workTree != null) {
            throw new IllegalArgumentException();
        }
        return (B)((DfsRepositoryBuilder)this.self());
    }

    @Override
    public B setIndexFile(File indexFile) {
        if (indexFile != null) {
            throw new IllegalArgumentException();
        }
        return (B)((DfsRepositoryBuilder)this.self());
    }
}

