/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.search.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.search.tags.parser.TagsLexer;
import org.eclipse.rcptt.core.search.tags.parser.TagsParser;

public class TagsSearch {
    public static IQ7NamedElement[] findAllByExpression(String expression) {
        CommonTree tree = TagsSearch.createTree(expression);
        if (tree == null) {
            return new IQ7NamedElement[0];
        }
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        Map tagsRefsMap = Q7SearchCore.findAllTagReferences();
        for (Map.Entry entry : tagsRefsMap.entrySet()) {
            if (!TagsSearch.eval(tree, (List)entry.getValue())) continue;
            result.add((IQ7NamedElement)entry.getKey());
        }
        return result.toArray(new IQ7NamedElement[result.size()]);
    }

    private static CommonTree createTree(String expression) {
        CommonTree ast = null;
        try {
            ANTLRStringStream input = new ANTLRStringStream(expression);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)new TagsLexer((CharStream)input));
            TagsParser parser = new TagsParser((TokenStream)tokens);
            TagsParser.expression_return ret = parser.expression();
            ast = (CommonTree)ret.getTree();
        }
        catch (RecognitionException recognitionException) {}
        return ast;
    }

    private static boolean eval(CommonTree tree, List<String> tags) {
        if (tree != null) {
            if (tree.getType() == 6) {
                return tags.contains(tree.getText());
            }
            if (tree.getType() == 4) {
                if (tree.getChildren() == null) {
                    return false;
                }
                boolean result = true;
                for (Object subtree : tree.getChildren()) {
                    if (TagsSearch.eval((CommonTree)subtree, tags)) continue;
                    result = false;
                    break;
                }
                return result;
            }
            if (tree.getType() == 7) {
                if (tree.getChildren() == null) {
                    return false;
                }
                boolean result = false;
                for (Object subtree : tree.getChildren()) {
                    if (!TagsSearch.eval((CommonTree)subtree, tags)) continue;
                    result = true;
                    break;
                }
                return result;
            }
        }
        return false;
    }
}

