/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.ui.Activator;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.ui.IStartup;

public class CleanBundlePoolStartup
implements IStartup {
    private static final String LAST_RUNTIME_VERSION = "last.runtime.version";

    public void earlyStartup() {
        Job job = new Job("Check RCPTT Runtime"){

            public boolean belongsTo(Object family) {
                return "q7.clean.bundle.pool.job".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                String version = RcpttCore.getRuntimeVersion();
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                String lastRuntimeVersion = store.getString(CleanBundlePoolStartup.LAST_RUNTIME_VERSION);
                if (version == null || !version.equals(lastRuntimeVersion)) {
                    if (version != null) {
                        store.putValue(CleanBundlePoolStartup.LAST_RUNTIME_VERSION, version);
                    }
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                ILaunchConfiguration[] configurations;
                                ILaunchConfiguration[] iLaunchConfigurationArray = configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                                int n = configurations.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ILaunchConfiguration cfg = iLaunchConfigurationArray[n2];
                                    String platform = cfg.getAttribute("aut-target-platform", "");
                                    LaunchInfoCache.remove((ILaunchConfiguration)cfg);
                                    if (platform.length() > 0) {
                                        TargetPlatformManager.deleteTargetPlatform((String)platform);
                                        Q7LaunchUtils.deleteConfigFiles((ILaunchConfiguration)cfg);
                                        Q7TargetPlatformManager.clear();
                                    }
                                    ++n2;
                                }
                                Q7LaunchingUtil.cleanBundlePool((IProgressMonitor)monitor);
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().log("Failed to update RCPTT runtime.", e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

