/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.LaunchAdapter;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.ui.commons.OneSelectionListener;
import org.eclipse.rcptt.ui.editors.TextUtils;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.tags.SelectTagDialog;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormImages;

public abstract class EditorHeader {
    protected DataBindingContext dbc = new DataBindingContext();
    protected StyledText nameText;
    protected ControlDecoration nameDecoration;
    protected Button addTag;
    protected StyledText tagsControl;
    private Button recordButton;
    private Button replayButton;
    private Label nameLabel;
    private Label tagsLabel;
    private IQ7NamedElement model;
    private NamedElement element;
    private Binding nameBinding;
    private Binding tagsBinging;

    public EditorHeader(IQ7NamedElement model, NamedElement element) {
        this.model = model;
        this.element = element;
    }

    public IQ7NamedElement getModel() {
        return this.model;
    }

    public NamedElement getElement() {
        return this.element;
    }

    public DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    public StyledText getTagsControl() {
        return this.tagsControl;
    }

    public Button getRecordButton() {
        return this.recordButton;
    }

    public Button getReplayButton() {
        return this.replayButton;
    }

    public Composite createContent(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).equalWidth(true).applyTo(parent);
        this.createGeneral(parent, toolkit);
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).equalWidth(true).applyTo(composite);
        this.update(this.model, this.element);
        return composite;
    }

    protected void createGeneral(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().numColumns(this.getTotalColumns()).spacing(10, 4).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)composite);
        this.createNameControl(composite, toolkit);
        this.recordButton = this.createRecordButton(composite, toolkit);
        this.createTagControl(composite, toolkit);
        this.replayButton = this.createReplayButton(composite, toolkit);
        int height = composite.computeSize((int)-1, (int)-1).y;
        Color top = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        Image gradientImage = FormImages.getInstance().getGradient(new Color[]{top, bot}, new int[]{100}, height, true, toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"), composite.getDisplay());
        composite.setBackgroundImage(gradientImage);
        Composite c1 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c1);
        c1.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        Composite c2 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c2);
        c2.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
    }

    protected int getTotalColumns() {
        return 4;
    }

    public void focus() {
        this.nameText.setFocus();
    }

    protected void createNameControl(Composite parent, FormToolkit toolkit) {
        this.nameLabel = this.createLabel(parent, toolkit, Messages.NamedElementEditorPage_NameLabel);
        this.nameText = this.createWrappedText(parent, toolkit, this.element.getName(), 2);
        this.nameText.setBackground(null);
        this.nameDecoration = new ControlDecoration((Control)this.nameText, 16512);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.nameDecoration.setImage(errorFieldIndicator.getImage());
        this.nameDecoration.setMarginWidth(2);
        this.nameDecoration.setShowHover(true);
        this.nameDecoration.hide();
    }

    protected Menu createTextMenu(final StyledText text) {
        Menu menu = new Menu((Control)text);
        MenuItem copy = new MenuItem(menu, 8);
        copy.setText("Copy");
        copy.addSelectionListener((SelectionListener)new OneSelectionListener(){

            @Override
            public void selected(SelectionEvent e) {
                if (TextUtils.canCopy(text)) {
                    TextUtils.copy(text);
                }
            }
        });
        MenuItem paste = new MenuItem(menu, 8);
        paste.setText("Paste");
        paste.addSelectionListener((SelectionListener)new OneSelectionListener(){

            @Override
            public void selected(SelectionEvent e) {
                if (TextUtils.canPaste(text)) {
                    TextUtils.paste(text);
                }
            }
        });
        MenuItem cut = new MenuItem(menu, 8);
        cut.setText("Cut");
        cut.addSelectionListener((SelectionListener)new OneSelectionListener(){

            @Override
            public void selected(SelectionEvent e) {
                if (TextUtils.canCut(text)) {
                    TextUtils.cut(text);
                }
            }
        });
        return menu;
    }

    protected StyledText createWrappedText(Composite parent, FormToolkit toolkit, String text, int hSpan) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(hSpan, 1).grab(true, false).applyTo((Control)composite);
        StyledText textControl = new StyledText(composite, 0x804 | toolkit.getBorderStyle() | toolkit.getOrientation());
        textControl.setText(text);
        toolkit.adapt((Composite)textControl);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(111, -1).applyTo((Control)textControl);
        textControl.setBackground(null);
        textControl.setMenu(this.createTextMenu(textControl));
        return textControl;
    }

    protected void createTagControl(Composite parent, FormToolkit toolkit) {
        this.tagsLabel = this.createLabel(parent, toolkit, Messages.NamedElementEditorPage_TagsLabel);
        Composite tags = toolkit.createComposite(parent, 0);
        tags.setBackground(null);
        GridLayoutFactory.fillDefaults().spacing(3, 0).numColumns(2).margins(0, 0).applyTo(tags);
        GridDataFactory.fillDefaults().grab(true, false).span(this.getTagsSpacing(), 1).applyTo((Control)tags);
        this.tagsControl = new StyledText(tags, 0x804 | toolkit.getBorderStyle() | toolkit.getOrientation());
        toolkit.adapt((Composite)this.tagsControl);
        this.tagsControl.setBackground(null);
        this.tagsControl.setMenu(this.createTextMenu(this.tagsControl));
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.tagsControl);
        this.addTag = toolkit.createButton(tags, "", 8);
        this.addTag.setToolTipText(Messages.NamedElementEditorPage_AddTagButton);
        this.addTag.setBackground(null);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)this.addTag);
        this.addTag.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD").createImage());
        this.addTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List existingTags = TagsUtil.extractTags((String)EditorHeader.this.element.getTags());
                SelectTagDialog dialog = new SelectTagDialog(EditorHeader.this.tagsControl.getShell(), existingTags);
                if (dialog.open() == 0) {
                    StringBuilder sb = new StringBuilder(EditorHeader.this.element.getTags());
                    boolean first = existingTags.isEmpty();
                    if (!dialog.getResult().isEmpty()) {
                        for (Tag tag : dialog.getResult()) {
                            if (!first) {
                                sb.append(", ");
                            } else {
                                first = false;
                            }
                            sb.append(tag.getPath());
                        }
                        EditorHeader.this.element.setTags(sb.toString());
                    } else if (dialog.getTagName() != null) {
                        if (sb.toString().length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(dialog.getTagName().trim());
                        EditorHeader.this.element.setTags(sb.toString());
                    }
                }
            }
        });
    }

    protected int getTagsSpacing() {
        return 2;
    }

    protected Button createRecordButton(Composite composite, FormToolkit toolkit) {
        Button button = toolkit.createButton(composite, Messages.NamedElementEditorPage_RecordButton, 8);
        button.setImage(Images.getImageDescriptor("icons/recording/record.gif").createImage());
        button.setBackground(null);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorHeader.this.record();
            }
        });
        return button;
    }

    protected Button createReplayButton(Composite composite, FormToolkit toolkit) {
        Button button = toolkit.createButton(composite, Messages.NamedElementEditorPage_ReplayButton, 8);
        button.setImage(DebugUITools.getImageDescriptor((String)"IMG_ACT_RUN").createImage());
        button.setBackground(null);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((e.stateMask & 0x20000) != 0) {
                    EditorHeader.this.multiReplay();
                } else {
                    EditorHeader.this.replay();
                }
            }
        });
        return button;
    }

    protected Label createLabel(Composite parent, FormToolkit toolkit, String label) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)labelControl);
        labelControl.setBackground(null);
        return labelControl;
    }

    protected void setBackgroundToHeaderLabel(Label label, Image backgroundImage) {
        Rectangle bounds = label.getBounds();
        bounds.x = 0;
        bounds.width = 1;
        final Image image = new Image((Device)label.getDisplay(), bounds);
        GC gc = new GC((Drawable)image);
        gc.drawImage(backgroundImage, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
        gc.dispose();
        label.setBackgroundImage(image);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected abstract void record();

    protected void replay() {
        IResource res = this.model.getResource();
        if (res == null) {
            return;
        }
        LaunchUtils.launchContext(new IResource[]{res}, "run");
    }

    private static int getReplayCount() {
        InputDialog in = new InputDialog(null, Messages.NamedElementEditorPage_RunCounterDialogTitle, Messages.NamedElementEditorPage_RunCounterDialogLabel, Messages.NamedElementEditorPage_RunCounterDialogDefaultValue, new IInputValidator(){

            public String isValid(String newText) {
                try {
                    int value = Integer.parseInt(newText);
                    if (value <= 0) {
                        return Messages.NamedElementEditorPage_RunCounterDialogNeagtiveIntErrorMsg;
                    }
                }
                catch (Throwable throwable) {
                    return Messages.NamedElementEditorPage_RunCounterDialogIncorrectIntErrorMsg;
                }
                return null;
            }
        });
        if (in.open() != 0) {
            return -1;
        }
        return Integer.parseInt(in.getValue());
    }

    private static boolean resourceSaved(IResource res) {
        try {
            return LaunchUtils.saveChanges(new IResource[]{res});
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    protected void multiReplay() {
        final IResource res = this.model.getResource();
        if (res == null) {
            return;
        }
        int count = EditorHeader.getReplayCount();
        if (count == -1) {
            return;
        }
        if (!EditorHeader.resourceSaved(res)) {
            return;
        }
        final AtomicInteger countAtom = new AtomicInteger(count);
        final Job execJob = new Job("Times execute"){

            protected IStatus run(IProgressMonitor monitor) {
                LaunchUtils.runResource(res);
                return Status.OK_STATUS;
            }
        };
        LaunchAdapter listener = new LaunchAdapter(){

            public void launchStatusChanged(IExecutable ... executable) {
                IExecutable[] iExecutableArray = executable;
                int n = executable.length;
                int n2 = 0;
                while (n2 < n) {
                    IExecutable e = iExecutableArray[n2];
                    if (e.getStatus() == 3) {
                        countAtom.set(0);
                    }
                    ++n2;
                }
            }

            public void finished() {
                if (countAtom.decrementAndGet() > 0) {
                    execJob.schedule(500L);
                }
            }
        };
        Job cancelationJob = new Job("Times execution", (ILaunchListener)listener){
            private final /* synthetic */ ILaunchListener val$listener;
            {
                this.val$listener = iLaunchListener;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                int count = countAtom.get();
                monitor.beginTask("Times", count);
                while (!monitor.isCanceled() && (count = countAtom.get()) > 0) {
                    Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    monitor.worked(count - countAtom.get());
                }
                countAtom.set(0);
                Q7Launcher.getInstance().removeListener(this.val$listener);
                return Status.OK_STATUS;
            }
        };
        cancelationJob.schedule();
        cancelationJob.setPriority(30);
        Q7Launcher.getInstance().addListener((ILaunchListener)listener);
        execJob.schedule();
    }

    public boolean isInFocus() {
        return this.nameText.isFocusControl() || this.tagsControl.isFocusControl();
    }

    public void doSelectAll() {
        if (this.nameText.isFocusControl()) {
            this.nameText.selectAll();
        } else if (this.tagsControl.isFocusControl()) {
            this.tagsControl.selectAll();
        }
    }

    public void copy() {
        if (this.nameText.isFocusControl()) {
            TextUtils.copy(this.nameText);
        } else if (this.tagsControl.isFocusControl()) {
            TextUtils.copy(this.tagsControl);
        }
    }

    public boolean canCopy() {
        if (this.nameText.isFocusControl()) {
            return TextUtils.canCopy(this.nameText);
        }
        if (this.tagsControl.isFocusControl()) {
            return TextUtils.canCopy(this.tagsControl);
        }
        return false;
    }

    public boolean canPaste() {
        if (this.nameText.isFocusControl()) {
            return TextUtils.canPaste(this.nameText);
        }
        if (this.tagsControl.isFocusControl()) {
            return TextUtils.canPaste(this.tagsControl);
        }
        return false;
    }

    public boolean canCut() {
        if (this.nameText.isFocusControl()) {
            return TextUtils.canCut(this.nameText);
        }
        if (this.tagsControl.isFocusControl()) {
            return TextUtils.canCut(this.tagsControl);
        }
        return false;
    }

    public void paste() {
        if (this.nameText.isFocusControl()) {
            TextUtils.paste(this.nameText);
        } else if (this.tagsControl.isFocusControl()) {
            TextUtils.paste(this.tagsControl);
        }
    }

    public void cut() {
        if (this.nameText.isFocusControl()) {
            TextUtils.cut(this.nameText);
        } else if (this.tagsControl.isFocusControl()) {
            TextUtils.cut(this.tagsControl);
        }
    }

    private IStatus nameFail(String message) {
        this.nameDecoration.setDescriptionText(message);
        this.nameDecoration.show();
        return Status.CANCEL_STATUS;
    }

    private IStatus nameWin() {
        this.nameDecoration.hide();
        return Status.OK_STATUS;
    }

    public void update(IQ7NamedElement model, NamedElement element) {
        this.model = model;
        this.element = element;
        if (this.nameText != null) {
            if (this.nameBinding != null) {
                this.nameBinding.dispose();
            }
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    String text = (String)value;
                    if (StringUtils.isBlank((String)text)) {
                        return EditorHeader.this.nameFail("Name must be non-blank string.");
                    }
                    return EditorHeader.this.nameWin();
                }
            });
            this.nameBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.nameText, (int)24), EMFObservables.observeValue((EObject)element, (EStructuralFeature)ScenarioPackage.eINSTANCE.getNamedElement_Name()), strategy, null);
        }
        if (this.tagsControl != null) {
            if (this.tagsBinging != null) {
                this.tagsBinging.dispose();
            }
            this.tagsBinging = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.tagsControl, (int)24), EMFProperties.value((EStructuralFeature)ScenarioPackage.Literals.NAMED_ELEMENT__TAGS).observe((Object)element));
        }
    }

    public void doTextCommand(int fAction) {
        if (this.nameText.isFocusControl()) {
            this.nameText.invokeAction(fAction);
        } else if (this.tagsControl.isFocusControl()) {
            this.tagsControl.invokeAction(fAction);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public void undo() {
    }

    public void redo() {
    }

    protected StyledText getNameControl() {
        return this.nameText;
    }
}

