/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class PushBranchActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        try {
            PushBranchWizard wizard = null;
            Ref ref = this.getBranchRef(repository);
            if (ref != null) {
                wizard = new PushBranchWizard(repository, ref);
            } else {
                ObjectId id = repository.resolve(repository.getFullBranch());
                wizard = new PushBranchWizard(repository, id);
            }
            WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wizard);
            dlg.open();
        }
        catch (IOException ex) {
            Activator.handleError(ex.getLocalizedMessage(), ex, false);
        }
        return null;
    }

    public boolean isEnabled() {
        Repository repository = this.getRepository();
        return repository != null;
    }

    private Ref getBranchRef(Repository repository) {
        try {
            String fullBranch = repository.getFullBranch();
            if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                return repository.getRef(fullBranch);
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getLocalizedMessage(), e, false);
        }
        return null;
    }
}

