/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchProjectTracker;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CheckoutDialog;
import org.eclipse.egit.ui.internal.dialogs.DeleteBranchDialog;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesDialog;
import org.eclipse.egit.ui.internal.dialogs.RenameBranchDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchOperationUI {
    private static final int MODE_CREATE = 1;
    private static final int MODE_CHECKOUT = 2;
    private static final int MODE_DELETE = 3;
    private static final int MODE_RENAME = 4;
    private final Repository repository;
    private String target;
    private String base;
    private final boolean showQuestionAboutTarget;
    private final int mode;

    public static BranchOperationUI rename(Repository repository) {
        return new BranchOperationUI(repository, 4);
    }

    public static BranchOperationUI delete(Repository repository) {
        return new BranchOperationUI(repository, 3);
    }

    public static BranchOperationUI create(Repository repository) {
        BranchOperationUI op = new BranchOperationUI(repository, 1);
        return op;
    }

    public static BranchOperationUI createWithRef(Repository repository, String baseRef) {
        BranchOperationUI op = new BranchOperationUI(repository, 1);
        op.base = baseRef;
        return op;
    }

    public static BranchOperationUI checkout(Repository repository) {
        return new BranchOperationUI(repository, 2);
    }

    public static BranchOperationUI checkout(Repository repository, String target) {
        return new BranchOperationUI(repository, target, true);
    }

    public static BranchOperationUI checkoutWithoutQuestion(Repository repository, String target) {
        return new BranchOperationUI(repository, target, false);
    }

    public static boolean checkoutWillShowQuestionDialog(String refName) {
        return BranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(refName);
    }

    private BranchOperationUI(Repository repository, String target, boolean showQuestionAboutTarget) {
        this.repository = repository;
        this.target = target;
        this.showQuestionAboutTarget = showQuestionAboutTarget;
        this.mode = 0;
    }

    private BranchOperationUI(Repository repository, int mode) {
        this.repository = repository;
        this.mode = mode;
        this.showQuestionAboutTarget = true;
    }

    public void start() {
        if (!this.repository.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)this.repository.getRepositoryState().getDescription()));
            return;
        }
        if (this.shouldCancelBecauseOfRunningLaunches()) {
            return;
        }
        this.askForTargetIfNecessary();
        if (this.target == null) {
            return;
        }
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        String jobname = NLS.bind((String)UIText.BranchAction_checkingOut, (Object)repoName, (Object)this.target);
        final boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        final BranchOperation bop = new BranchOperation(this.repository, this.target, !restore);
        WorkspaceJob job = new WorkspaceJob(jobname){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    try {
                        if (restore) {
                            final BranchProjectTracker tracker = new BranchProjectTracker(BranchOperationUI.this.repository);
                            final AtomicReference memento = new AtomicReference();
                            bop.addPreExecuteTask(new IEGitOperation.PreExecuteTask(){

                                public void preExecute(Repository pRepo, IProgressMonitor pMonitor) throws CoreException {
                                    memento.set(tracker.snapshot());
                                }
                            });
                            bop.addPostExecuteTask(new IEGitOperation.PostExecuteTask(){

                                public void postExecute(Repository pRepo, IProgressMonitor pMonitor) throws CoreException {
                                    IMemento snapshot = (IMemento)memento.get();
                                    if (snapshot == null) {
                                        return;
                                    }
                                    tracker.save(snapshot).restore(pMonitor);
                                }
                            });
                        }
                        bop.execute(monitor);
                    }
                    catch (CoreException e) {
                        switch (bop.getResult().getStatus()) {
                            case CONFLICTS: 
                            case NONDELETED: {
                                break;
                            }
                            default: {
                                IStatus iStatus = Activator.createErrorStatus(UIText.BranchAction_branchFailed, e);
                                GitLightweightDecorator.refresh();
                                return iStatus;
                            }
                        }
                        GitLightweightDecorator.refresh();
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CHECKOUT.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        if (restore) {
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                BranchOperationUI.this.show(bop.getResult());
            }
        });
        job.schedule();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (!this.repository.getRepositoryState().canCheckout()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)BranchOperationUI.this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)BranchOperationUI.this.repository.getRepositoryState().getDescription()));
                }
            });
            return;
        }
        if (this.shouldCancelBecauseOfRunningLaunches()) {
            return;
        }
        this.askForTargetIfNecessary();
        if (this.target == null) {
            return;
        }
        BranchOperation bop = new BranchOperation(this.repository, this.target);
        bop.execute(monitor);
        this.show(bop.getResult());
    }

    private void askForTargetIfNecessary() {
        if (this.target == null) {
            this.target = this.getTargetWithDialog();
        }
        if (this.target != null && this.showQuestionAboutTarget && BranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(this.target)) {
            this.target = this.getTargetWithCheckoutRemoteTrackingDialog();
        }
    }

    private static boolean shouldShowCheckoutRemoteTrackingDialog(String refName) {
        boolean isRemoteTrackingBranch;
        boolean bl = isRemoteTrackingBranch = refName != null && refName.startsWith("refs/remotes/");
        if (isRemoteTrackingBranch) {
            boolean showDetachedHeadWarning = Activator.getDefault().getPreferenceStore().getBoolean("show_detached_head_warning");
            return showDetachedHeadWarning;
        }
        return false;
    }

    private String getTargetWithDialog() {
        final String[] dialogResult = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialogResult[0] = BranchOperationUI.this.getTargetWithDialogInUI();
            }
        });
        return dialogResult[0];
    }

    private String getTargetWithDialogInUI() {
        CheckoutDialog dialog;
        switch (this.mode) {
            case 2: {
                dialog = new CheckoutDialog(this.getShell(), this.repository);
                break;
            }
            case 1: {
                CreateBranchWizard wiz;
                try {
                    if (this.base == null) {
                        this.base = this.repository.getFullBranch();
                    }
                    wiz = new CreateBranchWizard(this.repository, this.base);
                }
                catch (IOException iOException) {
                    wiz = new CreateBranchWizard(this.repository);
                }
                new WizardDialog(this.getShell(), (IWizard)wiz).open();
                return null;
            }
            case 3: {
                new DeleteBranchDialog(this.getShell(), this.repository).open();
                return null;
            }
            case 4: {
                new RenameBranchDialog(this.getShell(), this.repository).open();
                return null;
            }
            default: {
                return null;
            }
        }
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getRefName();
    }

    private String getTargetWithCheckoutRemoteTrackingDialog() {
        final String[] dialogResult = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialogResult[0] = BranchOperationUI.this.getTargetWithCheckoutRemoteTrackingDialogInUI();
            }
        });
        return dialogResult[0];
    }

    private String getTargetWithCheckoutRemoteTrackingDialogInUI() {
        String[] buttons = new String[]{UIText.BranchOperationUI_CheckoutRemoteTrackingAsLocal, UIText.BranchOperationUI_CheckoutRemoteTrackingCommit, IDialogConstants.CANCEL_LABEL};
        MessageDialog questionDialog = new MessageDialog(this.getShell(), UIText.BranchOperationUI_CheckoutRemoteTrackingTitle, null, UIText.BranchOperationUI_CheckoutRemoteTrackingQuestion, 3, buttons, 0);
        int result = questionDialog.open();
        if (result == 0) {
            CreateBranchWizard wizard = new CreateBranchWizard(this.repository, this.target);
            WizardDialog createBranchDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            createBranchDialog.open();
            return null;
        }
        if (result == 1) {
            return this.target;
        }
        return null;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public void show(final CheckoutResult result) {
        if (result.getStatus() == CheckoutResult.Status.CONFLICTS) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, UIText.BranchResultDialog_CheckoutConflictsTitle, NLS.bind((String)UIText.BranchResultDialog_CheckoutConflictsMessage, (Object)Repository.shortenRefName((String)BranchOperationUI.this.target)), BranchOperationUI.this.repository, result.getConflictList());
                    cleanupUncomittedChangesDialog.open();
                    if (cleanupUncomittedChangesDialog.shouldContinue()) {
                        BranchOperationUI op = BranchOperationUI.checkoutWithoutQuestion(BranchOperationUI.this.repository, BranchOperationUI.this.target);
                        op.start();
                    }
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.NONDELETED) {
            boolean show = false;
            List pathList = result.getUndeletedList();
            for (String path : pathList) {
                if (!new File(this.repository.getWorkTree(), path).exists()) continue;
                show = true;
                break;
            }
            if (!show) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new NonDeletedFilesDialog(shell, BranchOperationUI.this.repository, result.getUndeletedList()).open();
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.OK && RepositoryUtil.isDetachedHead((Repository)this.repository)) {
            this.showDetachedHeadWarning();
        }
    }

    private void showDetachedHeadWarning() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store.getBoolean("show_detached_head_warning")) {
                    String toggleMessage = UIText.BranchResultDialog_DetachedHeadWarningDontShowAgain;
                    MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.BranchOperationUI_DetachedHeadTitle, (String)UIText.BranchOperationUI_DetachedHeadMessage, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"show_detached_head_warning");
                }
            }
        });
    }

    private boolean shouldCancelBecauseOfRunningLaunches() {
        if (this.mode == 2) {
            return false;
        }
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.getBoolean("show_running_launch_on_checkout_warning")) {
            return false;
        }
        final ILaunchConfiguration launchConfiguration = this.getRunningLaunchConfiguration();
        if (launchConfiguration != null) {
            final boolean[] dialogResult = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    dialogResult[0] = BranchOperationUI.this.showContinueDialogInUI(store, launchConfiguration);
                }
            });
            return dialogResult[0];
        }
        return false;
    }

    private boolean showContinueDialogInUI(IPreferenceStore store, ILaunchConfiguration launchConfiguration) {
        String[] buttons = new String[]{UIText.BranchOperationUI_Continue, IDialogConstants.CANCEL_LABEL};
        String message = NLS.bind((String)UIText.BranchOperationUI_RunningLaunchMessage, (Object)launchConfiguration.getName());
        MessageDialogWithToggle continueDialog = new MessageDialogWithToggle(this.getShell(), UIText.BranchOperationUI_RunningLaunchTitle, null, message, 0, buttons, 0, UIText.BranchOperationUI_RunningLaunchDontShowAgain, false);
        int result = continueDialog.open();
        if (result == 1 || result == -1) {
            return true;
        }
        boolean dontWarnAgain = continueDialog.getToggleState();
        if (dontWarnAgain) {
            store.setValue("show_running_launch_on_checkout_warning", false);
        }
        return false;
    }

    private ILaunchConfiguration getRunningLaunchConfiguration() {
        ILaunch[] launches;
        HashSet<IProject> projects = new HashSet<IProject>(Arrays.asList(ProjectUtil.getProjects((Repository)this.repository)));
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceLookupDirector director;
            ISourceContainer[] containers;
            ISourceLocator locator;
            ILaunch launch = iLaunchArray[n2];
            if (!launch.isTerminated() && (locator = launch.getSourceLocator()) instanceof ISourceLookupDirector && this.isAnyProjectInSourceContainers(containers = (director = (ISourceLookupDirector)locator).getSourceContainers(), projects)) {
                return launch.getLaunchConfiguration();
            }
            ++n2;
        }
        return null;
    }

    private boolean isAnyProjectInSourceContainers(ISourceContainer[] containers, Set<IProject> projects) {
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectSourceContainer projectContainer;
            ISourceContainer container = iSourceContainerArray[n2];
            if (container instanceof ProjectSourceContainer && projects.contains((projectContainer = (ProjectSourceContainer)container).getProject())) {
                return true;
            }
            try {
                boolean found = this.isAnyProjectInSourceContainers(container.getSourceContainers(), projects);
                if (found) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return false;
    }
}

