/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BranchConfigurationDialog
extends TitleAreaDialog {
    private final String myBranchName;
    private final Repository myRepository;
    private final StoredConfig myConfig;
    private final String myTitle;
    private Combo remoteText;
    private Combo branchText;
    private Button rebase;

    public BranchConfigurationDialog(Shell shell, String branchName, Repository repository) {
        super(shell);
        this.myBranchName = branchName;
        this.myRepository = repository;
        this.myConfig = this.myRepository.getConfig();
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.myTitle = UIText.BranchConfigurationDialog_BranchConfigurationTitle;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 5).applyTo((Control)main);
        Label remoteLabel = new Label(main, 0);
        remoteLabel.setText(UIText.BranchConfigurationDialog_RemoteLabel);
        this.remoteText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteText);
        Label branchLabel = new Label(main, 0);
        branchLabel.setText(UIText.BranchConfigurationDialog_UpstreamBranchLabel);
        this.branchText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        this.remoteText.add(".");
        for (String remote : this.myConfig.getSubsections("remote")) {
            this.remoteText.add(remote);
        }
        this.remoteText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchConfigurationDialog.this.updateBranchItems();
            }
        });
        this.rebase = new Button(main, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.rebase);
        this.rebase.setText(UIText.BranchConfigurationDialog_RebaseLabel);
        String branch = this.myConfig.getString("branch", this.myBranchName, "merge");
        if (branch == null) {
            branch = "";
        }
        this.branchText.setText(branch);
        String remote = this.myConfig.getString("branch", this.myBranchName, "remote");
        if (remote == null) {
            remote = "";
        }
        this.remoteText.setText(remote);
        this.updateBranchItems();
        boolean rebaseFlag = this.myConfig.getBoolean("branch", this.myBranchName, "rebase", false);
        this.rebase.setSelection(rebaseFlag);
        BranchConfigurationDialog.applyDialogFont((Control)main);
        return main;
    }

    private void updateBranchItems() {
        String branchTextBefore = this.branchText.getText();
        this.branchText.removeAll();
        this.addBranchItems();
        this.branchText.setText(branchTextBefore);
    }

    private void addBranchItems() {
        String remote = this.remoteText.getText();
        try {
            if (remote.equals(".") || remote.length() == 0) {
                this.addBranchItemsForLocal();
            } else {
                this.addBranchItemsForRemote(remote);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.BranchConfigurationDialog_ExceptionGettingRefs, e);
        }
        catch (URISyntaxException e) {
            Activator.logError(UIText.BranchConfigurationDialog_ExceptionGettingRefs, e);
        }
    }

    private void addBranchItemsForLocal() throws IOException {
        Collection localRefs = this.myRepository.getRefDatabase().getRefs("refs/heads/").values();
        for (Ref ref : localRefs) {
            this.branchText.add(ref.getName());
        }
    }

    private void addBranchItemsForRemote(String remote) throws IOException, URISyntaxException {
        RemoteConfig remoteConfig = new RemoteConfig((Config)this.myConfig, remote);
        List fetchSpecs = remoteConfig.getFetchRefSpecs();
        if (fetchSpecs.isEmpty()) {
            return;
        }
        Collection allRefs = this.myRepository.getRefDatabase().getRefs("refs/").values();
        for (Ref ref : allRefs) {
            for (RefSpec fetchSpec : fetchSpecs) {
                if (!fetchSpec.matchDestination(ref)) continue;
                RefSpec source = fetchSpec.expandFromDestination(ref);
                String refNameOnRemote = source.getSource();
                this.branchText.add(refNameOnRemote);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.BranchConfigurationDialog_BranchConfigurationTitle);
    }

    public void create() {
        super.create();
        this.setTitle(this.myTitle);
        this.setMessage(NLS.bind((String)UIText.BranchConfigurationDialog_EditBranchConfigMessage, (Object)this.myBranchName));
    }

    protected void okPressed() {
        try {
            String merge = this.branchText.getText();
            if (merge.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "merge", merge);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "merge");
            }
            String remote = this.remoteText.getText();
            if (remote.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "remote", remote);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "remote");
            }
            boolean rebaseFlag = this.rebase.getSelection();
            if (rebaseFlag) {
                this.myConfig.setBoolean("branch", this.myBranchName, "rebase", true);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "rebase");
            }
            try {
                this.myConfig.save();
                super.okPressed();
            }
            catch (IOException e) {
                Activator.handleError(UIText.BranchConfigurationDialog_SaveBranchConfigFailed, e, true);
            }
        }
        catch (RuntimeException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }
}

