/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RebaseTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private boolean interactive = false;
    private boolean preserveMerges = false;

    public RebaseTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, RebaseTargetSelectionDialog.getMergeTarget(repo), 0x86 | RebaseTargetSelectionDialog.getSelectSetting(repo));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.RebaseTargetSelectionDialog_RebaseButton);
    }

    protected String getMessageText() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_DialogMessageWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_DialogMessage;
    }

    protected String getTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_DialogTitleWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_DialogTitle;
    }

    protected String getWindowTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_RebaseTitleWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_RebaseTitle;
    }

    protected void refNameSelected(String refName) {
        boolean currentSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        try {
            currentSelected = refName != null && refName.equals(this.repo.getFullBranch());
        }
        catch (IOException iOException) {
            currentSelected = false;
        }
        this.getButton(0).setEnabled(!currentSelected && (branchSelected || tagSelected));
    }

    protected void createCustomArea(Composite parent) {
        final Button interactivebutton = new Button(parent, 32);
        interactivebutton.setText(UIText.RebaseTargetSelectionDialog_InteractiveButton);
        interactivebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseTargetSelectionDialog.this.interactive = interactivebutton.getSelection();
            }
        });
        final Button preserveMergesButton = new Button(parent, 32);
        preserveMergesButton.setText(UIText.RebaseTargetSelectionDialog_PreserveMergesButton);
        preserveMergesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseTargetSelectionDialog.this.preserveMerges = preserveMergesButton.getSelection();
            }
        });
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isPreserveMerges() {
        return this.preserveMerges;
    }
}

