/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.DecorationOverlayDescriptor;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.ui.model.WorkbenchAdapter;

class RefUpdateElement
extends WorkbenchAdapter {
    private final RemoteRefUpdate update;
    private final PushOperationResult result;
    private final URIish uri;
    private final ObjectReader reader;
    private final Repository repo;
    private Object[] children;
    private final boolean tag;

    RefUpdateElement(PushOperationResult result, RemoteRefUpdate update, URIish uri, ObjectReader reader, Repository repo) {
        this.result = result;
        this.update = update;
        this.uri = uri;
        this.reader = reader;
        this.repo = repo;
        String remote = update.getRemoteName();
        this.tag = remote != null && remote.startsWith("refs/tags/");
    }

    URIish getUri() {
        return this.uri;
    }

    String getSrcRefName() {
        return this.update.getSrcRef();
    }

    String getDstRefName() {
        return this.update.getRemoteName();
    }

    boolean isDelete() {
        return this.getSrcRefName() == null;
    }

    boolean isAdd() {
        return this.getAdvertisedRemoteRef() == null;
    }

    boolean isRejected() {
        switch (this.getStatus()) {
            case REJECTED_NONFASTFORWARD: 
            case REJECTED_NODELETE: 
            case REJECTED_REMOTE_CHANGED: 
            case REJECTED_OTHER_REASON: {
                return true;
            }
        }
        return false;
    }

    boolean isTag() {
        return this.tag;
    }

    PushOperationResult getPushOperationResult() {
        return this.result;
    }

    boolean isSuccessfulConnection() {
        return this.result.isSuccessfulConnection(this.uri);
    }

    String getErrorMessage() {
        return this.result.getErrorMessage(this.uri);
    }

    RemoteRefUpdate.Status getStatus() {
        return this.update.getStatus();
    }

    RemoteRefUpdate getRemoteRefUpdate() {
        return this.update;
    }

    Ref getAdvertisedRemoteRef() {
        return this.result.getPushResult(this.uri).getAdvertisedRef(this.getDstRefName());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        switch (this.getStatus()) {
            case OK: {
                if (this.isDelete()) {
                    return this.tag ? new DecorationOverlayDescriptor(UIIcons.TAG, UIIcons.OVR_STAGED_REMOVE, 1) : new DecorationOverlayDescriptor(UIIcons.BRANCH, UIIcons.OVR_STAGED_REMOVE, 1);
                }
                if (this.isAdd()) {
                    return this.tag ? UIIcons.CREATE_TAG : UIIcons.CREATE_BRANCH;
                }
                return this.tag ? UIIcons.TAG : UIIcons.BRANCH;
            }
            case UP_TO_DATE: {
                return this.tag ? UIIcons.TAG : UIIcons.BRANCH;
            }
            case REJECTED_NONFASTFORWARD: 
            case REJECTED_NODELETE: 
            case REJECTED_REMOTE_CHANGED: 
            case REJECTED_OTHER_REASON: {
                return this.tag ? new DecorationOverlayDescriptor(UIIcons.TAG, UIIcons.OVR_ERROR, 1) : new DecorationOverlayDescriptor(UIIcons.BRANCH, UIIcons.OVR_ERROR, 1);
            }
        }
        return super.getImageDescriptor(object);
    }

    public String getLabel(Object object) {
        return this.getStyledText(object).getString();
    }

    private RepositoryCommit[] getCommits(Ref end) {
        RevWalk walk = new RevWalk(this.reader);
        try {
            walk.setRetainBody(true);
            walk.markStart(walk.parseCommit((AnyObjectId)this.update.getNewObjectId()));
            walk.markUninteresting(walk.parseCommit((AnyObjectId)end.getObjectId()));
            ArrayList<RepositoryCommit> commits = new ArrayList<RepositoryCommit>();
            for (RevCommit commit : walk) {
                commits.add(new RepositoryCommit(this.repo, commit));
            }
            return commits.toArray(new RepositoryCommit[commits.size()]);
        }
        catch (IOException e) {
            Activator.logError("Error parsing commits from push result", e);
            return new RepositoryCommit[0];
        }
    }

    public Object[] getChildren(Object object) {
        if (this.children != null) {
            return this.children;
        }
        switch (this.update.getStatus()) {
            case OK: {
                Ref ref;
                if (!this.isDelete() && (ref = this.getAdvertisedRemoteRef()) != null) {
                    this.children = this.getCommits(ref);
                    break;
                }
            }
            default: {
                this.children = super.getChildren(object);
            }
        }
        return this.children;
    }

    protected String shortenRef(String ref) {
        return NoteMap.shortenRefName((String)Repository.shortenRefName((String)ref));
    }

    public StyledString getStyledText(Object object) {
        StyledString styled = new StyledString();
        String remote = this.getDstRefName();
        String local = this.getSrcRefName();
        if (!this.tag && local != null) {
            styled.append(this.shortenRef(local));
            styled.append(" \u2192 ");
        }
        styled.append(this.shortenRef(remote));
        styled.append(' ');
        if (this.result.getURIs().size() > 1) {
            styled.append(MessageFormat.format(UIText.RefUpdateElement_UrisDecoration, this.uri.toString()), StyledString.QUALIFIER_STYLER);
            styled.append(' ');
        }
        switch (this.getStatus()) {
            case OK: {
                if (this.update.isDelete()) {
                    styled.append(UIText.PushResultTable_statusOkDeleted, StyledString.DECORATIONS_STYLER);
                    break;
                }
                Ref oldRef = this.getAdvertisedRemoteRef();
                if (oldRef == null) {
                    if (this.tag) {
                        styled.append(UIText.PushResultTable_statusOkNewTag, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    styled.append(UIText.PushResultTable_statusOkNewBranch, StyledString.DECORATIONS_STYLER);
                    break;
                }
                String separator = this.update.isFastForward() ? ".." : "...";
                styled.append(MessageFormat.format(UIText.RefUpdateElement_CommitRangeDecoration, this.update.getNewObjectId().abbreviate(7).name(), separator, oldRef.getObjectId().abbreviate(7).name()), StyledString.DECORATIONS_STYLER);
                styled.append(' ');
                styled.append(MessageFormat.format(UIText.RefUpdateElement_CommitCountDecoration, this.getChildren((Object)this).length), StyledString.COUNTER_STYLER);
                break;
            }
            case UP_TO_DATE: {
                styled.append(UIText.PushResultTable_statusUpToDate, StyledString.DECORATIONS_STYLER);
                break;
            }
            case NON_EXISTING: {
                styled.append(UIText.PushResultTable_statusNoMatch, StyledString.DECORATIONS_STYLER);
                break;
            }
            case REJECTED_NODELETE: 
            case REJECTED_REMOTE_CHANGED: {
                styled.append(UIText.PushResultTable_statusRejected, StyledString.DECORATIONS_STYLER);
                break;
            }
            case REJECTED_NONFASTFORWARD: {
                styled.append(UIText.RefUpdateElement_statusRejectedNonFastForward, StyledString.DECORATIONS_STYLER);
                break;
            }
            case REJECTED_OTHER_REASON: {
                styled.append(UIText.PushResultTable_statusRemoteRejected, StyledString.DECORATIONS_STYLER);
                break;
            }
        }
        return styled;
    }
}

