/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static IResource getResourceForLocation(IPath location) {
        URI uri;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = ResourceUtil.getFileForLocationURI(root, uri = URIUtil.toURI((IPath)location));
        if (file != null) {
            return file;
        }
        return ResourceUtil.getContainerForLocationURI(root, uri);
    }

    public static IFile getFileForLocation(IPath location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI uri = URIUtil.toURI((IPath)location);
        return ResourceUtil.getFileForLocationURI(root, uri);
    }

    public static IContainer getContainerForLocation(IPath location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI uri = URIUtil.toURI((IPath)location);
        return ResourceUtil.getContainerForLocationURI(root, uri);
    }

    public static IFile getFileForLocation(Repository repository, String repoRelativePath) {
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return ResourceUtil.getFileForLocation(path);
    }

    public static IContainer getContainerForLocation(Repository repository, String repoRelativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return root.getContainerForLocation(path);
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(Collection<IResource> resources) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IResource resource : resources) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(resource);
            if (repositoryMapping == null) continue;
            String path = repositoryMapping.getRepoRelativePath(resource);
            ResourceUtil.addPathToMap(repositoryMapping.getRepository(), path, result);
        }
        return result;
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(IResource[] resources) {
        return ResourceUtil.splitResourcesByRepository(Arrays.asList(resources));
    }

    public static Map<Repository, Collection<String>> splitPathsByRepository(Collection<IPath> paths) {
        RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IPath path : paths) {
            Repository repository = repositoryCache.getRepository(path);
            if (repository == null) continue;
            Path repoPath = new Path(repository.getWorkTree().getAbsolutePath());
            IPath repoRelativePath = path.makeRelativeTo((IPath)repoPath);
            ResourceUtil.addPathToMap(repository, repoRelativePath.toString(), result);
        }
        return result;
    }

    public static boolean isNonWorkspace(IResource resource) {
        return resource.getLocation() == null;
    }

    private static IFile getFileForLocationURI(IWorkspaceRoot root, URI uri) {
        IFile[] files = root.findFilesForLocationURI(uri);
        return (IFile)ResourceUtil.getExistingMappedResourceWithShortestPath((IResource[])files);
    }

    private static IContainer getContainerForLocationURI(IWorkspaceRoot root, URI uri) {
        IContainer[] containers = root.findContainersForLocationURI(uri);
        return (IContainer)ResourceUtil.getExistingMappedResourceWithShortestPath((IResource[])containers);
    }

    private static <T extends IResource> T getExistingMappedResourceWithShortestPath(T[] resources) {
        int shortestPathSegmentCount = Integer.MAX_VALUE;
        T shortestPath = null;
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath fullPath;
            int segmentCount;
            RepositoryProvider provider;
            T resource = TArray[n2];
            if (resource.exists() && (provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.egit.core.GitProvider")) != null && (segmentCount = (fullPath = resource.getFullPath()).segmentCount()) < shortestPathSegmentCount) {
                shortestPath = resource;
                shortestPathSegmentCount = segmentCount;
            }
            ++n2;
        }
        return shortestPath;
    }

    private static void addPathToMap(Repository repository, String path, Map<Repository, Collection<String>> result) {
        if (path != null) {
            Collection<String> resourcesList = result.get(repository);
            if (resourcesList == null) {
                resourcesList = new ArrayList<String>();
                result.put(repository, resourcesList);
            }
            resourcesList.add(path);
        }
    }

    public static ResourceMapping[] getResourceMappings(IResource resource, ResourceMappingContext context) {
        IModelProviderDescriptor[] modelDescriptors = ModelProvider.getModelProviderDescriptors();
        LinkedHashSet<ResourceMapping> mappings = new LinkedHashSet<ResourceMapping>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = modelDescriptors;
        int n = modelDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor candidate = iModelProviderDescriptorArray[n2];
            try {
                IResource[] resources = candidate.getMatchingResources(new IResource[]{resource});
                if (resources.length > 0) {
                    ResourceMapping[] modelMappings;
                    ModelProvider model = candidate.getModelProvider();
                    ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings(resource, context, (IProgressMonitor)new NullProgressMonitor());
                    int n3 = modelMappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceMapping mapping = resourceMappingArray[n4];
                        mappings.add(mapping);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public static void saveLocalHistory(Repository repository) {
        Collection<IResource> changedResources;
        IndexDiffCacheEntry indexDiffCacheEntry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        IndexDiffData indexDiffData = indexDiffCacheEntry.getIndexDiff();
        if (indexDiffData != null && (changedResources = indexDiffData.getChangedResources()) != null) {
            for (IResource changedResource : changedResources) {
                if (!(changedResource instanceof IFile) || !changedResource.exists()) continue;
                try {
                    ResourceUtil.saveLocalHistory(changedResource);
                }
                catch (CoreException e) {
                    Activator.logError(MessageFormat.format(CoreText.ResourceUtil_SaveLocalHistoryFailed, changedResource), e);
                }
            }
        }
    }

    private static void saveLocalHistory(IResource resource) throws CoreException {
        if (!resource.isSynchronized(0)) {
            resource.refreshLocal(0, null);
        }
        ((IFile)resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), 2, null);
    }
}

