/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.internal.JUnitXMLReportGenerator;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.reporting.internal.ReportUtils;
import org.eclipse.rcptt.reporting.internal.XMLUtils;

public class JUnitFileReportGenerator
implements IReportRenderer {
    @Override
    public IStatus generateReport(IReportRenderer.IContentFactory factory, String reportName, Q7ReportIterator report) {
        OutputStream stream;
        block17: {
            stream = null;
            XMLStreamWriter writer = null;
            try {
                stream = factory.createFileStream(String.valueOf(reportName) + ".junit.xml");
                writer = XMLUtils.createWriter(stream);
                writer.writeStartDocument();
                Q7Statistics statistics = ReportUtils.calculateStatistics(report.iterator());
                new JUnitXMLReportGenerator().writeSuite(writer, reportName, report.iterator(), statistics);
                writer.writeEndDocument();
                writer.flush();
            }
            catch (XMLStreamException ex) {
                IStatus iStatus = Q7ReportingPlugin.createStatus(ex);
                if (writer != null) {
                    XMLUtils.closeWriter(writer);
                }
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                return iStatus;
            }
            catch (CoreException ex) {
                IStatus iStatus;
                block16: {
                    try {
                        iStatus = ex.getStatus();
                        if (writer == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            XMLUtils.closeWriter(writer);
                        }
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    XMLUtils.closeWriter(writer);
                }
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                return iStatus;
            }
            if (writer == null) break block17;
            XMLUtils.closeWriter(writer);
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }

    @Override
    public String[] getGeneratedFileNames(String reportName) {
        return new String[]{String.valueOf(reportName) + ".junit.xml"};
    }
}

