/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.GetStateResponse;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.Nop;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.TeslaStream;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.IScreenshotFactory;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.TeslaProcessorManager;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;

public abstract class AbstractTeslaClient
implements IElementProcessorMapper {
    private boolean processing = false;
    private final ElementGenerator generator = new ElementGenerator();
    protected final List<Command> localQueue = new ArrayList<Command>();
    private Map<String, Set<ITeslaCommandProcessor>> elementProcessors = new HashMap<String, Set<ITeslaCommandProcessor>>();
    private final Map<Command, ITeslaCommandProcessor.PreExecuteStatus> preStatuses = new HashMap<Command, ITeslaCommandProcessor.PreExecuteStatus>();
    private ITeslaCommandProcessor[] processors;
    private ContextManagement.Context currentContext;
    private final String id;
    private final AtomicInteger hasEvents = new AtomicInteger(-1);
    private AdvancedInformation lastFailureInformation;

    public AbstractTeslaClient(String id) {
        this.id = id;
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors = new TeslaProcessorManager().getProcessors();
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            processor.initialize(this, id);
            ++n2;
        }
    }

    public ElementGenerator getGenerator() {
        return this.generator;
    }

    public String getID() {
        return this.id;
    }

    public void shutdown() {
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            processor.terminate();
            ++n2;
        }
        this.processors = null;
        this.elementProcessors = null;
    }

    public abstract boolean isActive();

    public abstract Object getSyncObject();

    public abstract boolean isClosed();

    protected abstract TeslaStream stream();

    @Override
    public void map(Element element, ITeslaCommandProcessor processor) {
        if (element != null && processor != null) {
            this.putProcessor(element, processor);
            ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                ITeslaCommandProcessor proc = iTeslaCommandProcessorArray[n2];
                proc.postSelect(element, new IElementProcessorMapper(){

                    @Override
                    public void map(Element element, ITeslaCommandProcessor processor) {
                        AbstractTeslaClient.this.putProcessor(element, processor);
                    }
                });
                ++n2;
            }
        }
    }

    private void putProcessor(Element element, ITeslaCommandProcessor processor) {
        String key = this.makeKey(element);
        Set<ITeslaCommandProcessor> set = this.elementProcessors.get(key);
        if (set == null) {
            set = new LinkedHashSet<ITeslaCommandProcessor>();
        }
        LinkedHashSet<ITeslaCommandProcessor> newSet = new LinkedHashSet<ITeslaCommandProcessor>();
        newSet.add(processor);
        newSet.addAll(set);
        this.elementProcessors.put(key, newSet);
    }

    protected void handleSelect(SelectCommand cmd) throws IOException {
        block11: {
            try {
                String kind = cmd.getData().getKind();
                ITeslaCommandProcessor lastProcessor = null;
                Response response = null;
                ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
                int n = this.processors.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
                    if (processor.isSelectorSupported(kind)) {
                        try {
                            response = processor.select(cmd, this.generator, this);
                            lastProcessor = processor;
                        }
                        catch (Throwable t) {
                            TeslaCore.log(t);
                            if (response == null) {
                                response = ProtocolFactory.eINSTANCE.createSelectResponse();
                            }
                            response.setStatus(ResponseStatus.FAILED);
                            response.setMessage(t.getMessage());
                        }
                        if (response != null && !response.getElements().isEmpty()) {
                            for (Element uiElement : response.getElements()) {
                                this.map(uiElement, processor);
                            }
                            break;
                        }
                    }
                    if (response != null && !response.getElements().isEmpty()) break;
                    ++n2;
                }
                if (response == null) {
                    response = ProtocolFactory.eINSTANCE.createSelectResponse();
                    response.setStatus(ResponseStatus.FAILED);
                    response.setMessage("No Element with kind:" + kind + " is available for selection...");
                }
                if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                    this.handleFailedResponse(cmd, response, lastProcessor);
                }
                this.stream().writeResponse(response);
            }
            catch (Throwable e) {
                if (e.getMessage() != null && e.getMessage().equals("Software caused connection abort: socket write error")) break block11;
                this.sendErrorResponse(e);
                TeslaCore.log(e);
            }
        }
    }

    protected void handleAssert(Assert cmd) throws IOException {
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            Response response = processor.executeCommand(cmd, this);
            if (response != null) {
                this.stream().writeResponse(response);
                return;
            }
            ++n2;
        }
        BooleanResponse response = ProtocolFactory.eINSTANCE.createBooleanResponse();
        response.setStatus(ResponseStatus.FAILED);
        this.stream().writeResponse(response);
    }

    private String makeKey(Element uiElement) {
        return String.valueOf(uiElement.getKind()) + ":" + uiElement.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processNext(ContextManagement.Context context, Q7WaitInfoRoot info) {
        if (this.isClosed()) {
            return false;
        }
        AbstractTeslaClient abstractTeslaClient = this;
        synchronized (abstractTeslaClient) {
            if (this.processing) {
                return false;
            }
        }
        if (this.isActive() && (this.hasCommand() || !this.localQueue.isEmpty()) && this.canProceed(context, info)) {
            return this.doOneCommand(context, info);
        }
        return false;
    }

    public void hasEvent(String kind, String name, Q7WaitInfoRoot info) {
        this.hasEvents.incrementAndGet();
        Q7WaitUtils.updateInfo(kind, name, info);
    }

    protected boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        this.hasEvents.set(0);
        boolean result = true;
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            boolean proceed = processor.canProceed(context, info);
            if (!proceed) {
                result = false;
            }
            ++n2;
        }
        if (this.hasEvents.get() > 0) {
            return false;
        }
        return result;
    }

    public void clean() {
        this.lastFailureInformation = null;
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            processor.clean();
            ++n2;
        }
        for (ITeslaCommandProcessor.PreExecuteStatus status : this.preStatuses.values()) {
            status.clean();
        }
        this.preStatuses.clear();
        this.elementProcessors.clear();
    }

    protected boolean preExecute(Command command, Q7WaitInfoRoot info) {
        block10: {
            block9: {
                Set<ITeslaCommandProcessor> processors;
                if (!(command instanceof ElementCommand)) break block9;
                ElementCommand cmd = (ElementCommand)command;
                Element element = cmd.getElement();
                if (element == null || (processors = this.elementProcessors.get(this.makeKey(element))) == null) break block10;
                ITeslaCommandProcessor.PreExecuteStatus preStatus = this.preStatuses.get(command);
                for (ITeslaCommandProcessor processor : processors) {
                    block8: {
                        if (processor == null) continue;
                        ITeslaCommandProcessor.PreExecuteStatus status = processor.preExecute(command, preStatus, info);
                        if (status == null) break block8;
                        this.preStatuses.put(command, status);
                        if (status.canExecute) continue;
                        return false;
                    }
                    try {
                        this.preStatuses.remove(command);
                    }
                    catch (Throwable e) {
                        TeslaCore.log(e);
                    }
                }
                break block10;
            }
            ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
                try {
                    ITeslaCommandProcessor.PreExecuteStatus status = processor.preExecute(command, this.preStatuses.get(command), info);
                    if (status != null && !status.canExecute) {
                        this.preStatuses.put(command, status);
                        return false;
                    }
                }
                catch (Throwable e) {
                    TeslaCore.log(e);
                }
                ++n2;
            }
        }
        return true;
    }

    public void addCommand(Command cmd) {
        this.localQueue.add(cmd);
        this.notifyUI();
    }

    public void notifyUI() {
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            processor.notifyUI();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doOneCommand(ContextManagement.Context context, Q7WaitInfoRoot info) {
        block22: {
            block21: {
                var3_3 = this;
                synchronized (var3_3) {
                    this.processing = true;
                }
                this.currentContext = context;
                command = null;
                try {
                    block23: {
                        if (this.localQueue.isEmpty()) break block23;
                        command = this.localQueue.remove(0);
                        isLocalQueue = true;
                        ** GOTO lbl40
                    }
                    command = this.stream().readCommand();
                    if (command != null) break block21;
                    var6_5 = this;
                }
                catch (Throwable var5_9) {
                    var6_7 = this;
                    synchronized (var6_7) {
                        this.processing = false;
                    }
                    this.currentContext = null;
                    throw var5_9;
                }
                synchronized (var6_5) {
                    this.processing = false;
                }
                this.currentContext = null;
                return false;
            }
            isLocalQueue = false;
lbl40:
            // 2 sources

            if (this.preExecute(command, info)) break block22;
            if (isLocalQueue) {
                this.localQueue.add(0, command);
            } else {
                this.localQueue.add(command);
            }
            var6_6 = this;
            synchronized (var6_6) {
                this.processing = false;
            }
            this.currentContext = null;
            return false;
        }
        this.preExecute(command);
        this.execute(command);
        this.postExecute(command);
        var6_8 = this;
        synchronized (var6_8) {
            this.processing = false;
        }
        this.currentContext = null;
        return true;
    }

    protected void postExecute(Command command) {
        if (this.processors == null) {
            return;
        }
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            if (processor instanceof IScreenshotFactory) {
                ((IScreenshotFactory)((Object)processor)).makeScreenshot("post execute: " + command.getClass().getName(), true);
                break;
            }
            ++n2;
        }
    }

    protected void preExecute(Command command) {
        if (command instanceof SelectCommand || command instanceof Nop || command instanceof Assert) {
            return;
        }
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            if (processor instanceof IScreenshotFactory) {
                ((IScreenshotFactory)((Object)processor)).makeScreenshot("pre execute: " + command.getClass().getName(), false);
                break;
            }
            ++n2;
        }
    }

    protected void execute(Command command) {
        if (!(command instanceof Nop)) {
            this.lastFailureInformation = null;
        }
        try {
            if (command instanceof ElementCommand) {
                Set<ITeslaCommandProcessor> processors;
                ElementCommand cmd = (ElementCommand)command;
                Element element = cmd.getElement();
                if (element != null && (processors = this.elementProcessors.get(this.makeKey(element))) != null) {
                    for (ITeslaCommandProcessor processor : processors) {
                        if (processor == null) continue;
                        try {
                            Response response = processor.executeCommand(command, this);
                            if (response == null) continue;
                            if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                                this.handleFailedResponse(command, response, processor);
                            }
                            this.stream().writeResponse(response);
                            return;
                        }
                        catch (Throwable e) {
                            TeslaCore.log(e);
                            this.sendErrorResponse(e);
                            return;
                        }
                    }
                }
            } else {
                ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
                int processors = this.processors.length;
                int element = 0;
                while (element < processors) {
                    ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[element];
                    if (processor.isCommandSupported(command)) {
                        try {
                            Response response = processor.executeCommand(command, this);
                            if (response != null) {
                                if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                                    this.handleFailedResponse(command, response, processor);
                                }
                                this.stream().writeResponse(response);
                                return;
                            }
                        }
                        catch (Exception e) {
                            TeslaCore.log(e);
                            this.sendErrorResponse(e);
                            return;
                        }
                    }
                    ++element;
                }
            }
            if (command.eClass().getEPackage().equals(ProtocolFactory.eINSTANCE.getEPackage())) {
                switch (command.eClass().getClassifierID()) {
                    case 2: {
                        this.handleSelect((SelectCommand)command);
                        return;
                    }
                    case 22: {
                        this.stream().writeResponse(RawFactory.eINSTANCE.createResponse());
                        this.shutdown();
                        return;
                    }
                    case 23: {
                        this.stream().writeResponse(RawFactory.eINSTANCE.createResponse());
                        return;
                    }
                    case 16: {
                        GetStateResponse res = ProtocolFactory.eINSTANCE.createGetStateResponse();
                        Element state = RawFactory.eINSTANCE.createElement();
                        String returnedState = this.currentContext.getID();
                        state.setId(returnedState);
                        state.setKind("State");
                        res.setState(state);
                        this.stream().writeResponse(res);
                        return;
                    }
                    case 18: {
                        this.stream().writeResponse(RawFactory.eINSTANCE.createResponse());
                        return;
                    }
                    case 19: {
                        this.stream().writeResponse(RawFactory.eINSTANCE.createResponse());
                        return;
                    }
                }
            }
            Response failed = RawFactory.eINSTANCE.createResponse();
            failed.setStatus(ResponseStatus.FAILED);
            failed.setMessage("Unsupported command");
            this.stream().writeResponse(failed);
            return;
        }
        catch (Throwable t) {
            this.logException(t);
            this.handleFailedResponse(command, null, null);
            return;
        }
    }

    private void sendErrorResponse(Throwable e) {
        try {
            Response errorResponse = RawFactory.eINSTANCE.createResponse();
            errorResponse.setStatus(ResponseStatus.FAILED);
            errorResponse.setMessage("Exception happened: " + e.toString());
            this.stream().writeResponse(errorResponse);
        }
        catch (Throwable e2) {
            TeslaCore.log(e2);
        }
    }

    public AdvancedInformation getLastFailureInformation() {
        return this.lastFailureInformation;
    }

    public void clearLastFailureInformation() {
        this.lastFailureInformation = null;
    }

    protected void handleFailedResponse(Command command, Response response, ITeslaCommandProcessor processor) {
        if (response != null) {
            AdvancedInformation information;
            this.lastFailureInformation = information = this.getAdvancedInformation(command);
            response.setAdvancedInformation((AdvancedInformation)EcoreUtil.copy((EObject)information));
        }
    }

    public AdvancedInformation getAdvancedInformation(Command command) {
        AdvancedInformation information = InfoFactory.eINSTANCE.createAdvancedInformation();
        if (this.processors != null) {
            ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                ITeslaCommandProcessor commandProcessor = iTeslaCommandProcessorArray[n2];
                commandProcessor.collectInformation(information, command);
                ++n2;
            }
        }
        GeneralInformationCollector.collectInformation(information);
        return information;
    }

    public void collectLastFailureInformation() {
        AdvancedInformation information;
        this.lastFailureInformation = information = this.getAdvancedInformation(null);
    }

    public abstract void logException(Throwable var1);

    public abstract boolean hasCommand();

    public <T> T getProcessor(Class<T> clazz$) {
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            if (clazz$ == processor.getClass()) {
                return clazz$.cast(processor);
            }
            ++n2;
        }
        return null;
    }

    public <T> List<T> getProcessors(Class<T> clazz$) {
        ArrayList<T> result = new ArrayList<T>();
        ITeslaCommandProcessor[] iTeslaCommandProcessorArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeslaCommandProcessor processor = iTeslaCommandProcessorArray[n2];
            if (clazz$.isInstance(processor)) {
                result.add(clazz$.cast(processor));
            }
            ++n2;
        }
        return result;
    }
}

