/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.ContinueRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.ProcessStepsRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.rebase.PlanContextMenuAction;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveDragSourceListener;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveDropTargetListener;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractivePlanContentProvider;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractivePreferences;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveStepActionToolBarProvider;
import org.eclipse.egit.ui.internal.rebase.RebasePlanIndexer;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class RebaseInteractiveView
extends ViewPart
implements RebaseInteractivePlan.RebaseInteractivePlanChangeListener {
    public static final String VIEW_ID = "org.eclipse.egit.ui.InteractiveRebaseView";
    TreeViewer planTreeViewer;
    private RebaseInteractivePlan currentPlan;
    private Repository currentRepository;
    private RebaseInteractiveStepActionToolBarProvider actionToolBarProvider;
    private ToolItem startItem;
    private ToolItem abortItem;
    private ToolItem skipItem;
    private ToolItem continueItem;
    private ToolItem refreshItem;
    private boolean listenOnRepositoryViewSelection = true;
    private ISelectionListener selectionChangedListener;
    private boolean dndEnabled = false;
    private Form form;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private GitDateFormatter dateFormatter = RebaseInteractiveView.getNewDateFormatter();
    private TreeViewerColumn[] dynamicColumns;
    private List<PlanContextMenuAction> contextMenuItems;
    private RebasePlanIndexer planIndexer;
    private IEclipsePreferences.IPreferenceChangeListener prefListener;

    public RebaseInteractiveView() {
        this.setPartName(UIText.InteractiveRebaseView_this_partName);
    }

    public void setInput(Object o) {
        IResource resource;
        if (o == null) {
            return;
        }
        if (o instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)o;
            if (sel.size() != 1) {
                return;
            }
            o = sel.getFirstElement();
        }
        Repository repo = null;
        if (o instanceof RepositoryTreeNode) {
            repo = ((RepositoryTreeNode)o).getRepository();
        } else if (o instanceof Repository) {
            repo = (Repository)o;
        } else if (o instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping == null) {
                return;
            }
            repo = mapping.getRepository();
        }
        if (repo == null) {
            repo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
        }
        this.currentRepository = repo;
        this.showRepository(repo);
    }

    public RebaseInteractivePlan getCurrentPlan() {
        return this.currentPlan;
    }

    public void dispose() {
        this.removeListeners();
        this.resources.dispose();
        super.dispose();
    }

    private void removeListeners() {
        ISelectionService srv = CommonUtils.getService((IServiceLocator)this.getSite(), ISelectionService.class);
        srv.removePostSelectionListener("org.eclipse.egit.ui.RepositoriesView", this.selectionChangedListener);
        if (this.currentPlan != null) {
            this.currentPlan.removeRebaseInteractivePlanChangeListener((RebaseInteractivePlan.RebaseInteractivePlanChangeListener)this);
        }
        if (this.planIndexer != null) {
            this.planIndexer.dispose();
        }
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).removePreferenceChangeListener(this.prefListener);
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.form = this.createForm(parent, toolkit);
        this.createCommandToolBar(this.form, toolkit);
        SashForm sashForm = this.createRebasePlanSashForm(this.form, toolkit);
        Section rebasePlanSection = toolkit.createSection((Composite)sashForm, 256);
        this.planTreeViewer = this.createPlanTreeViewer(rebasePlanSection, toolkit);
        this.createColumns();
        this.createStepActionToolBar(rebasePlanSection, toolkit);
        this.createPopupMenu(this.planTreeViewer);
        this.setupListeners();
        this.createLocalDragandDrop();
        this.planTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RebaseInteractivePlan.PlanElement element = (RebaseInteractivePlan.PlanElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element == null) {
                    return;
                }
                RepositoryCommit commit = this.loadCommit(element.getCommit());
                if (commit != null) {
                    CommitEditor.openQuiet(commit);
                }
            }

            private RepositoryCommit loadCommit(AbbreviatedObjectId abbreviatedObjectId) {
                if (abbreviatedObjectId != null) {
                    RevWalk walk = new RevWalk(RebaseInteractiveView.this.currentRepository);
                    try {
                        Collection resolved = walk.getObjectReader().resolve(abbreviatedObjectId);
                        if (resolved.size() == 1) {
                            RevCommit commit = walk.parseCommit((AnyObjectId)resolved.iterator().next());
                            RepositoryCommit repositoryCommit = new RepositoryCommit(RebaseInteractiveView.this.currentRepository, commit);
                            return repositoryCommit;
                        }
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    finally {
                        walk.release();
                    }
                }
                return null;
            }
        });
        this.prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (!"GitRepositoriesView.GitDirectories".equals(event.getKey())) {
                    return;
                }
                Repository repo = RebaseInteractiveView.this.currentRepository;
                if (repo == null) {
                    return;
                }
                if (Activator.getDefault().getRepositoryUtil().contains(repo)) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        RebaseInteractiveView.this.currentRepository = null;
                        RebaseInteractiveView.this.showRepository(null);
                    }
                });
            }
        };
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).addPreferenceChangeListener(this.prefListener);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        this.listenOnRepositoryViewSelection = RebaseInteractivePreferences.isReactOnSelection();
        BooleanPrefAction linkSelectionAction = new BooleanPrefAction((IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore(), "RebaseInteractive_SyncWithSelection", UIText.InteractiveRebaseView_LinkSelection){

            public void apply(boolean value) {
                RebaseInteractiveView.this.listenOnRepositoryViewSelection = value;
            }
        };
        linkSelectionAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        toolbar.add((IAction)linkSelectionAction);
    }

    private void createCommandToolBar(Form theForm, FormToolkit toolkit) {
        ToolBar toolBar = new ToolBar(theForm.getHead(), 0x800000);
        toolBar.setOrientation(0x4000000);
        theForm.setHeadClient((Control)toolBar);
        toolkit.adapt((Composite)toolBar);
        toolkit.paintBordersFor((Composite)toolBar);
        this.startItem = new ToolItem(toolBar, 0);
        this.startItem.setImage(UIIcons.getImage((ResourceManager)this.resources, UIIcons.REBASE_PROCESS_STEPS));
        this.startItem.addSelectionListener((SelectionListener)new RebaseCommandItemSelectionListener(new ProcessStepsRebaseCommand()));
        this.startItem.setEnabled(false);
        this.startItem.setText(UIText.InteractiveRebaseView_startItem_text);
        this.continueItem = new ToolItem(toolBar, 0);
        this.continueItem.setImage(UIIcons.getImage((ResourceManager)this.resources, UIIcons.REBASE_CONTINUE));
        this.continueItem.addSelectionListener((SelectionListener)new RebaseCommandItemSelectionListener(new ContinueRebaseCommand()));
        this.continueItem.setEnabled(false);
        this.continueItem.setText(UIText.InteractiveRebaseView_continueItem_text);
        this.skipItem = new ToolItem(toolBar, 0);
        this.skipItem.setImage(UIIcons.getImage((ResourceManager)this.resources, UIIcons.REBASE_SKIP));
        this.skipItem.addSelectionListener((SelectionListener)new RebaseCommandItemSelectionListener(new SkipRebaseCommand()));
        this.skipItem.setText(UIText.InteractiveRebaseView_skipItem_text);
        this.skipItem.setEnabled(false);
        this.abortItem = new ToolItem(toolBar, 0);
        this.abortItem.setImage(UIIcons.getImage((ResourceManager)this.resources, UIIcons.REBASE_ABORT));
        this.abortItem.addSelectionListener((SelectionListener)new RebaseCommandItemSelectionListener(new AbortRebaseCommand()));
        this.abortItem.setText(UIText.InteractiveRebaseView_abortItem_text);
        this.abortItem.setEnabled(false);
        RebaseInteractiveView.createSeparator(toolBar);
        this.refreshItem = new ToolItem(toolBar, 0);
        this.refreshItem.setImage(UIIcons.getImage((ResourceManager)this.resources, UIIcons.ELCL16_REFRESH));
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseInteractiveView.this.refresh();
            }
        });
        this.refreshItem.setText(UIText.InteractiveRebaseView_refreshItem_text);
    }

    private static ToolItem createSeparator(ToolBar toolBar) {
        return new ToolItem(toolBar, 2);
    }

    private TreeViewer createPlanTreeViewer(Section rebasePlanSection, FormToolkit toolkit) {
        Composite rebasePlanTableComposite = toolkit.createComposite((Composite)rebasePlanSection);
        toolkit.paintBordersFor(rebasePlanTableComposite);
        rebasePlanSection.setClient((Control)rebasePlanTableComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(rebasePlanTableComposite);
        Composite toolbarComposite = toolkit.createComposite((Composite)rebasePlanSection);
        toolbarComposite.setBackground(null);
        RowLayout toolbarRowLayout = new RowLayout();
        toolbarRowLayout.marginHeight = 0;
        toolbarRowLayout.marginWidth = 0;
        toolbarRowLayout.marginTop = 0;
        toolbarRowLayout.marginBottom = 0;
        toolbarRowLayout.marginLeft = 0;
        toolbarRowLayout.marginRight = 0;
        toolbarComposite.setLayout((Layout)toolbarRowLayout);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(rebasePlanTableComposite);
        Tree planTree = toolkit.createTree(rebasePlanTableComposite, 65538);
        planTree.setHeaderVisible(true);
        planTree.setLinesVisible(false);
        TreeViewer viewer = new TreeViewer(planTree);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new PlanViewerSelectionChangedListener());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        viewer.getTree().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        viewer.setContentProvider((IContentProvider)RebaseInteractivePlanContentProvider.INSTANCE);
        return viewer;
    }

    private SashForm createRebasePlanSashForm(Form parent, FormToolkit toolkit) {
        SashForm sashForm = new SashForm(parent.getBody(), 0);
        toolkit.adapt((Control)sashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sashForm);
        return sashForm;
    }

    private Form createForm(Composite parent, FormToolkit toolkit) {
        Form newForm = toolkit.createForm(parent);
        Image repoImage = UIIcons.REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)newForm, (Resource)repoImage);
        newForm.setImage(repoImage);
        newForm.setText(UIText.RebaseInteractiveView_NoSelection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)newForm);
        toolkit.decorateFormHeading(newForm);
        GridLayoutFactory.swtDefaults().applyTo(newForm.getBody());
        return newForm;
    }

    private void setupListeners() {
        this.setupRepositoryViewSelectionChangeListener();
        this.refreshUI();
    }

    private void setupRepositoryViewSelectionChangeListener() {
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!RebaseInteractiveView.this.listenOnRepositoryViewSelection || part == RebaseInteractiveView.this.getSite().getPart()) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        RebaseInteractiveView.this.setInput(new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    }
                } else {
                    RebaseInteractiveView.this.setInput(selection);
                }
            }
        };
        ISelectionService srv = CommonUtils.getService((IServiceLocator)this.getSite(), ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
    }

    private void createLocalDragandDrop() {
        this.planTreeViewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new RebaseInteractiveDragSourceListener(this));
        this.planTreeViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new RebaseInteractiveDropTargetListener(this, (Viewer)this.planTreeViewer));
    }

    private void createStepActionToolBar(Section rebasePlanSection, FormToolkit toolkit) {
        this.actionToolBarProvider = new RebaseInteractiveStepActionToolBarProvider((Composite)rebasePlanSection, 0x800040, this);
        toolkit.adapt((Composite)this.actionToolBarProvider.getTheToolbar());
        toolkit.paintBordersFor((Composite)this.actionToolBarProvider.getTheToolbar());
        rebasePlanSection.setTextClient((Control)this.actionToolBarProvider.getTheToolbar());
    }

    private static RebaseInteractivePlan.ElementType getType(Object element) {
        if (element instanceof RebaseInteractivePlan.PlanElement) {
            RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
            return planLine.getElementType();
        }
        return null;
    }

    private void createColumns() {
        String[] headings = new String[]{UIText.RebaseInteractiveView_HeadingStatus, UIText.RebaseInteractiveView_HeadingStep, UIText.RebaseInteractiveView_HeadingAction, UIText.RebaseInteractiveView_HeadingCommitId, UIText.RebaseInteractiveView_HeadingMessage, UIText.RebaseInteractiveView_HeadingAuthor, UIText.RebaseInteractiveView_HeadingAuthorDate, UIText.RebaseInteractiveView_HeadingCommitter, UIText.RebaseInteractiveView_HeadingCommitDate};
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.planTreeViewer, (int)2);
        TreeViewerColumn infoColumn = this.createColumn(headings[0], 70);
        infoColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public Image getImage(Object element) {
                RebaseInteractivePlan.ElementType t = RebaseInteractiveView.getType(element);
                if (t != null) {
                    switch (t) {
                        case DONE_CURRENT: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.CURRENT_STEP);
                        }
                        case DONE: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.DONE_STEP);
                        }
                    }
                }
                return null;
            }

            public String getToolTipText(Object element) {
                RebaseInteractivePlan.ElementType t = RebaseInteractiveView.getType(element);
                if (t != null) {
                    switch (t) {
                        case DONE: {
                            return UIText.RebaseInteractiveView_StatusDone;
                        }
                        case DONE_CURRENT: {
                            return UIText.RebaseInteractiveView_StatusCurrent;
                        }
                        case TODO: {
                            return UIText.RebaseInteractiveView_StatusTodo;
                        }
                    }
                }
                return "";
            }

            public String getText(Object element) {
                return "";
            }
        });
        TreeViewerColumn stepColumn = this.createColumn(headings[1], 55);
        stepColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return String.valueOf(RebaseInteractiveView.this.planIndexer.indexOf(planLine) + 1) + ".";
                }
                return super.getText(element);
            }
        });
        stepColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tree tree = RebaseInteractiveView.this.planTreeViewer.getTree();
                boolean orderReversed = tree.getSortDirection() == 1024;
                RebaseInteractivePreferences.setOrderReversed(!orderReversed);
                int newDirection = orderReversed ? 128 : 1024;
                tree.setSortDirection(newDirection);
                TreeItem topmostVisibleItem = tree.getTopItem();
                RebaseInteractiveView.this.refreshUI();
                if (topmostVisibleItem != null) {
                    tree.showItem(topmostVisibleItem);
                }
            }
        });
        int direction = RebaseInteractivePreferences.isOrderReversed() ? 1024 : 128;
        Tree planTree = this.planTreeViewer.getTree();
        planTree.setSortColumn(stepColumn.getColumn());
        planTree.setSortDirection(direction);
        TreeViewerColumn actionColumn = this.createColumn(headings[2], 90);
        actionColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public Image getImage(Object element) {
                RebaseInteractivePlan.ElementAction a = this.getAction(element);
                if (a != null) {
                    switch (a) {
                        case EDIT: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.EDITCONFIG);
                        }
                        case FIXUP: {
                            if (RebaseInteractivePreferences.isOrderReversed()) {
                                return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.FIXUP_DOWN);
                            }
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.FIXUP_UP);
                        }
                        case PICK: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.CHERRY_PICK);
                        }
                        case REWORD: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.REWORD);
                        }
                        case SKIP: {
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.REBASE_SKIP);
                        }
                        case SQUASH: {
                            if (RebaseInteractivePreferences.isOrderReversed()) {
                                return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.SQUASH_DOWN);
                            }
                            return UIIcons.getImage((ResourceManager)RebaseInteractiveView.this.resources, UIIcons.SQUASH_UP);
                        }
                    }
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                RebaseInteractivePlan.ElementAction a = this.getAction(element);
                return a != null ? a.name() : super.getText(element);
            }

            private RebaseInteractivePlan.ElementAction getAction(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getPlanElementAction();
                }
                return null;
            }
        });
        TreeViewerColumn commitIDColumn = this.createColumn(headings[3], 70);
        commitIDColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getCommit().name();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn commitMessageColumn = this.createColumn(headings[4], 200);
        commitMessageColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getShortMessage();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn authorColumn = this.createColumn(headings[5], 120);
        authorColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getAuthor();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn authoredDateColumn = this.createColumn(headings[6], 80);
        authoredDateColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getAuthoredDate(RebaseInteractiveView.this.dateFormatter);
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn committerColumn = this.createColumn(headings[7], 120);
        committerColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getCommitter();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn commitDateColumn = this.createColumn(headings[8], 80);
        commitDateColumn.setLabelProvider((CellLabelProvider)new HighlightingColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RebaseInteractivePlan.PlanElement) {
                    RebaseInteractivePlan.PlanElement planLine = (RebaseInteractivePlan.PlanElement)element;
                    return planLine.getCommittedDate(RebaseInteractiveView.this.dateFormatter);
                }
                return super.getText(element);
            }
        });
        this.dynamicColumns = new TreeViewerColumn[]{commitMessageColumn, authorColumn, authoredDateColumn, committerColumn, commitDateColumn};
    }

    private TreeViewerColumn createColumn(String text, int width) {
        TreeViewerColumn column = new TreeViewerColumn(this.planTreeViewer, 0);
        column.getColumn().setText(text);
        column.getColumn().setMoveable(false);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(width);
        return column;
    }

    private void asyncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    private static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    private void showRepository(Repository repository) {
        if (this.form.isDisposed()) {
            return;
        }
        if (this.currentPlan != null) {
            this.currentPlan.removeRebaseInteractivePlanChangeListener((RebaseInteractivePlan.RebaseInteractivePlanChangeListener)this);
        }
        if (this.planIndexer != null) {
            this.planIndexer.dispose();
        }
        if (this.isValidRepo(repository)) {
            this.currentPlan = RebaseInteractivePlan.getPlan((Repository)repository);
            this.planIndexer = new RebasePlanIndexer(this.currentPlan);
            this.currentPlan.addRebaseInteractivePlanChangeListener((RebaseInteractivePlan.RebaseInteractivePlanChangeListener)this);
            this.form.setText(RebaseInteractiveView.getRepositoryName(repository));
        } else {
            this.currentPlan = null;
            this.planIndexer = null;
            this.form.setText(UIText.RebaseInteractiveView_NoSelection);
        }
        this.refresh();
    }

    private boolean isValidRepo(Repository repository) {
        return repository != null && !repository.isBare() && repository.getWorkTree().exists();
    }

    void refresh() {
        if (!this.isReady()) {
            return;
        }
        this.asyncExec(new Runnable(){

            public void run() {
                RebaseInteractiveView.this.planTreeViewer.getTree().setRedraw(false);
                try {
                    RebaseInteractiveView.this.planTreeViewer.setInput((Object)RebaseInteractiveView.this.currentPlan);
                    RebaseInteractiveView.this.refreshUI();
                }
                finally {
                    RebaseInteractiveView.this.planTreeViewer.getTree().setRedraw(true);
                }
            }
        });
    }

    private boolean isReady() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return false;
        }
        return !site.getShell().isDisposed();
    }

    private void refreshUI() {
        Tree tree;
        int itemCount;
        this.dateFormatter = RebaseInteractiveView.getNewDateFormatter();
        if (this.planTreeViewer != null) {
            this.planTreeViewer.refresh(true);
            TreeViewerColumn[] treeViewerColumnArray = this.dynamicColumns;
            int n = this.dynamicColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeViewerColumn col = treeViewerColumnArray[n2];
                col.getColumn().pack();
                ++n2;
            }
        }
        this.startItem.setEnabled(false);
        this.continueItem.setEnabled(false);
        this.skipItem.setEnabled(false);
        this.abortItem.setEnabled(false);
        this.dndEnabled = false;
        this.actionToolBarProvider.getTheToolbar().setEnabled(false);
        if (this.currentPlan == null || !this.currentPlan.isRebasingInteractive()) {
            if (this.currentRepository == null) {
                this.form.setText(UIText.RebaseInteractiveView_NoSelection);
            } else {
                this.form.setText(RebaseInteractiveView.getRepositoryName(this.currentRepository));
            }
            return;
        }
        this.actionToolBarProvider.mapActionItemsToSelection(this.planTreeViewer.getSelection());
        if (!this.currentPlan.hasRebaseBeenStartedYet()) {
            if (!this.planTreeViewer.getSelection().isEmpty()) {
                this.actionToolBarProvider.getTheToolbar().setEnabled(true);
            }
            this.startItem.setEnabled(true);
            this.abortItem.setEnabled(true);
            this.dndEnabled = true;
        } else {
            this.continueItem.setEnabled(true);
            this.skipItem.setEnabled(true);
            this.abortItem.setEnabled(true);
        }
        if (RebaseInteractivePreferences.isOrderReversed() && (itemCount = (tree = this.planTreeViewer.getTree()).getItemCount()) > 0) {
            TreeItem bottomItem = tree.getItem(itemCount - 1);
            tree.showItem(bottomItem);
        }
    }

    private void createPopupMenu(final TreeViewer planViewer) {
        this.createContextMenuItems(planViewer);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                boolean selectionNotEmpty = !planViewer.getSelection().isEmpty();
                boolean rebaseNotStarted = !RebaseInteractiveView.this.currentPlan.hasRebaseBeenStartedYet();
                boolean menuEnabled = selectionNotEmpty && rebaseNotStarted;
                for (PlanContextMenuAction item : RebaseInteractiveView.this.contextMenuItems) {
                    item.setEnabled(menuEnabled);
                }
            }
        });
        for (PlanContextMenuAction item : this.contextMenuItems) {
            manager.add((IAction)item);
        }
        Menu menu = manager.createContextMenu(planViewer.getControl());
        planViewer.getControl().setMenu(menu);
    }

    private void createContextMenuItems(TreeViewer planViewer) {
        this.contextMenuItems = new ArrayList<PlanContextMenuAction>();
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_PickText, UIIcons.CHERRY_PICK, RebaseInteractivePlan.ElementAction.PICK, planViewer, this.actionToolBarProvider));
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_SkipText, UIIcons.REBASE_SKIP, RebaseInteractivePlan.ElementAction.SKIP, planViewer, this.actionToolBarProvider));
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_EditText, UIIcons.EDITCONFIG, RebaseInteractivePlan.ElementAction.EDIT, planViewer, this.actionToolBarProvider));
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_SquashText, UIIcons.SQUASH_UP, RebaseInteractivePlan.ElementAction.SQUASH, planViewer, this.actionToolBarProvider));
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_FixupText, UIIcons.FIXUP_UP, RebaseInteractivePlan.ElementAction.FIXUP, planViewer, this.actionToolBarProvider));
        this.contextMenuItems.add(new PlanContextMenuAction(UIText.RebaseInteractiveStepActionToolBarProvider_RewordText, UIIcons.REWORD, RebaseInteractivePlan.ElementAction.REWORD, planViewer, this.actionToolBarProvider));
    }

    private static GitDateFormatter getNewDateFormatter() {
        boolean useRelativeDates = Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_relative_date");
        if (useRelativeDates) {
            return new GitDateFormatter(GitDateFormatter.Format.RELATIVE);
        }
        return new GitDateFormatter(GitDateFormatter.Format.LOCALE);
    }

    public void setFocus() {
        this.planTreeViewer.getControl().setFocus();
    }

    boolean isDragAndDropEnabled() {
        return this.dndEnabled;
    }

    public void planWasUpdatedFromRepository(RebaseInteractivePlan plan) {
        this.refresh();
    }

    public void planElementTypeChanged(RebaseInteractivePlan rebaseInteractivePlan, RebaseInteractivePlan.PlanElement element, RebaseInteractivePlan.ElementAction oldType, RebaseInteractivePlan.ElementAction newType) {
        this.planTreeViewer.refresh((Object)element, true);
    }

    public void planElementsOrderChanged(RebaseInteractivePlan rebaseInteractivePlan, RebaseInteractivePlan.PlanElement element, int oldIndex, int newIndex) {
        this.planTreeViewer.refresh(true);
    }

    private static class HighlightingColumnLabelProvider
    extends ColumnLabelProvider {
        private HighlightingColumnLabelProvider() {
        }

        public Font getFont(Object element) {
            RebaseInteractivePlan.ElementType t = RebaseInteractiveView.getType(element);
            if (t != null && t == RebaseInteractivePlan.ElementType.DONE_CURRENT) {
                return UIUtils.getBoldFont("org.eclipse.jface.dialogfont");
            }
            return super.getFont(element);
        }
    }

    private class PlanViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private PlanViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event == null) {
                return;
            }
            ISelection selection = event.getSelection();
            RebaseInteractiveView.this.actionToolBarProvider.mapActionItemsToSelection(selection);
        }
    }

    private class RebaseCommandItemSelectionListener
    extends SelectionAdapter {
        private final AbstractRebaseCommandHandler command;

        public RebaseCommandItemSelectionListener(AbstractRebaseCommandHandler command) {
            this.command = command;
        }

        public void widgetSelected(SelectionEvent sEvent) {
            try {
                this.command.execute(RebaseInteractiveView.this.currentPlan.getRepository());
            }
            catch (ExecutionException e) {
                Activator.showError(e.getMessage(), e);
            }
        }
    }
}

