/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushTagsWizard;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RepositoryTreeNode> nodes = this.getSelectedNodes(event);
        RepositoryTreeNode node = (RepositoryTreeNode)nodes.get(0);
        Wizard pushWiz = null;
        try {
            switch (node.getType()) {
                case REF: {
                    Ref ref = (Ref)node.getObject();
                    pushWiz = new PushBranchWizard(node.getRepository(), ref);
                    break;
                }
                case TAG: {
                    pushWiz = this.createPushTagsWizard(nodes);
                    break;
                }
                case REPO: {
                    pushWiz = new PushWizard(node.getRepository());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("type not supported!");
                }
            }
        }
        catch (URISyntaxException e1) {
            Activator.handleError(e1.getMessage(), e1, true);
            return null;
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)pushWiz);
        dlg.setHelpAvailable(pushWiz.isHelpAvailable());
        dlg.open();
        return null;
    }

    private PushTagsWizard createPushTagsWizard(List<RepositoryTreeNode> nodes) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (RepositoryTreeNode node : nodes) {
            if (!(node instanceof TagNode)) continue;
            TagNode tagNode = (TagNode)node;
            tagNames.add(((Ref)tagNode.getObject()).getName());
        }
        Repository repository = nodes.get(0).getRepository();
        return new PushTagsWizard(repository, tagNames);
    }

    public boolean isEnabled() {
        List nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return false;
        }
        Repository repository = ((RepositoryTreeNode)nodes.get(0)).getRepository();
        for (RepositoryTreeNode node : nodes) {
            if (repository == node.getRepository()) continue;
            return false;
        }
        return this.selectedRepositoryHasHead();
    }
}

