/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronizeParticipant;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitModelSynchronize {
    private static final String GIT_PROVIDER_ID = "org.eclipse.egit.core.GitProvider";

    public static final void synchronize(IResource[] resources, Repository repository, String srcRev, String dstRev, boolean includeLocal) throws IOException {
        GitSynchronizeData data;
        ResourceMapping[] mappings;
        HashSet<IResource> includedResources = new HashSet<IResource>(Arrays.asList(resources));
        HashSet<ResourceMapping> allMappings = new HashSet<ResourceMapping>();
        HashSet<Object> newResources = new HashSet<IResource>(includedResources);
        do {
            HashSet<IResource> copy = newResources;
            newResources = new HashSet();
            for (IResource resource : copy) {
                ResourceMapping[] mappings2 = ResourceUtil.getResourceMappings((IResource)resource, (ResourceMappingContext)ResourceMappingContext.LOCAL_CONTEXT);
                allMappings.addAll(Arrays.asList(mappings2));
                newResources.addAll(GitModelSynchronize.collectResources(mappings2));
            }
        } while (includedResources.addAll(newResources));
        if (dstRev.equals("Index")) {
            IResource[] resourcesArray = includedResources.toArray(new IResource[includedResources.size()]);
            GitModelSynchronize.openGitTreeCompare(resourcesArray, srcRev, "%%%INDEX%%%", includeLocal);
        } else if (srcRev.equals("Index")) {
            mappings = allMappings.toArray(new ResourceMapping[allMappings.size()]);
            data = new GitSynchronizeData(repository, srcRev, dstRev, true, includedResources);
            GitModelSynchronize.launch(new GitSynchronizeDataSet(data), mappings);
        } else {
            mappings = allMappings.toArray(new ResourceMapping[allMappings.size()]);
            data = new GitSynchronizeData(repository, srcRev, dstRev, includeLocal, includedResources);
            GitModelSynchronize.launch(new GitSynchronizeDataSet(data), mappings);
        }
    }

    private static Set<IResource> collectResources(ResourceMapping[] mappings) {
        HashSet<IResource> resources = new HashSet<IResource>();
        ResourceMappingContext context = ResourceMappingContext.LOCAL_CONTEXT;
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(context, (IProgressMonitor)new NullProgressMonitor());
                int n3 = traversals.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResourceTraversal traversal = resourceTraversalArray[n4];
                    resources.addAll(Arrays.asList(traversal.getResources()));
                    ++n4;
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return resources;
    }

    private static void openGitTreeCompare(IResource[] resources, String srcRev, String dstRev, boolean includeLocal) {
        try {
            CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
            if (includeLocal) {
                view.setInput(resources, dstRev);
            } else {
                view.setInput(resources, srcRev, dstRev);
            }
        }
        catch (PartInitException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    public static final void launch(GitSynchronizeData data, IResource[] resources) {
        GitModelSynchronize.launch(new GitSynchronizeDataSet(data), resources);
    }

    public static final void launch(GitSynchronizeDataSet gsdSet, IResource[] resources) {
        ResourceMapping[] mappings = GitModelSynchronize.getGitResourceMappings(resources);
        GitModelSynchronize.launch(gsdSet, mappings);
    }

    public static final void launch(GitSynchronizeDataSet gsdSet, ResourceMapping[] mappings) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        GitModelSynchronize.fireSynchronizeAction(window, gsdSet, mappings);
    }

    private static ResourceMapping[] getGitResourceMappings(IResource[] elements) {
        ArrayList<ResourceMapping> gitMappings = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt((Object)element, ResourceMapping.class);
            if (mapping != null && GitModelSynchronize.isMappedToGitProvider(mapping)) {
                gitMappings.add(mapping);
            }
            ++n2;
        }
        return gitMappings.toArray(new ResourceMapping[gitMappings.size()]);
    }

    private static boolean isMappedToGitProvider(ResourceMapping element) {
        IProject[] projects;
        IProject[] iProjectArray = projects = element.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null && provider.getID().equals(GIT_PROVIDER_ID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void fireSynchronizeAction(final IWorkbenchWindow window, final GitSynchronizeDataSet gsdSet, final ResourceMapping[] mappings) {
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(gsdSet);
        WorkspaceJob syncJob = new WorkspaceJob(UIText.GitModelSynchronize_fetchGitDataJobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                subscriber.init(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.SYNCHRONIZE_READ_DATA.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        syncJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber, gsdSet);
                SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
                GitSubscriberMergeContext context = new GitSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager, gsdSet);
                GitModelSynchronizeParticipant participant = new GitModelSynchronizeParticipant(context);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
                IWorkbenchPart activePart = null;
                if (window != null) {
                    activePart = window.getActivePage().getActivePart();
                }
                participant.run(activePart);
            }
        });
        syncJob.setUser(true);
        syncJob.schedule();
    }

    private GitModelSynchronize() {
    }
}

