/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Operation;

public class CommitWorkingCopyOperation
extends Q7Operation {
    public CommitWorkingCopyOperation(IQ7NamedElement element, boolean force) {
        super(new IQ7Element[]{element}, force);
    }

    @Override
    protected void executeOperation() throws ModelException {
        try {
            this.beginTask("Commit working copy", 2);
            Q7NamedElement workingCopy = this.getNamedElement();
            IQ7NamedElement primary = workingCopy.getPrimary();
            IFile resource = (IFile)workingCopy.getResource();
            if (RcpttCore.isQ7File(resource.getFullPath())) {
                workingCopy.getInfo().save();
            }
            this.setAttribute("hasModifiedResource", "true");
            workingCopy.updateTimeStamp((Q7NamedElement)primary);
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    protected Q7NamedElement getNamedElement() {
        return (Q7NamedElement)this.getElementToProcess();
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        if (resource == null) {
            return null;
        }
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    @Override
    public Q7Status verify() {
        Q7NamedElement cu = this.getNamedElement();
        if (!cu.isWorkingCopy()) {
            return new Q7Status(0, "Is not a working copy");
        }
        if (cu.hasResourceChanged() && !this.force) {
            return new Q7Status(0, "Update conflict");
        }
        return Q7Status.OK;
    }
}

