/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.webapp.utils.Utils;

public class ContentService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String baseURL = req.getRequestURL().toString();
        String contentURL = baseURL.replaceFirst("/vs/service", "");
        String query = req.getQueryString();
        if (query != null) {
            contentURL = String.valueOf(contentURL) + '?' + query;
        }
        URL url = new URL(contentURL);
        URLConnection con = ProxyUtil.getConnection((URL)url);
        con.setAllowUserInteraction(false);
        con.setDoInput(true);
        con.connect();
        ServletContext context = this.getServletContext();
        String pathInfo = req.getPathInfo();
        String mimeType = context.getMimeType(pathInfo);
        String contentType = mimeType != null && !mimeType.equals("application/xhtml+xml") ? mimeType : con.getContentType();
        resp.setContentType(contentType);
        InputStream is = con.getInputStream();
        ServletOutputStream out = resp.getOutputStream();
        if (!(contentType.equals("application/xhtml+xml") || contentType.equals("text/html") || con.getContentType().equals("text/html"))) {
            Utils.transferContent(is, (OutputStream)out);
            out.flush();
        } else {
            String response = Utils.convertStreamToString(ProxyUtil.getStream((URL)url));
            response = Utils.updateResponse(response);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            writer.write(response);
            writer.close();
        }
    }
}

