/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.tesla.core.TeslaLimits;

public final class EclActivityMonitor
implements IProcess {
    private volatile boolean terminated = false;
    private volatile boolean restart = false;
    private final BaseAutLaunch aut;

    public EclActivityMonitor(BaseAutLaunch aut) {
        this.aut = aut;
    }

    public void startMonitor() {
        new Thread("RCPTT Connection monitor"){

            @Override
            public void run() {
                while (!EclActivityMonitor.this.terminated) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        EclActivityMonitor.this.terminate();
                    }
                    try {
                        if (EclActivityMonitor.this.restart) continue;
                        EclActivityMonitor.this.aut.ping();
                    }
                    catch (Exception exception) {
                        EclActivityMonitor.this.terminate();
                    }
                }
            }
        }.start();
    }

    public void waitForRestart(IProgressMonitor monitor) throws CoreException {
        this.restart = true;
        try {
            long startTime = System.currentTimeMillis();
            try {
                while (this.isActive()) {
                    if (monitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    this.waitFor(10L, startTime);
                }
                while (!this.isActive()) {
                    if (monitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    this.waitFor(50L, startTime);
                }
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching", e.getMessage(), (Throwable)e));
            }
        }
        finally {
            this.restart = false;
        }
    }

    private void waitFor(long time, long startTime) throws InterruptedException, CoreException {
        Thread.sleep(time);
        long currentTime = System.currentTimeMillis();
        if (currentTime > startTime + (long)TeslaLimits.getAUTStartupTimeout()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Waiting for restart failed: timeout error"));
        }
    }

    private boolean isActive() {
        try {
            this.aut.ping();
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        if (!this.terminated) {
            DebugEvent e = new DebugEvent((Object)this.getLaunch(), 8);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{e});
            e = new DebugEvent((Object)this, 8);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{e});
            this.terminated = true;
        }
    }

    public String getLabel() {
        return "Remote AUT connection";
    }

    public ILaunch getLaunch() {
        return this.aut.getLaunch();
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        return 0;
    }
}

