/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring.preferences;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.internal.monitoring.preferences.FilterInputDialog;
import org.eclipse.ui.internal.monitoring.preferences.Messages;

public class FilterListEditor
extends ListEditor {
    FilterListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getAddButton().setText(Messages.ListFieldEditor_add_filter_button_label);
        this.getUpButton().setVisible(false);
        this.getDownButton().setVisible(false);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        List list = this.getListControl(parent);
        GridData gd = new GridData(4, 4, true, true, numColumns - 1, 1);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(65);
        list.setLayoutData((Object)gd);
    }

    protected String createList(String[] items) {
        StringBuilder mergedItems = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            item.trim();
            if (mergedItems.length() != 0) {
                mergedItems.append(',');
            }
            mergedItems.append(item);
            ++n2;
        }
        return mergedItems.toString();
    }

    protected String getNewInputObject() {
        FilterInputDialog dialog = new FilterInputDialog(this.getShell());
        if (dialog.open() == 0) {
            return dialog.getFilter();
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        if (stringList.isEmpty()) {
            return new String[0];
        }
        return stringList.split(",");
    }

    protected void refreshValidState() {
        this.selectionChanged();
    }
}

