/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;

public class Q7TargetPlatformValidator {
    public static boolean validateUpdates(String location, ITargetPlatformHelper platform) {
        ITargetLocation[] containers;
        if (!platform.isValid()) {
            return false;
        }
        String path = platform.getTargetPlatformProfilePath();
        if (!location.equals(path)) {
            return false;
        }
        Q7TargetPlatformInitializer.Q7Info info = Q7TargetPlatformInitializer.getInfo(platform);
        if (info == null) {
            return false;
        }
        HashSet<URI> infoURIs = new HashSet<URI>();
        infoURIs.add(info.q7);
        infoURIs.add(info.deps);
        infoURIs.addAll(info.extra);
        HashSet<URI> curURIs = new HashSet<URI>();
        ITargetLocation[] iTargetLocationArray = containers = ((TargetPlatformHelper)platform).getBundleContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation iBundleContainer = iTargetLocationArray[n2];
            if (!(iBundleContainer instanceof ProfileBundleContainer) && iBundleContainer instanceof IUBundleContainer) {
                curURIs.addAll(Arrays.asList(((IUBundleContainer)iBundleContainer).getRepositories()));
            }
            ++n2;
        }
        return infoURIs.equals(curURIs);
    }
}

