/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.reporting.internal.ReportUtils;
import org.eclipse.rcptt.reporting.internal.Reports;
import org.eclipse.rcptt.reporting.internal.XMLUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public class JUnitXMLReportGenerator {
    private static final String formatTime(Node nde) {
        return ReportUtils.formatTime(nde.getEndTime() - nde.getStartTime());
    }

    public void writeContent(Reports reports, OutputStream stream) throws CoreException {
        XMLStreamWriter writer = XMLUtils.createWriter(stream);
        try {
            try {
                writer.writeStartDocument();
                writer.writeStartElement("testsuites");
                for (String suite : reports.getSuiteIds()) {
                    Q7Statistics statistics = ReportUtils.calculateStatistics(reports.getReports(suite));
                    this.writeSuite(writer, suite, reports.getReports(suite), statistics);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.flush();
            }
            catch (Exception ex) {
                throw new CoreException(Q7ReportingPlugin.createStatus(ex));
            }
        }
        finally {
            XMLUtils.closeWriter(writer);
        }
    }

    public void writeSuite(XMLStreamWriter writer, String name, Iterator<Report> reportList, Q7Statistics stats) throws XMLStreamException {
        writer.writeStartElement("testsuite");
        writer.writeAttribute("name", name);
        writer.writeAttribute("time", ReportUtils.formatTime(stats.getTime()));
        writer.writeAttribute("failures", Integer.toString(stats.getFailed()));
        writer.writeAttribute("tests", Integer.toString(stats.getTotal()));
        writer.writeAttribute("skipped", Integer.toString(stats.getSkipped()));
        writer.writeAttribute("errors", "0");
        while (reportList.hasNext()) {
            this.writeTestcase(writer, reportList.next());
        }
        writer.writeEndElement();
    }

    public void writeTestcase(XMLStreamWriter writer, Report report) throws XMLStreamException {
        Node item = report.getRoot();
        Q7Info info = (Q7Info)item.getProperties().get((Object)"q7");
        String name = info != null && info.getVariant() != null && info.getVariant().size() != 0 ? String.valueOf(item.getName()) + "_" + ReportUtils.combineNames(info.getVariant(), "_") : item.getName();
        writer.writeStartElement("testcase");
        writer.writeAttribute("name", name);
        writer.writeAttribute("time", JUnitXMLReportGenerator.formatTime(item));
        if (info != null && !info.getResult().equals((Object)ResultStatus.PASS)) {
            if (info.getResult().equals((Object)ResultStatus.SKIPPED)) {
                writer.writeAttribute("incomplete", "true");
            } else {
                writer.writeStartElement("failure");
                writer.writeAttribute("type", "testcase");
                writer.writeAttribute("message", ReportUtils.getFailMessage(item));
                String data = ReportUtils.getDetails(item).trim();
                if (data != null && !data.trim().isEmpty()) {
                    writer.writeCData(data);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public static void collectFailures(Node item, StringBuilder result) {
        Q7Info info = (Q7Info)item.getProperties().get((Object)"q7");
        if (info != null && info.getResult().equals((Object)ResultStatus.FAIL)) {
            String msg = info.getMessage();
            if (msg.contains("]]>")) {
                msg = msg.replace("]]>", "]] >");
            }
            if (msg != null) {
                result.append(msg).append(" [" + item.getName() + "]").append("\n");
            }
        }
        EList children = item.getChildren();
        for (Node node : children) {
            JUnitXMLReportGenerator.collectFailures(node, result);
        }
    }
}

