/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.internal.HttpServiceFactory;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ProxyServlet;
import org.eclipse.equinox.http.servlet.internal.util.HttpTuple;
import org.eclipse.equinox.http.servlet.internal.util.UMDictionaryMap;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<HttpServlet, HttpTuple> {
    private static final String DEFAULT_SERVICE_DESCRIPTION = "Equinox Servlet Bridge";
    private static final String DEFAULT_SERVICE_VENDOR = "Eclipse.org";
    private static final String[] HTTP_SERVICES_CLASSES = new String[]{HttpService.class.getName(), ExtendedHttpService.class.getName()};
    private static volatile BundleContext context;
    private static ConcurrentMap<ProxyServlet, Object> registrations;
    private ServiceTracker<HttpServlet, HttpTuple> serviceTracker;

    static {
        registrations = new ConcurrentHashMap<ProxyServlet, Object>();
    }

    public static void addProxyServlet(ProxyServlet proxyServlet) {
        Object previousRegistration = registrations.putIfAbsent(proxyServlet, (Object)proxyServlet);
        if (!(previousRegistration instanceof ServiceRegistration) && context != null) {
            ServiceRegistration serviceRegistration = context.registerService(HttpServlet.class, (Object)proxyServlet, new Hashtable());
            registrations.put(proxyServlet, serviceRegistration);
        }
    }

    public static void unregisterHttpService(ProxyServlet proxyServlet) {
        Object registration = registrations.remove((Object)proxyServlet);
        if (registration instanceof ServiceRegistration) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)registration;
            serviceRegistration.unregister();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.processRegistrations();
        this.serviceTracker = new ServiceTracker(context, HttpServlet.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serviceTracker.close();
        this.serviceTracker = null;
        context = null;
    }

    public HttpTuple addingService(ServiceReference<HttpServlet> serviceReference) {
        HttpServlet httpServlet = (HttpServlet)context.getService(serviceReference);
        if (!(httpServlet instanceof ProxyServlet)) {
            context.ungetService(serviceReference);
            return null;
        }
        ProxyServlet proxyServlet = (ProxyServlet)httpServlet;
        ServletConfig servletConfig = proxyServlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String[] httpServiceEndpoints = this.getHttpServiceEndpoints(servletContext, servletConfig.getServletName());
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>(3);
        Enumeration initparameterNames = servletConfig.getInitParameterNames();
        while (initparameterNames.hasMoreElements()) {
            String name = (String)initparameterNames.nextElement();
            ((Dictionary)serviceProperties).put(name, servletConfig.getInitParameter(name));
        }
        if (((Dictionary)serviceProperties).get("service.vendor") == null) {
            ((Dictionary)serviceProperties).put("service.vendor", DEFAULT_SERVICE_VENDOR);
        }
        if (((Dictionary)serviceProperties).get("service.description") == null) {
            ((Dictionary)serviceProperties).put("service.description", DEFAULT_SERVICE_DESCRIPTION);
        }
        if (((Dictionary)serviceProperties).get("osgi.http.endpoint") == null) {
            ((Dictionary)serviceProperties).put("osgi.http.endpoint", httpServiceEndpoints);
        }
        HttpServiceRuntimeImpl httpServiceRuntime = new HttpServiceRuntimeImpl(context, servletContext, new UMDictionaryMap<String, Object>(serviceProperties));
        ServiceRegistration hsrRegistration = context.registerService(HttpServiceRuntime.class, (Object)httpServiceRuntime, serviceProperties);
        proxyServlet.setHttpServiceRuntimeImpl(httpServiceRuntime);
        HttpServiceFactory httpServiceFactory = new HttpServiceFactory(httpServiceRuntime);
        ServiceRegistration hsfRegistration = context.registerService(HTTP_SERVICES_CLASSES, (Object)httpServiceFactory, serviceProperties);
        return new HttpTuple(proxyServlet, httpServiceFactory, hsfRegistration, httpServiceRuntime, (ServiceRegistration<HttpServiceRuntime>)hsrRegistration);
    }

    public void modifiedService(ServiceReference<HttpServlet> serviceReference, HttpTuple httpTuple) {
        this.removedService(serviceReference, httpTuple);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<HttpServlet> serviceReference, HttpTuple httpTuple) {
        context.ungetService(serviceReference);
        httpTuple.destroy();
    }

    private String[] getHttpServiceEndpoints(ServletContext servletContext, String servletName) {
        int majorVersion = servletContext.getMajorVersion();
        if (majorVersion < 3) {
            servletContext.log("The http container does not support servlet 3.0+. Therefore, the value of osgi.http.endpoint cannot be calculated.");
            return new String[0];
        }
        String contextPath = servletContext.getContextPath();
        ServletRegistration servletRegistration = servletContext.getServletRegistration(servletName);
        if (servletRegistration == null) {
            return new String[0];
        }
        Collection mappings = servletRegistration.getMappings();
        ArrayList<String> httpServiceEndpoints = new ArrayList<String>();
        for (String mapping : mappings) {
            if (mapping.indexOf(47) != 0) continue;
            if (mapping.charAt(mapping.length() - 1) == '*' && (mapping = mapping.substring(0, mapping.length() - 2)).length() > 1 && mapping.charAt(mapping.length() - 1) != '/') {
                mapping = String.valueOf(mapping) + '/';
            }
            httpServiceEndpoints.add(String.valueOf(contextPath) + mapping);
        }
        return httpServiceEndpoints.toArray(new String[httpServiceEndpoints.size()]);
    }

    private void processRegistrations() {
        for (Map.Entry entry : registrations.entrySet()) {
            ProxyServlet proxyServlet = (ProxyServlet)((Object)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof ServiceRegistration) continue;
            ServiceRegistration serviceRegistration = context.registerService(HttpServlet.class, (Object)proxyServlet, new Hashtable());
            entry.setValue(serviceRegistration);
        }
    }
}

