/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.EventListener;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextListenerTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<EventListener, ListenerRegistration> {
    private ContextController contextController;

    public ContextListenerTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public ListenerRegistration addingService(ServiceReference<EventListener> serviceReference) {
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return null;
        }
        String contextSelector = (String)serviceReference.getProperty("osgi.http.whiteboard.context.select");
        if (!this.contextController.matches(contextSelector)) {
            return null;
        }
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        EventListener eventListener = (EventListener)this.bundleContext.getService(serviceReference);
        try {
            return this.contextController.addListenerRegistration(eventListener, serviceId);
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
            return null;
        }
    }

    public void modifiedService(ServiceReference<EventListener> serviceReference, ListenerRegistration listenerRegistration) {
    }

    public void removedService(ServiceReference<EventListener> serviceReference, ListenerRegistration listenerRegistration) {
        this.bundleContext.ungetService(serviceReference);
        listenerRegistration.destroy();
    }
}

