/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.Enumeration;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpSessionAdaptor
implements HttpSession {
    private EventListeners eventListeners;
    private HttpSession session;
    private Servlet servlet;

    public HttpSessionAdaptor(HttpSession session, Servlet servlet, EventListeners eventListeners) {
        this.session = session;
        this.servlet = servlet;
        this.eventListeners = eventListeners;
    }

    public ServletContext getServletContext() {
        return this.servlet.getServletConfig().getServletContext();
    }

    public Object getAttribute(String arg0) {
        return this.session.getAttribute(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public Object getValue(String arg0) {
        return this.session.getValue(arg0);
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void putValue(String arg0, Object arg1) {
        this.session.putValue(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        this.session.removeAttribute(arg0);
        List<HttpSessionAttributeListener> listeners = this.eventListeners.get(HttpSessionAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent(this.session, arg0);
        for (HttpSessionAttributeListener httpSessionAttributeListener : listeners) {
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void removeValue(String arg0) {
        this.session.removeValue(arg0);
        List<HttpSessionAttributeListener> listeners = this.eventListeners.get(HttpSessionAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent(this.session, arg0);
        for (HttpSessionAttributeListener httpSessionAttributeListener : listeners) {
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void setAttribute(String arg0, Object arg1) {
        boolean added = this.session.getAttribute(arg0) == null;
        this.session.setAttribute(arg0, arg1);
        List<HttpSessionAttributeListener> listeners = this.eventListeners.get(HttpSessionAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent(this.session, arg0, arg1);
        for (HttpSessionAttributeListener httpSessionAttributeListener : listeners) {
            if (added) {
                httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                continue;
            }
            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
        }
    }

    public void setMaxInactiveInterval(int arg0) {
        this.session.setMaxInactiveInterval(arg0);
    }
}

