/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.servlet.NamedDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;

public class ServletContextAdaptor {
    private static final Map<Method, Method> contextToHandlerMethods = ServletContextAdaptor.createContextToHandlerMethods();
    private final AccessControlContext acc;
    private final Bundle bundle;
    private final ClassLoader classLoader;
    private final ContextController contextController;
    private final String contextName;
    private final EventListeners eventListeners;
    private final ProxyContext proxyContext;
    private final ServletContext servletContext;
    final ServletContextHelper servletContextHelper;
    private final ThreadLocal<ServletContext> servletContextTL = new ThreadLocal();

    private static Map<Method, Method> createContextToHandlerMethods() {
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        Method[] handlerMethods = ServletContextAdaptor.class.getDeclaredMethods();
        int i = 0;
        while (i < handlerMethods.length) {
            Method handlerMethod = handlerMethods[i];
            String name = handlerMethod.getName();
            Class<?>[] parameterTypes = handlerMethod.getParameterTypes();
            try {
                Method method = ServletContext.class.getMethod(name, parameterTypes);
                methods.put(method, handlerMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            ++i;
        }
        return methods;
    }

    public ServletContextAdaptor(ContextController contextController, Bundle bundle, ServletContextHelper servletContextHelper, EventListeners eventListeners, AccessControlContext acc) {
        this.contextController = contextController;
        this.proxyContext = contextController.getProxyContext();
        this.servletContext = this.proxyContext.getServletContext();
        this.contextName = contextController.getContextNames().get(0);
        this.servletContextHelper = servletContextHelper;
        this.eventListeners = eventListeners;
        this.acc = acc;
        this.bundle = bundle;
        BundleWiring bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        this.classLoader = bundleWiring.getClassLoader();
    }

    public ServletContext createServletContext() {
        Class<?> clazz = this.getClass();
        ClassLoader curClassLoader = clazz.getClassLoader();
        Class[] interfaces = new Class[]{ServletContext.class};
        InvocationHandler invocationHandler = this.createInvocationHandler();
        return (ServletContext)Proxy.newProxyInstance(curClassLoader, interfaces, invocationHandler);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextController.getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        if (attributeName.equals("osgi-bundlecontext")) {
            return this.bundle.getBundleContext();
        }
        return attributes.get(attributeName);
    }

    public Enumeration<String> getAttributeNames() {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        return attributes.keys();
    }

    public String getInitParameter(String name) {
        return this.contextController.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.contextController.getInitParams().keySet());
    }

    public String getMimeType(final String name) {
        String mimeType = null;
        try {
            mimeType = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ServletContextAdaptor.this.servletContextHelper.getMimeType(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
        }
        return mimeType != null ? mimeType : this.servletContext.getMimeType(name);
    }

    public RequestDispatcher getNamedDispatcher(String servletName) {
        DispatchTargets dispatchTargets = this.contextController.getDispatchTargets(null, servletName, null, null, null, null, Match.EXACT, null);
        if (dispatchTargets == null) {
            return null;
        }
        return new NamedDispatcherAdaptor(dispatchTargets);
    }

    public String getRealPath(final String path) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ServletContextAdaptor.this.servletContextHelper.getRealPath(path);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith(this.getContextPath())) {
            path = this.getContextPath().substring(this.servletContext.getContextPath().length()).concat(path);
        }
        return new RequestDispatcherAdaptor(this.servletContext.getRequestDispatcher(path));
    }

    public URL getResource(final String name) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return ServletContextAdaptor.this.servletContextHelper.getResource(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                this.servletContext.log(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(final String name) {
        if (name == null || !name.startsWith("/")) {
            return null;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                @Override
                public Set<String> run() throws Exception {
                    return ServletContextAdaptor.this.servletContextHelper.getResourcePaths(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public String getServletContextName() {
        return this.contextName;
    }

    public void removeAttribute(String attributeName) {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        Object attributeValue = attributes.remove(attributeName);
        List<ServletContextAttributeListener> listeners = this.eventListeners.get(ServletContextAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.servletContextTL.get(), attributeName, attributeValue);
        for (ServletContextAttributeListener servletContextAttributeListener : listeners) {
            servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        Dictionary<String, Object> attributes = this.getContextAttributes();
        boolean added = attributes.get(attributeName) == null;
        attributes.put(attributeName, attributeValue);
        List<ServletContextAttributeListener> listeners = this.eventListeners.get(ServletContextAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.servletContextTL.get(), attributeName, attributeValue);
        for (ServletContextAttributeListener servletContextAttributeListener : listeners) {
            if (added) {
                servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                continue;
            }
            servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
        }
    }

    Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.servletContextTL.set((ServletContext)proxy);
        try {
            Method m = contextToHandlerMethods.get(method);
            if (m != null) {
                Object object = m.invoke((Object)this, args);
                return object;
            }
            Object object = method.invoke((Object)this.servletContext, args);
            return object;
        }
        finally {
            this.servletContextTL.remove();
        }
    }

    private InvocationHandler createInvocationHandler() {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return ServletContextAdaptor.this.invoke(proxy, method, args);
            }
        };
    }

    private Dictionary<String, Object> getContextAttributes() {
        return this.proxyContext.getContextAttributes(this.servletContextHelper);
    }
}

