/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IndexDiffUpdateJob
extends Job {
    private final long defaultDelay;
    private Object lock = new Object();
    private Set<String> files;
    private Set<IResource> resources;

    public IndexDiffUpdateJob(String name, long delay) {
        super(name);
        this.defaultDelay = delay;
        this.files = new HashSet<String>();
        this.resources = new HashSet<IResource>();
    }

    abstract IStatus updateIndexDiff(Collection<String> var1, Collection<IResource> var2, IProgressMonitor var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IStatus run(IProgressMonitor monitor) {
        Set<IResource> resourcesToUpdate;
        Set<String> filesToUpdate;
        Object object = this.lock;
        synchronized (object) {
            filesToUpdate = this.files;
            resourcesToUpdate = this.resources;
            this.files = new HashSet<String>();
            this.resources = new HashSet<IResource>();
            if (monitor.isCanceled() || filesToUpdate.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
        }
        return this.updateIndexDiff(filesToUpdate, resourcesToUpdate, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChanges(Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) {
        Object object = this.lock;
        synchronized (object) {
            this.files.addAll(filesToUpdate);
            this.resources.addAll(resourcesToUpdate);
        }
        if (!filesToUpdate.isEmpty()) {
            this.schedule(this.defaultDelay);
        }
    }
}

