/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.progress.IProgressConstants2;

public class BuildAction
extends WorkspaceAction {
    public static final String ID_BUILD = "org.eclipse.ui.BuildAction";
    public static final String ID_REBUILD_ALL = "org.eclipse.ui.RebuildAllAction";
    private int buildType;
    private List projectsToBuild = null;
    private List projectConfigsToBuild = null;

    @Deprecated
    public BuildAction(Shell shell, int type) {
        super(shell, "");
        this.initAction(type);
    }

    public BuildAction(IShellProvider provider, int type) {
        super(provider, "");
        this.initAction(type);
    }

    private void initAction(int type) {
        if (type == 10) {
            this.setText(IDEWorkbenchMessages.BuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.BuildAction_toolTip);
            this.setId(ID_BUILD);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.incremental_build_action_context");
        } else {
            this.setText(IDEWorkbenchMessages.RebuildAction_text);
            this.setToolTipText(IDEWorkbenchMessages.RebuildAction_tooltip);
            this.setId(ID_REBUILD_ALL);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.full_build_action_context");
        }
        this.buildType = type;
    }

    @Override
    protected List getActionResources() {
        return this.getProjectsToBuild();
    }

    @Override
    protected String getOperationMessage() {
        return IDEWorkbenchMessages.BuildAction_operationMessage;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.BuildAction_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.BuildAction_problemTitle;
    }

    List getProjectsToBuild() {
        if (this.projectsToBuild == null) {
            HashSet<IProject> projects = new HashSet<IProject>(3);
            List configurations = this.getBuildConfigurationsToBuild();
            Iterator it = configurations.iterator();
            while (it.hasNext()) {
                projects.add(((IBuildConfiguration)it.next()).getProject());
            }
            this.projectsToBuild = new ArrayList(projects);
        }
        return this.projectsToBuild;
    }

    protected List getBuildConfigurationsToBuild() {
        if (this.projectConfigsToBuild == null) {
            HashSet<IBuildConfiguration> configs = new HashSet<IBuildConfiguration>(3);
            for (IResource resource : this.getSelectedResources()) {
                IProject project = resource.getProject();
                if (project == null || !this.hasBuilder(project)) continue;
                try {
                    configs.add(project.getActiveBuildConfig());
                }
                catch (CoreException coreException) {}
            }
            this.projectConfigsToBuild = new ArrayList(configs);
        }
        return this.projectConfigsToBuild;
    }

    boolean hasBuilder(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object[])BuildUtilities.findSelectedProjects(window)));
        }
        return super.isEnabled();
    }

    public static boolean isSaveAllSet() {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("SAVE_ALL_BEFORE_BUILD");
    }

    @Override
    public void run() {
        List buildConfigurations = this.getBuildConfigurationsToBuild();
        if (buildConfigurations == null || buildConfigurations.isEmpty()) {
            return;
        }
        BuildUtilities.saveEditors(this.getProjectsToBuild());
        this.runInBackground(null, ResourcesPlugin.FAMILY_MANUAL_BUILD);
    }

    @Override
    public void runInBackground(ISchedulingRule rule, Object[] jobFamilies) {
        final int kind = this.buildType;
        List buildConfigurations = this.getBuildConfigurationsToBuild();
        if (buildConfigurations == null || buildConfigurations.isEmpty()) {
            return;
        }
        final IBuildConfiguration[] configs = buildConfigurations.toArray(new IBuildConfiguration[buildConfigurations.size()]);
        WorkspaceJob job = new WorkspaceJob(BuildAction.removeMnemonics((String)this.getText())){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = null;
                monitor.beginTask("", 10000);
                monitor.setTaskName(BuildAction.this.getOperationMessage());
                try {
                    ResourcesPlugin.getWorkspace().build(configs, kind, BuildAction.this.shouldPerformResourcePruning(), (IProgressMonitor)new SubProgressMonitor(monitor, 10000));
                }
                catch (CoreException e) {
                    status = e.getStatus();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.done();
                return status == null ? Status.OK_STATUS : status;
            }
        };
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        job.setUser(true);
        job.schedule();
    }

    @Override
    protected boolean shouldPerformResourcePruning() {
        return true;
    }

    @Override
    protected boolean updateSelection(IStructuredSelection s) {
        this.projectConfigsToBuild = null;
        this.projectsToBuild = null;
        IProject[] projects = this.getProjectsToBuild().toArray(new IProject[0]);
        return BuildUtilities.isEnabled(projects, 10);
    }
}

