/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.internal.p2.ui.dialogs.AddRepositoryDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryManipulatorDropTarget;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.viewers.MetadataRepositoryElementComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.RepositoryDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ICopyable;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class RepositoryManipulationPage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICopyable {
    static final String DEFAULT_FILTER_TEXT = ProvUIMessages.RepositoryManipulationPage_DefaultFilterString;
    private static final int FILTER_DELAY = 200;
    StructuredViewerProvisioningListener listener;
    CheckboxTableViewer repositoryViewer;
    Table table;
    ProvisioningUI ui;
    Policy policy;
    Display display;
    boolean changed = false;
    MetadataRepositoryElementComparator comparator;
    RepositoryDetailsLabelProvider labelProvider;
    RepositoryTracker tracker;
    RepositoryTracker localCacheRepoManipulator;
    CachedMetadataRepositories input;
    Text pattern;
    Text details;
    PatternFilter filter;
    WorkbenchJob filterJob;
    Button addButton;
    Button removeButton;
    Button editButton;
    Button refreshButton;
    Button disableButton;
    Button exportButton;
    private Map<MetadataRepositoryElement, URI> originalURICache = new HashMap<MetadataRepositoryElement, URI>(2);
    private Map<MetadataRepositoryElement, String> originalNameCache = new HashMap<MetadataRepositoryElement, String>(2);

    public RepositoryManipulationPage() {
        this.setProvisioningUI(ProvisioningUI.getDefaultUI());
    }

    public void setProvisioningUI(ProvisioningUI ui) {
        this.ui = ui;
        this.policy = ui.getPolicy();
        this.tracker = ui.getRepositoryTracker();
    }

    protected Control createContents(Composite parent) {
        this.display = parent.getDisplay();
        if (this.policy.getRepositoriesVisible()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), "org.eclipse.equinox.p2.ui.repository_manipulation_dialog_context");
        }
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.policy.getRepositoriesVisible() ? 2 : 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.pattern = new Text(composite, 2436);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DEFAULT_FILTER_TEXT;
            }
        });
        this.pattern.setText(DEFAULT_FILTER_TEXT);
        this.pattern.selectAll();
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryManipulationPage.this.applyFilter();
            }
        });
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (RepositoryManipulationPage.this.table.getItemCount() > 0) {
                        RepositoryManipulationPage.this.table.setFocus();
                    } else if (e.character == '\r') {
                        return;
                    }
                }
            }
        });
        this.pattern.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RepositoryManipulationPage.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).RepositoryManipulationPage.this.pattern.isDisposed() && DEFAULT_FILTER_TEXT.equals((this).RepositoryManipulationPage.this.pattern.getText().trim())) {
                            (this).RepositoryManipulationPage.this.pattern.selectAll();
                        }
                    }
                });
            }
        });
        gd = new GridData(4, 4, true, false);
        this.pattern.setLayoutData((Object)gd);
        if (this.policy.getRepositoriesVisible()) {
            new Label(composite, 0);
        }
        this.table = new Table(composite, 68386);
        this.repositoryViewer = new CheckboxTableViewer(this.table);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    RepositoryManipulationPage.this.removeRepositories();
                }
            }
        });
        this.setTableColumns();
        CopyUtils.activateCopy(this, (Control)this.table);
        this.repositoryViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.comparator = new MetadataRepositoryElementComparator(0);
        this.repositoryViewer.setComparator((ViewerComparator)this.comparator);
        this.filter = new MetadataRepositoryPatternFilter();
        this.repositoryViewer.setFilters(new ViewerFilter[]{this.filter});
        this.repositoryViewer.setContentProvider((IContentProvider)new ProvElementContentProvider());
        this.labelProvider = new RepositoryDetailsLabelProvider();
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.repositoryViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof MetadataRepositoryElement;
            }

            public Object getValue(Object element, String property) {
                return ((MetadataRepositoryElement)element).getName();
            }

            public void modify(Object element, String property, Object value) {
                if (value != null && value.toString().length() >= 0) {
                    MetadataRepositoryElement repo;
                    if (element instanceof Item) {
                        repo = (MetadataRepositoryElement)((Item)element).getData();
                    } else if (element instanceof MetadataRepositoryElement) {
                        repo = (MetadataRepositoryElement)element;
                    } else {
                        return;
                    }
                    if (!value.toString().equals(repo.getName())) {
                        RepositoryManipulationPage.this.changed = true;
                        repo.setNickname(value.toString());
                        if (RepositoryManipulationPage.this.comparator.getSortKey() == 0) {
                            RepositoryManipulationPage.this.repositoryViewer.refresh(true);
                        } else {
                            RepositoryManipulationPage.this.repositoryViewer.update((Object)repo, null);
                        }
                    }
                }
            }
        });
        this.repositoryViewer.setColumnProperties(new String[]{"nickname"});
        this.repositoryViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.repositoryViewer.getTable())});
        this.repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryManipulationPage.this.policy.getRepositoriesVisible()) {
                    RepositoryManipulationPage.this.validateButtons();
                }
                RepositoryManipulationPage.this.setDetails();
            }
        });
        this.repositoryViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((MetadataRepositoryElement)element).isEnabled();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MetadataRepositoryElement element = (MetadataRepositoryElement)event.getElement();
                element.setEnabled(event.getChecked());
                RepositoryManipulationPage.this.getInput().put(element);
                RepositoryManipulationPage.this.updateForEnablementChange(new MetadataRepositoryElement[]{element});
            }
        });
        this.repositoryViewer.setInput((Object)this.getInput());
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        this.table.setLayoutData((Object)data);
        if (this.policy.getRepositoriesVisible()) {
            DropTarget target = new DropTarget((Control)this.table, 7);
            target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
            target.addDropListener((DropTargetListener)new RepositoryManipulatorDropTarget(this.ui, (Control)this.table));
            Composite verticalButtonBar = this.createVerticalButtonBar(composite);
            data = new GridData(4, 4, false, false);
            data.verticalAlignment = 128;
            data.verticalIndent = 0;
            verticalButtonBar.setLayoutData((Object)data);
            this.listener = this.getViewerProvisioningListener();
            ProvUI.getProvisioningEventBus(this.ui.getSession()).addListener((ProvisioningListener)this.listener);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ProvUI.getProvisioningEventBus(RepositoryManipulationPage.this.ui.getSession()).removeListener((ProvisioningListener)RepositoryManipulationPage.this.listener);
                }
            });
            this.validateButtons();
        }
        this.details = new Text(composite, 72);
        data = new GridData(4, 4, true, false);
        data.heightHint = this.convertHeightInCharsToPixels(2);
        this.details.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Button createVerticalButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = this.setVerticalButtonLayoutData(button);
        data.horizontalAlignment = 4;
        button.setToolTipText(label);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        return button;
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void setTableColumns() {
        this.table.setHeaderVisible(true);
        String[] columnHeaders = this.policy.getRepositoriesVisible() ? new String[]{ProvUIMessages.RepositoryManipulationPage_NameColumnTitle, ProvUIMessages.RepositoryManipulationPage_LocationColumnTitle, ProvUIMessages.RepositoryManipulationPage_EnabledColumnTitle} : new String[]{ProvUIMessages.RepositoryManipulationPage_NameColumnTitle, ProvUIMessages.RepositoryManipulationPage_LocationColumnTitle};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(true);
            tc.setText(columnHeaders[i]);
            if (i == 2) {
                tc.setWidth(this.convertWidthInCharsToPixels(20));
                tc.setAlignment(0x1000000);
            } else if (i == 0) {
                tc.setWidth(this.convertWidthInCharsToPixels(40));
            } else {
                tc.setWidth(this.convertWidthInCharsToPixels(60));
            }
            tc.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    RepositoryManipulationPage.this.columnSelected((TableColumn)e.widget);
                }

                public void widgetSelected(SelectionEvent e) {
                    RepositoryManipulationPage.this.columnSelected((TableColumn)e.widget);
                }
            });
            if (i == 0) {
                this.table.setSortColumn(tc);
                this.table.setSortDirection(128);
            }
            ++i;
        }
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.createVerticalButtons(composite);
        return composite;
    }

    private void createVerticalButtons(Composite parent) {
        this.addButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Add, false);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.addRepository();
            }
        });
        this.editButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Edit, false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.changeRepositoryProperties();
            }
        });
        this.removeButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Remove, false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.removeRepositories();
            }
        });
        this.refreshButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_RefreshConnection, false);
        this.refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.refreshRepository();
            }
        });
        this.disableButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_DisableButton, false);
        this.disableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.toggleRepositoryEnablement();
            }
        });
        Button button = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Import, false);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.importRepositories();
            }
        });
        this.exportButton = this.createVerticalButton(parent, ProvUIMessages.RepositoryManipulationPage_Export, false);
        this.exportButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationPage.this.exportRepositories();
            }
        });
    }

    CachedMetadataRepositories getInput() {
        if (this.input == null) {
            this.input = new CachedMetadataRepositories();
        }
        return this.input;
    }

    public boolean performOk() {
        if (this.changed) {
            ElementUtils.updateRepositoryUsingElements(this.ui, this.getElements(), this.getShell());
        }
        this.originalNameCache.clear();
        this.originalURICache.clear();
        return super.performOk();
    }

    private StructuredViewerProvisioningListener getViewerProvisioningListener() {
        return new StructuredViewerProvisioningListener(this.getClass().getName(), (StructuredViewer)this.repositoryViewer, 1, this.ui.getOperationRunner()){

            @Override
            protected void repositoryDiscovered(RepositoryEvent e) {
                RepositoryManipulationPage.this.safeRefresh(null);
            }

            @Override
            protected void repositoryChanged(RepositoryEvent e) {
                RepositoryManipulationPage.this.safeRefresh(null);
            }
        };
    }

    MetadataRepositoryElement[] getElements() {
        return this.getInput().getElements();
    }

    MetadataRepositoryElement[] getSelectedElements() {
        Object[] items = ((IStructuredSelection)this.repositoryViewer.getSelection()).toArray();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MetadataRepositoryElement) {
                list.add(items[i]);
            }
            ++i;
        }
        return list.toArray(new MetadataRepositoryElement[list.size()]);
    }

    void validateButtons() {
        MetadataRepositoryElement[] elements = this.getSelectedElements();
        this.exportButton.setEnabled(elements.length > 0);
        this.removeButton.setEnabled(elements.length > 0);
        this.editButton.setEnabled(elements.length == 1);
        this.refreshButton.setEnabled(elements.length == 1);
        if (elements.length >= 1) {
            if (this.toggleMeansDisable(elements)) {
                this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_DisableButton);
            } else {
                this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_EnableButton);
            }
            this.disableButton.setEnabled(true);
        } else {
            this.disableButton.setText(ProvUIMessages.RepositoryManipulationPage_EnableButton);
            this.disableButton.setEnabled(false);
        }
    }

    void addRepository() {
        AddRepositoryDialog dialog = new AddRepositoryDialog(this.getShell(), this.ui){

            @Override
            protected RepositoryTracker getRepositoryTracker() {
                return RepositoryManipulationPage.this.getLocalCacheRepoTracker();
            }
        };
        dialog.setTitle(ProvUIMessages.ColocatedRepositoryManipulator_AddSiteOperationLabel);
        dialog.open();
    }

    void refreshRepository() {
        MetadataRepositoryElement[] selected = this.getSelectedElements();
        final ProvisionException[] fail = new ProvisionException[1];
        final boolean[] remove = new boolean[]{false};
        if (selected.length != 1) {
            return;
        }
        final URI location = selected[0].getLocation();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_ContactingSiteMessage, (Object)location), 100);
                    try {
                        try {
                            RepositoryManipulationPage.this.ui.signalRepositoryOperationStart();
                            RepositoryManipulationPage.this.tracker.clearRepositoryNotFound(location);
                            if (!RepositoryManipulationPage.this.includesRepo(RepositoryManipulationPage.this.tracker.getKnownRepositories(RepositoryManipulationPage.this.ui.getSession()), location)) {
                                remove[0] = true;
                                ProvUI.getMetadataRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).addRepository(location);
                                ProvUI.getArtifactRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).addRepository(location);
                            }
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
                            try {
                                ProvUI.getMetadataRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).refreshRepository(location, (IProgressMonitor)sub.newChild(100));
                            }
                            catch (ProvisionException e) {
                                fail[0] = e;
                            }
                            try {
                                ProvUI.getArtifactRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).refreshRepository(location, (IProgressMonitor)sub.newChild(100));
                            }
                            catch (ProvisionException e) {
                                LogHelper.log((ProvisionException)e);
                            }
                        }
                        catch (OperationCanceledException e) {
                            fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled, (Throwable)e));
                            if (fail[0] == null && monitor.isCanceled()) {
                                fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                            }
                            if (remove[0]) {
                                ProvUI.getMetadataRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).removeRepository(location);
                                ProvUI.getArtifactRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).removeRepository(location);
                            }
                            RepositoryManipulationPage.this.ui.signalRepositoryOperationComplete(null, false);
                        }
                    }
                    finally {
                        if (fail[0] == null && monitor.isCanceled()) {
                            fail[0] = new ProvisionException((IStatus)new Status(8, "org.eclipse.equinox.p2.ui", ProvUIMessages.RepositoryManipulationPage_RefreshOperationCanceled));
                        }
                        if (remove[0]) {
                            ProvUI.getMetadataRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).removeRepository(location);
                            ProvUI.getArtifactRepositoryManager(RepositoryManipulationPage.this.ui.getSession()).removeRepository(location);
                        }
                        RepositoryManipulationPage.this.ui.signalRepositoryOperationComplete(null, false);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (fail[0] != null) {
            if (fail[0].getStatus().getCode() == 1000) {
                this.tracker.addNotFound(location);
            }
            if (!fail[0].getStatus().matches(8)) {
                ProvUI.handleException(fail[0], null, 2);
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ProvUIMessages.RepositoryManipulationPage_TestConnectionTitle, (String)NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_TestConnectionSuccess, (Object)URIUtil.toUnencodedString((URI)location)));
        }
        this.repositoryViewer.update((Object)selected[0], null);
        this.setDetails();
    }

    boolean includesRepo(URI[] repos, URI repo) {
        int i = 0;
        while (i < repos.length) {
            if (repos[i].equals(repo)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void toggleRepositoryEnablement() {
        MetadataRepositoryElement[] selected = this.getSelectedElements();
        if (selected.length >= 1) {
            boolean enableSites = !this.toggleMeansDisable(selected);
            int i = 0;
            while (i < selected.length) {
                selected[i].setEnabled(enableSites);
                this.getInput().put(selected[i]);
                ++i;
            }
            this.updateForEnablementChange(selected);
        }
        this.validateButtons();
    }

    void updateForEnablementChange(MetadataRepositoryElement[] updated) {
        if (this.comparator.getSortKey() == 2) {
            this.repositoryViewer.refresh(true);
        } else {
            int i = 0;
            while (i < updated.length) {
                this.repositoryViewer.update((Object)updated[i], null);
                ++i;
            }
        }
        this.changed = true;
    }

    void importRepositories() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MetadataRepositoryElement[] imported = UpdateManagerCompatibility.importSites(RepositoryManipulationPage.this.getShell());
                if (imported.length > 0) {
                    RepositoryManipulationPage.this.changed = true;
                    int i = 0;
                    while (i < imported.length) {
                        RepositoryManipulationPage.this.getInput().put(imported[i]);
                        ++i;
                    }
                    RepositoryManipulationPage.this.safeRefresh(null);
                }
            }
        });
    }

    void exportRepositories() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MetadataRepositoryElement[] elements = RepositoryManipulationPage.this.getSelectedElements();
                if (elements.length == 0) {
                    elements = RepositoryManipulationPage.this.getElements();
                }
                UpdateManagerCompatibility.exportSites(RepositoryManipulationPage.this.getShell(), elements);
            }
        });
    }

    void changeRepositoryProperties() {
        final MetadataRepositoryElement[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        URI originalLocation = null;
        String originalName = null;
        originalLocation = this.originalURICache.containsKey(selected[0]) ? this.originalURICache.get(selected[0]) : selected[0].getLocation();
        originalName = this.originalNameCache.containsKey(selected[0]) ? this.originalNameCache.get(selected[0]) : selected[0].getName();
        final URI existingLocation = originalLocation;
        RepositoryNameAndLocationDialog dialog = new RepositoryNameAndLocationDialog(this.getShell(), this.ui){

            @Override
            protected String getInitialLocationText() {
                return URIUtil.toUnencodedString((URI)selected[0].getLocation());
            }

            @Override
            protected String getInitialNameText() {
                return selected[0].getName();
            }

            @Override
            protected URI getOriginalLocation() {
                return existingLocation;
            }
        };
        int retCode = dialog.open();
        if (retCode == 0 && dialog.getLocation() != null) {
            selected[0].setNickname(dialog.getName());
            selected[0].setLocation(dialog.getLocation());
            if (dialog.getLocation().equals(existingLocation)) {
                this.originalURICache.remove(selected[0]);
            } else if (!this.originalURICache.containsKey(selected[0])) {
                this.originalURICache.put(selected[0], existingLocation);
            }
            if (dialog.getName().equals(originalName)) {
                this.originalNameCache.remove(selected[0]);
            } else if (!this.originalNameCache.containsKey(selected[0])) {
                this.originalNameCache.put(selected[0], originalName);
            }
            this.changed = this.originalURICache.size() > 0 || this.originalNameCache.size() > 0;
            this.repositoryViewer.update((Object)selected[0], null);
            this.setDetails();
        }
    }

    void columnSelected(TableColumn tc) {
        TableColumn[] cols = this.table.getColumns();
        int i = 0;
        while (i < cols.length) {
            if (cols[i] == tc) {
                if (i != this.comparator.getSortKey()) {
                    this.comparator.setSortKey(i);
                    this.table.setSortColumn(tc);
                    this.comparator.sortAscending();
                    this.table.setSortDirection(128);
                } else if (this.comparator.isAscending()) {
                    this.table.setSortDirection(1024);
                    this.comparator.sortDescending();
                } else {
                    this.table.setSortDirection(128);
                    this.comparator.sortAscending();
                }
                this.repositoryViewer.refresh();
                break;
            }
            ++i;
        }
    }

    void safeRefresh(final MetadataRepositoryElement elementToSelect) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RepositoryManipulationPage.this.repositoryViewer.refresh();
                if (elementToSelect != null) {
                    RepositoryManipulationPage.this.repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
                }
            }
        };
        if (Display.getCurrent() == null) {
            this.display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    void applyFilter() {
        String text = this.pattern.getText();
        if (text == DEFAULT_FILTER_TEXT) {
            text = "";
        }
        if (text.length() == 0) {
            this.filter.setPattern(null);
        } else {
            this.filter.setPattern(text);
        }
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
        this.filterJob = new WorkbenchJob("filter job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!RepositoryManipulationPage.this.repositoryViewer.getTable().isDisposed()) {
                    RepositoryManipulationPage.this.repositoryViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        this.filterJob.setSystem(true);
        this.filterJob.schedule(200L);
    }

    void setDetails() {
        MetadataRepositoryElement[] selections = this.getSelectedElements();
        if (selections.length == 1) {
            this.details.setText(selections[0].getDescription());
        } else {
            this.details.setText("");
        }
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
        if (this.ui == null) {
            this.setProvisioningUI(ProvisioningUI.getDefaultUI());
        }
    }

    void removeRepositories() {
        MetadataRepositoryElement[] selections = this.getSelectedElements();
        if (selections.length > 0) {
            String message = ProvUIMessages.RepositoryManipulationPage_RemoveConfirmMessage;
            if (selections.length == 1) {
                message = NLS.bind((String)ProvUIMessages.RepositoryManipulationPage_RemoveConfirmSingleMessage, (Object)URIUtil.toUnencodedString((URI)selections[0].getLocation()));
            }
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ProvUIMessages.RepositoryManipulationPage_RemoveConfirmTitle, (String)message)) {
                this.changed = true;
                int i = 0;
                while (i < selections.length) {
                    this.getInput().remove(selections[i]);
                    ++i;
                }
                this.safeRefresh(null);
            }
        }
    }

    RepositoryTracker getLocalCacheRepoTracker() {
        if (this.localCacheRepoManipulator == null) {
            this.localCacheRepoManipulator = new RepositoryTracker(){

                public void addRepository(URI location, String nickname, ProvisioningSession session) {
                    MetadataRepositoryElement element = RepositoryManipulationPage.this.getInput().get(location);
                    if (element == null) {
                        element = new MetadataRepositoryElement(RepositoryManipulationPage.this.getInput(), null, RepositoryManipulationPage.this.ui, location, true);
                        RepositoryManipulationPage.this.getInput().put(element);
                    }
                    if (nickname != null) {
                        element.setNickname(nickname);
                    }
                    RepositoryManipulationPage.this.changed = true;
                    RepositoryManipulationPage.this.safeRefresh(element);
                }

                public URI[] getKnownRepositories(ProvisioningSession session) {
                    return RepositoryManipulationPage.this.getKnownRepositories();
                }

                public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
                    RepositoryManipulationPage.this.removeRepositories();
                }

                public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
                }

                public IStatus validateRepositoryLocation(ProvisioningSession session, URI location, boolean contactRepositories, IProgressMonitor monitor) {
                    String repoString;
                    int length;
                    IStatus status = super.validateRepositoryLocation(session, location, contactRepositories, monitor);
                    if (status.isOK() && (length = (repoString = URIUtil.toUnencodedString((URI)location)).length()) > 0 && repoString.charAt(length - 1) == '/') {
                        try {
                            location = URIUtil.fromString((String)repoString.substring(0, length - 1));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            return status;
                        }
                        status = super.validateRepositoryLocation(session, location, contactRepositories, monitor);
                    }
                    return status;
                }
            };
        }
        return this.localCacheRepoManipulator;
    }

    @Override
    public void copyToClipboard(Control activeControl) {
        MetadataRepositoryElement[] elements = this.getSelectedElements();
        if (elements.length == 0) {
            elements = this.getElements();
        }
        String text = "";
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(this.labelProvider.getClipboardText(elements[i], "\t"));
            if (i > 0) {
                buffer.append(CopyUtils.NEWLINE);
            }
            ++i;
        }
        text = buffer.toString();
        if (text.length() == 0) {
            return;
        }
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    private boolean toggleMeansDisable(MetadataRepositoryElement[] elements) {
        double count = 0.0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].isEnabled()) {
                count += 1.0;
            }
            ++i;
        }
        return count / (double)elements.length > 0.5;
    }

    URI[] getKnownRepositories() {
        MetadataRepositoryElement[] elements = this.getElements();
        URI[] locations = new URI[elements.length];
        int i = 0;
        while (i < elements.length) {
            locations[i] = elements[i].getLocation();
            ++i;
        }
        return locations;
    }

    class CachedMetadataRepositories
    extends MetadataRepositories {
        private Hashtable<String, MetadataRepositoryElement> cachedElements;

        CachedMetadataRepositories() {
            super(RepositoryManipulationPage.this.ui);
            this.setIncludeDisabledRepositories(this.getPolicy().getRepositoriesVisible());
        }

        @Override
        public int getQueryType() {
            return 1;
        }

        @Override
        public Object[] fetchChildren(Object o, IProgressMonitor monitor) {
            if (this.cachedElements == null) {
                Object[] children = super.fetchChildren(o, monitor);
                this.cachedElements = new Hashtable(children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof MetadataRepositoryElement) {
                        this.put((MetadataRepositoryElement)children[i]);
                    }
                    ++i;
                }
            }
            return this.cachedElements.values().toArray();
        }

        MetadataRepositoryElement[] getElements() {
            return this.cachedElements.values().toArray(new MetadataRepositoryElement[this.cachedElements.size()]);
        }

        void remove(MetadataRepositoryElement element) {
            this.cachedElements.remove(this.getKey(element.getLocation()));
        }

        void put(MetadataRepositoryElement element) {
            this.cachedElements.put(this.getKey(element.getLocation()), element);
        }

        MetadataRepositoryElement get(URI location) {
            return this.cachedElements.get(this.getKey(location));
        }

        String getKey(URI location) {
            String key = URIUtil.toUnencodedString((URI)location);
            int length = key.length();
            if (length > 0 && key.charAt(length - 1) == '/') {
                key = key.substring(0, length - 1);
            }
            return key;
        }
    }

    class MetadataRepositoryPatternFilter
    extends PatternFilter {
        MetadataRepositoryPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            if (element instanceof MetadataRepositoryElement) {
                return this.wordMatches(String.valueOf(RepositoryManipulationPage.this.labelProvider.getColumnText(element, 0)) + " " + RepositoryManipulationPage.this.labelProvider.getColumnText(element, 1));
            }
            return false;
        }
    }
}

