/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    long modelHandle;
    static final int TEXT_COLUMN = 0;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        OS.gtk_list_store_append(this.modelHandle, iter);
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (index < 0 || index > count) {
            this.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        if (index == count) {
            OS.gtk_list_store_append(this.modelHandle, iter);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, iter, index);
        }
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    void createHandle(int index) {
        long columnHandle;
        long textRenderer;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] types = new long[]{OS.G_TYPE_STRING()};
        this.modelHandle = OS.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((textRenderer = OS.gtk_cell_renderer_text_new()) == 0L) {
            this.error(2);
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, 0);
        OS.gtk_tree_view_column_set_min_width(columnHandle, 0);
        OS.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        long selectionHandle = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(selectionHandle, mode);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.getShell().style & 0x4000) != 0) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        OS.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (OS.GTK3 && size.y == 0 && hHint == -1) {
            size.y = this.getItemCount() * this.getItemHeight();
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        OS.gtk_tree_selection_unselect_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start < 0 && end < 0) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (start >= count && end >= count) {
            return;
        }
        start = Math.min(count - 1, Math.max(0, start));
        end = Math.min(count - 1, Math.max(0, end));
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int index = start;
        while (index <= end) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            OS.gtk_tree_selection_unselect_iter(selection, iter);
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index <= count - 1) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
                OS.gtk_tree_selection_unselect_iter(selection, iter);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselectAll() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean dragDetect;
        boolean selected = false;
        if (filter) {
            long[] path = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                if (path[0] != 0L) {
                    long selection = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                        selected = true;
                    }
                    OS.gtk_tree_path_free(path[0]);
                }
            } else {
                return false;
            }
        }
        if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
            consume[0] = true;
        }
        return dragDetect;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getFocusIndex() {
        this.checkWidget();
        long[] path = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0L) {
            return -1;
        }
        long indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[]{-1};
        if (indices != 0L) {
            OS.memmove(index, indices, 4L);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long[] ptr = new long[1];
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
        OS.g_free(iter);
        if (ptr[0] == 0L) {
            return null;
        }
        int length = OS.strlen(ptr[0]);
        byte[] buffer2 = new byte[length];
        OS.memmove(buffer2, ptr[0], (long)length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer2));
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long column = OS.gtk_tree_view_get_column(this.handle, 0);
        if (itemCount == 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            int height = h[0];
            if (OS.GTK3) {
                long textRenderer = this.getTextRenderer(column);
                OS.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
                height += h[0];
            }
            return height;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
        OS.g_free(iter);
        return h[0];
    }

    public String[] getItems() {
        this.checkWidget();
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long[] ptr = new long[1];
        String[] result = new String[count];
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int index = 0;
        while (index < count) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
            if (ptr[0] != 0L) {
                int length = OS.strlen(ptr[0]);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, ptr[0], (long)length);
                OS.g_free(ptr[0]);
                result[index] = new String(Converter.mbcsToWcs(null, buffer));
            }
            ++index;
        }
        OS.g_free(iter);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        long list;
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long originalList = list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int[] index = new int[1];
            boolean foundIndex = false;
            while (list != 0L) {
                long indices;
                long data = OS.g_list_data(list);
                if (!foundIndex && (indices = OS.gtk_tree_path_get_indices(data)) != 0L) {
                    OS.memmove(index, indices, 4L);
                    foundIndex = true;
                }
                list = OS.g_list_next(list);
                OS.gtk_tree_path_free(data);
            }
            OS.g_list_free(originalList);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long list;
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long originalList = list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                long data = OS.g_list_data(list);
                long indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0L) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4L);
                    treeSelection[length] = index[0];
                    ++length;
                }
                OS.gtk_tree_path_free(data);
                list = OS.g_list_next(list);
                ++i;
            }
            OS.g_list_free(originalList);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    long getTextRenderer(long column) {
        long list = 0L;
        list = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(column) : OS.gtk_tree_view_column_get_cell_renderers(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long textRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public int getTopIndex() {
        this.checkWidget();
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0L) {
            return 0;
        }
        long indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0L) {
            OS.memmove(index, indices, 4L);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    long gtk_changed(long widget) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        switch (OS.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    long gtk_button_press_event(long widget, long event) {
        long selection;
        long[] path;
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1L;
            }
            OS.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(path[0]);
        }
        if (!this.gtk_widget_has_focus(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return result;
    }

    long gtk_row_activated(long tree, long path, long column) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] items = this.getItems();
        int i = start;
        while (i < items.length) {
            if (items[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(null, Integer.toString(index), true);
        long path = OS.gtk_tree_path_new_from_string(buffer);
        boolean answer = OS.gtk_tree_selection_path_is_selected(selection, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_remove(this.modelHandle, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int index = end;
        while (index >= start) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            --index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
                OS.gtk_list_store_remove(this.modelHandle, iter);
                last = index;
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        OS.gtk_tree_selection_select_iter(selection, iter);
        if ((this.style & 4) != 0) {
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
            OS.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int index = start;
        while (index <= end) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            OS.gtk_tree_selection_select_iter(selection, iter);
            if ((this.style & 4) != 0) {
                long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
                OS.gtk_tree_path_free(path);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < count) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
                OS.gtk_tree_selection_select_iter(selection, iter);
                if ((this.style & 4) != 0) {
                    long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                    OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
                    OS.gtk_tree_path_free(path);
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    void selectFocusIndex(int index) {
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (index < 0 || index >= count) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
        OS.gtk_tree_selection_select_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, color);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize(this.handle);
        return result;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            OS.gtk_list_store_append(this.modelHandle, iter);
            OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
            ++i2;
        }
        OS.g_free(iter);
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color, false);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean first = true;
        int i = 0;
        while (i < length) {
            int index = 0;
            String string = items[i];
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    if ((this.style & 2) != 0) {
                        if (first) {
                            first = false;
                            this.selectFocusIndex(index);
                        } else {
                            this.select(index);
                        }
                    } else {
                        this.selectFocusIndex(index);
                        break;
                    }
                    ++index;
                }
            }
            ++i;
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, path, 0L, cellRect);
        int[] tx = new int[1];
        int[] ty = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        } else {
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        }
        if (ty[0] < visibleRect.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        } else {
            int height = Math.min(visibleRect.height, cellRect.height);
            if (ty[0] + height > visibleRect.y + visibleRect.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 1.0f, 0.0f);
                ty[0] = ty[0] + (cellRect.height - visibleRect.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
            }
        }
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }
}

