/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.ILibraryLocationResolver;

public class JavaFxLibraryResolver
implements ILibraryLocationResolver {
    public static final String JFXRT_JAR = "jfxrt.jar";
    private static final String JAVAFX_SRC_ZIP = "javafx-src.zip";
    private static final String JAVAFX_8_JAVADOC = "http://docs.oracle.com/javase/8/javafx/api/";

    private static boolean isJavaFx(IPath libraryPath) {
        return JFXRT_JAR.equals(libraryPath.lastSegment());
    }

    public IPath getPackageRoot(IPath libraryPath) {
        return Path.EMPTY;
    }

    public IPath getSourcePath(IPath libraryPath) {
        if (JavaFxLibraryResolver.isJavaFx(libraryPath)) {
            File parent = libraryPath.toFile().getParentFile();
            while (parent != null) {
                File parentsrc = new File(parent, JAVAFX_SRC_ZIP);
                if (parentsrc.isFile()) {
                    return new Path(parentsrc.getPath());
                }
                parent = parent.getParentFile();
            }
        }
        return Path.EMPTY;
    }

    public URL getJavadocLocation(IPath libraryPath) {
        if (JavaFxLibraryResolver.isJavaFx(libraryPath)) {
            try {
                return new URL(JAVAFX_8_JAVADOC);
            }
            catch (MalformedURLException e) {
                LaunchingPlugin.log(e);
            }
        }
        return null;
    }

    public URL getIndexLocation(IPath libraryPath) {
        return null;
    }
}

