/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAction
extends ProvisioningAction {
    public static final String ID = "remove";

    public IStatus execute(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        if (path == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ID));
        }
        File file = new File(path);
        if (!file.exists()) {
            return Status.OK_STATUS;
        }
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (store == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"backup", (Object)ID));
        }
        try {
            store.backupAll(file);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.backup_file_failed, (Object)file.getPath()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }
}

