/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.launching.AutLaunch;

public class GroupExecutable
extends Executable {
    private final Executable[] kids;
    private String name;
    private final Executable root;

    public GroupExecutable(Executable root, List<Executable> group) {
        super(root.isDebug());
        this.root = root;
        this.kids = group.toArray(new Executable[group.size()]);
    }

    @Override
    public boolean isTerminated() {
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            if (child.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public AutLaunch getAut() {
        return this.getRoot().getAut();
    }

    @Override
    public void terminate(boolean user) {
    }

    @Override
    public void startLaunching() {
        if (this.kids.length > 0) {
            this.kids[0].startLaunching();
        }
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.getRoot().getActualElement();
    }

    public Executable getRoot() {
        return this.root;
    }

    @Override
    public Executable[] getChildren() {
        return this.kids;
    }

    @Override
    public IStatus execute() throws InterruptedException {
        return Status.OK_STATUS;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getRoot().getName();
    }

    @Override
    public IStatus getResultStatus() {
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            IStatus status = child.getResultStatus();
            if (status != null && !status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    @Override
    public int getType() {
        return this.getRoot().getType();
    }

    @Override
    public long getTime() {
        long total = 0L;
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            total += child.getTime();
            ++n2;
        }
        return total;
    }

    @Override
    public int getStatus() {
        int status = 0;
        Executable[] executableArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            status = Math.max(status, child.getStatus());
            ++n2;
        }
        return status;
    }

    @Override
    public void postExecute() {
    }

    @Override
    public String getId() {
        return this.getRoot().getId();
    }

    public void setName(String name) {
        this.name = name;
    }
}

