/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;

public class TestSuiteUtils {
    public static IQ7NamedElement[] getElements(ILaunchConfiguration config) throws CoreException {
        return TestSuiteUtils.getElements(config, false);
    }

    public static IQ7NamedElement[] getElements(ILaunchConfiguration config, boolean excludeNonExistent) throws CoreException {
        boolean includeContext = config.getAttribute("org.eclipse.rcptt.launching.INCLUDE_CONTEXT_ATTR", false);
        boolean noSort = config.getAttribute("org.eclipse.rcptt.launching.NO_SORT", false);
        IResource[] mappedResources = config.getMappedResources();
        int resources = config.getAttribute("q7.exec.resources", -1);
        if (resources > 0) {
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < resources) {
                IResource resource = mappedResources[i];
                if (resource.exists() && resource.getProject().isOpen()) {
                    result.add(resource);
                }
                ++i;
            }
            return TestSuiteUtils.getElements(result.toArray(new IResource[result.size()]), !includeContext, !noSort);
        }
        return TestSuiteUtils.getElements(config.getMappedResources(), !includeContext, !noSort);
    }

    public static IQ7NamedElement[] getElements(IResource[] resources, boolean filterContext, boolean sort) {
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        HashSet<IResource> checked = new HashSet<IResource>();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                TestSuiteUtils.collect(resource, elements, checked, filterContext);
                ++n2;
            }
            if (sort) {
                SortingUtils.sortNamedElements(elements);
            }
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] getElements(IResource[] resources, boolean filterContext) {
        return TestSuiteUtils.getElements(resources, filterContext, true);
    }

    private static void collect(IResource resource, List<IQ7NamedElement> elements, Set<IResource> checked, boolean filterContext) {
        if (checked.contains(resource)) {
            return;
        }
        checked.add(resource);
        try {
            if (resource instanceof IFile) {
                IQ7NamedElement element = (IQ7NamedElement)RcpttCore.create((IResource)resource);
                if (element != null && (!filterContext || element instanceof ITestCase || element instanceof ITestSuite)) {
                    elements.add(element);
                }
            } else if (resource instanceof IContainer && (!(resource instanceof IProject) || ((IProject)resource).isOpen())) {
                IResource[] members;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    TestSuiteUtils.collect(member, elements, checked, filterContext);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public static Report generateFailedReport(ITestCase element, String errorMessage) throws ModelException {
        return TestSuiteUtils.generateReport(element, ResultStatus.FAIL, errorMessage);
    }

    public static Report generateSkippedReport(ITestCase element, String errorMessage) throws ModelException {
        return TestSuiteUtils.generateReport(element, ResultStatus.SKIPPED, errorMessage);
    }

    public static Report generateReport(ITestCase element, ResultStatus status, String errorMessage) throws ModelException {
        Report report = ReportFactory.eINSTANCE.createReport();
        Node root = ReportFactory.eINSTANCE.createNode();
        root.setName(element.getID());
        report.setRoot(root);
        Q7Info q7info = ReportingFactory.eINSTANCE.createQ7Info();
        q7info.setId(element.getID());
        q7info.setMessage(errorMessage);
        q7info.setResult(status);
        q7info.setType(ItemKind.TESTCASE);
        root.getProperties().put((Object)"q7", (Object)q7info);
        root.setName(element.getElementName());
        Q7Info scenario = (Q7Info)EcoreUtil.copy((EObject)q7info);
        scenario.setType(ItemKind.SCRIPT);
        Node scenarioNode = ReportFactory.eINSTANCE.createNode();
        scenarioNode.setName(root.getName());
        scenarioNode.getProperties().put((Object)"q7", (Object)scenario);
        root.getChildren().add((Object)scenarioNode);
        return report;
    }

    public static AutLaunch SelectAUT() throws CoreException {
        Status status = new Status(4, "org.eclipse.rcptt.launching", 123128, "", null);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (handler != null) {
            return (AutLaunch)handler.handleStatus((IStatus)status, null);
        }
        return null;
    }
}

