/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.testing.TestingPlugin;
import org.eclipse.rcptt.testing.commands.CaptureContext;
import org.eclipse.rcptt.ui.actions.ContextSnapshotAction;
import org.eclipse.rcptt.ui.context.ContextUIManager;

public class CaptureContextService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        ContextType type;
        if (!(command instanceof CaptureContext)) {
            return Status.CANCEL_STATUS;
        }
        CaptureContext cmd = (CaptureContext)command;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(cmd.getPath()));
        ContextType fromResource = this.getContextType(file);
        ContextType fromArg = CaptureContextService.getContextType(cmd.getType());
        if (fromResource == null && fromArg == null) {
            return TestingPlugin.createErrStatus("Cannot determine context type to capture");
        }
        if (fromResource != null && fromArg != null && !fromResource.getId().equals(fromArg.getId())) {
            return TestingPlugin.createErrStatus("Context type of existing file does not match to context type from argument");
        }
        ContextType contextType = type = fromResource == null ? fromArg : fromResource;
        if (!ContextUIManager.getInstance().getViewer(type).getViewer().isCaptureSupported()) {
            return TestingPlugin.createErrStatus(String.format("Capture is not supported for context type %s", type.getName()));
        }
        IContext ctx = file.exists() ? CaptureContextService.contextFromResource((IResource)file) : RcpttCore.create((IProject)file.getProject()).getFolder(file.getParent().getProjectRelativePath()).createContext(CaptureContextService.getFileNameWithoutExtension(file), type, true, (IProgressMonitor)new NullProgressMonitor());
        ctx = (IContext)ctx.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        Context contextData = ContextSnapshotAction.createSnapshot(null, (String)type.getId(), null);
        type.getMaker().captureContents(ctx, contextData, (IProgressMonitor)new NullProgressMonitor());
        ctx.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        return Status.OK_STATUS;
    }

    private static String getFileNameWithoutExtension(IFile file) {
        String extension = file.getFullPath().getFileExtension();
        String name = file.getName();
        if (extension == null) {
            return name;
        }
        return file.getName().substring(0, name.length() - extension.length() - 1);
    }

    private static ContextType getContextType(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ContextType[] contextTypeArray = ContextTypeManager.getInstance().getTypes();
        int n = contextTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContextType type = contextTypeArray[n2];
            if (type.getEClass().getName().equals(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private ContextType getContextType(IFile file) throws CoreException {
        if (!file.exists()) {
            return null;
        }
        IContext context = CaptureContextService.contextFromResource((IResource)file);
        return context == null ? null : context.getType();
    }

    private static IContext contextFromResource(IResource resource) throws CoreException {
        IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])new IResource[]{resource}, (boolean)false);
        if (elements.length != 1 || !(elements[0] instanceof IContext)) {
            throw new CoreException(TestingPlugin.createErrStatus(String.format("Can't find context in existing file %s", resource.getFullPath())));
        }
        return (IContext)elements[0];
    }
}

