/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.ui.Activator;
import org.eclipse.rcptt.internal.launching.ext.ui.ExternalAUTMainTab;
import org.eclipse.rcptt.internal.launching.ext.ui.SyncProgressMonitor;
import org.eclipse.rcptt.internal.launching.ext.ui.TimeTriggeredProgressMonitorDialog;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AUTLocationBlock {
    private ExternalAUTMainTab fTab;
    private Listener fListener = new Listener();
    private final WritableValue status = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    private Text locationField;
    private Button fileLocationButton;
    private ITargetPlatformHelper info;
    private boolean needUpdate = true;

    private void setStatus(final IStatus newStatus) {
        this.status.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                AUTLocationBlock.this.status.setValue((Object)newStatus);
            }
        });
    }

    public AUTLocationBlock(ExternalAUTMainTab tab) {
        this.fTab = tab;
    }

    public void updateInfo() {
        final String location = this.getLocation();
        File file = new File(location);
        file.exists();
        if (this.needUpdate && file.exists()) {
            this.runInDialog(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AUTLocationBlock.this.info = Q7TargetPlatformManager.createTargetPlatform((String)location, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        AUTLocationBlock.this.setStatus(e.getStatus());
                    }
                }
            });
        }
        if (this.info != null) {
            this.validateForBundleErrors();
            this.fTab.doUpdate(this.info);
        }
        this.fTab.setCurrentTargetPlatform(this.info);
        this.fTab.scheduleUpdateJob();
    }

    private void validateForBundleErrors() {
        this.runInDialog(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (AUTLocationBlock.this.info != null) {
                    AUTLocationBlock.this.info.validateBundles(monitor);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        String locationLabel = "&Application Under Test (AUT)";
        group.setText(locationLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label l = new Label((Composite)group, 64);
        l.setText("Location:");
        this.locationField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.locationField.setLayoutData((Object)gridData);
        this.locationField.addModifyListener((ModifyListener)this.fListener);
        ControlAccessibleListener.addListener((Control)this.locationField, (String)group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fileLocationButton = SWTFactory.createPushButton((Composite)buttonComposite, (String)"File Syste&m...", null);
        this.fileLocationButton.addSelectionListener((SelectionListener)this.fListener);
        ControlAccessibleListener.addListener((Control)this.fileLocationButton, (String)(String.valueOf(group.getText()) + " " + this.fileLocationButton.getText()));
    }

    private void handleFileLocationButtonSelected() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.fTab.getControl().getShell(), 0);
        fileDialog.setFilterPath(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    IStatus createError(String message) {
        return new Status(4, "org.eclipse.rcptt.launching.ext", message);
    }

    public IStatus getStatus() {
        if (this.locationField.getText().trim().length() == 0) {
            return this.createError("Please specify Application installation directory...");
        }
        if (this.info == null) {
            return this.createError("Please specify correct Application installation directory...");
        }
        return this.info.getStatus();
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("aut-location", this.getLocation());
        if (this.info != null) {
            this.info.setTargetName(Q7TargetPlatformManager.getTargetPlatformName((ILaunchConfiguration)config));
            this.info.save();
            config.setAttribute("aut-target-platform", this.info.getName());
            Q7TargetPlatformManager.setHelper((String)this.info.getName(), (ITargetPlatformHelper)this.info);
        }
        config.setAttribute("aut-target-updatable", true);
    }

    private String getLocation() {
        return this.locationField.getText().trim();
    }

    public void initializeFrom(final ILaunchConfiguration config) {
        String location = null;
        try {
            location = config.getAttribute("aut-location", "");
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        this.needUpdate = false;
        this.runInDialog(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AUTLocationBlock.this.info = Q7TargetPlatformManager.loadTarget((ILaunchConfiguration)config, (IProgressMonitor)monitor);
                    if (AUTLocationBlock.this.info == null) {
                        AUTLocationBlock.this.info = Q7TargetPlatformManager.getTarget((ILaunchConfiguration)config, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
        });
        this.locationField.setText(location);
        this.updateInfo();
        this.needUpdate = true;
    }

    private void runInDialog(final IRunnableWithProgress run) {
        final TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.fTab.getControl().getShell(), 500);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    run.run((IProgressMonitor)new SyncProgressMonitor(monitor, dialog.getShell().getDisplay()));
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    private class Listener
    extends SelectionAdapter
    implements ModifyListener {
        private Listener() {
        }

        public void modifyText(ModifyEvent e) {
            if (AUTLocationBlock.this.needUpdate) {
                AUTLocationBlock.this.updateInfo();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AUTLocationBlock.this.fileLocationButton) {
                AUTLocationBlock.this.handleFileLocationButtonSelected();
            }
        }
    }
}

