/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DefaultServletContextHelper;
import org.eclipse.equinox.http.servlet.internal.context.ServletContextHelperWrapper;
import org.eclipse.equinox.http.servlet.internal.error.NullServletContextHelperException;
import org.eclipse.equinox.http.servlet.internal.error.PatternInUseException;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredServletContextHelperException;
import org.eclipse.equinox.http.servlet.internal.error.ServletAlreadyRegisteredException;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.Registration;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;

public class HttpServiceImpl
implements HttpService,
ExtendedHttpService {
    private final Bundle bundle;
    private final HttpServiceRuntimeImpl httpServiceRuntime;
    private final ConcurrentMap<ContextController, Map<Object, Registration<?, ?>>> registrations;
    private final ConcurrentMap<ServletContextHelper, ContextController> servletContextHelperRegistrations = new ConcurrentHashMap<ServletContextHelper, ContextController>();
    private final ConcurrentMap<HttpContext, ServletContextHelper> contextMap = new ConcurrentHashMap<HttpContext, ServletContextHelper>();
    private DefaultServletContextHelper defaultServletContextHelper;
    private final AtomicLong legacyServiceIdGenerator;
    private boolean shutdown = false;

    public HttpServiceImpl(Bundle bundle, HttpServiceRuntimeImpl httpServiceRuntime, ConcurrentMap<ContextController, Map<Object, Registration<?, ?>>> registrations) {
        this.bundle = bundle;
        this.httpServiceRuntime = httpServiceRuntime;
        this.registrations = registrations;
        this.legacyServiceIdGenerator = httpServiceRuntime.getLegacyServiceIdGenerator();
        this.defaultServletContextHelper = new DefaultServletContextHelper(this.bundle);
    }

    public synchronized HttpContext createDefaultHttpContext() {
        this.checkShutdown();
        return this.defaultServletContextHelper;
    }

    @Override
    public synchronized void registerFilter(String alias, javax.servlet.Filter filter, Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException {
        this.checkShutdown();
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        ContextController contextController = this.getContextController(null, httpContext);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        FilterRegistration filterRegistration = contextController.addFilterRegistration(alias, filter, initparams, this.legacyServiceIdGenerator.decrementAndGet());
        contextRegistrations.put(filter, filterRegistration);
    }

    @Override
    public synchronized void registerFilter(javax.servlet.Filter filter, String name, String[] patterns, String[] servletNames, String[] dispatcher, boolean asyncSupported, int filterPriority, Map<String, String> initparams, String contextSelector) throws ServletException {
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        FilterRegistration filterRegistration = contextController.addFilterRegistration(filter, asyncSupported, dispatcher, filterPriority, initparams, name, patterns, this.legacyServiceIdGenerator.decrementAndGet(), servletNames);
        contextRegistrations.put(filter, filterRegistration);
    }

    @Override
    public synchronized void registerListener(EventListener eventListener, String contextSelector) throws ServletException {
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ListenerRegistration listenerRegistration = contextController.addListenerRegistration(eventListener, this.legacyServiceIdGenerator.decrementAndGet());
        contextRegistrations.put(eventListener, listenerRegistration);
    }

    public synchronized void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.checkShutdown();
        ContextController contextController = this.getContextController(null, httpContext);
        this.checkResourcePatterns(new String[]{alias}, contextController);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ResourceRegistration resourceRegistration = contextController.addResourceRegistration(alias, name, this.legacyServiceIdGenerator.decrementAndGet());
        contextRegistrations.put(alias, resourceRegistration);
    }

    @Override
    public synchronized void registerResources(String[] patterns, String prefix, String contextSelector) throws NamespaceException {
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        this.checkResourcePatterns(patterns, contextController);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ResourceRegistration resourceRegistration = contextController.addResourceRegistration(patterns, prefix, this.legacyServiceIdGenerator.decrementAndGet(), false);
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            contextRegistrations.put(pattern, resourceRegistration);
            ++n2;
        }
    }

    public synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.checkShutdown();
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        ContextController contextController = this.getContextController(null, httpContext);
        this.checkServletPatterns(new String[]{alias}, null, contextController);
        if (this.httpServiceRuntime.getRegisteredServlets().contains(servlet)) {
            throw new ServletAlreadyRegisteredException(servlet);
        }
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ServletRegistration servletRegistration = contextController.addServletRegistration(alias, servlet, initparams, this.legacyServiceIdGenerator.decrementAndGet());
        contextRegistrations.put(alias, servletRegistration);
    }

    @Override
    public synchronized void registerServlet(Servlet servlet, String name, String[] patterns, String[] errorPages, boolean asyncSupported, Map<String, String> initparams, String contextSelector) throws ServletException, NamespaceException {
        int n;
        int n2;
        String[] stringArray;
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        this.checkServletPatterns(patterns, errorPages, contextController);
        if (this.httpServiceRuntime.getRegisteredServlets().contains(servlet)) {
            throw new ServletAlreadyRegisteredException(servlet);
        }
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ServletRegistration servletRegistration = contextController.addServletRegistration(servlet, asyncSupported, errorPages, initparams, patterns, this.legacyServiceIdGenerator.decrementAndGet(), name, false);
        if (patterns != null) {
            stringArray = patterns;
            n2 = patterns.length;
            n = 0;
            while (n < n2) {
                String pattern = stringArray[n];
                contextRegistrations.put(pattern, servletRegistration);
                ++n;
            }
        }
        if (errorPages != null) {
            stringArray = errorPages;
            n2 = errorPages.length;
            n = 0;
            while (n < n2) {
                String errorPage = stringArray[n];
                contextRegistrations.put(errorPage, servletRegistration);
                ++n;
            }
        }
    }

    @Override
    public synchronized void registerServletContextHelper(ServletContextHelper servletContextHelper, Bundle bundle, String[] contextNames, String contextPath, Map<String, String> initparams) throws ServletException {
        this.checkShutdown();
        if (servletContextHelper == null) {
            throw new NullServletContextHelperException();
        }
        if (this.servletContextHelperRegistrations.containsKey(servletContextHelper)) {
            throw new RegisteredServletContextHelperException();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (initparams != null) {
            properties.putAll(initparams);
        }
        ContextController contextController = this.httpServiceRuntime.addServletContextHelper(bundle, servletContextHelper, StringPlus.from(contextNames), contextPath, this.legacyServiceIdGenerator.decrementAndGet(), properties);
        this.servletContextHelperRegistrations.put(servletContextHelper, contextController);
    }

    public synchronized void unregister(String alias) {
        this.checkShutdown();
        EndpointRegistration endpointRegistration = null;
        for (HttpContext httpContext : this.contextMap.keySet()) {
            ContextController contextController = this.getContextController(null, httpContext);
            Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
            endpointRegistration = (EndpointRegistration)contextRegistrations.remove(alias);
            if (endpointRegistration == null) continue;
            String[] stringArray = endpointRegistration.getPatterns();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                contextRegistrations.remove(pattern);
                ++n2;
            }
            endpointRegistration.destroy();
        }
        if (endpointRegistration == null) {
            throw new IllegalArgumentException("Alias not found: " + alias);
        }
    }

    @Override
    public synchronized void unregister(String pattern, String contextSelector) {
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        EndpointRegistration endpointRegistration = (EndpointRegistration)contextRegistrations.remove(pattern);
        if (endpointRegistration != null) {
            String[] stringArray = endpointRegistration.getPatterns();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String curPattern = stringArray[n2];
                contextRegistrations.remove(curPattern);
                ++n2;
            }
            endpointRegistration.destroy();
        }
        if (endpointRegistration == null) {
            throw new IllegalArgumentException("Pattern not found: " + pattern);
        }
    }

    @Override
    @Deprecated
    public synchronized void unregisterFilter(javax.servlet.Filter filter) {
        this.checkShutdown();
        FilterRegistration filterRegistration = null;
        for (HttpContext httpContext : this.contextMap.keySet()) {
            ContextController contextController = this.getContextController(null, httpContext);
            Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
            filterRegistration = (FilterRegistration)contextRegistrations.remove(filter);
            if (filterRegistration == null) continue;
            filterRegistration.destroy();
        }
        if (filterRegistration == null) {
            throw new IllegalArgumentException("Filter not found: " + filter);
        }
    }

    @Override
    public synchronized void unregisterFilter(javax.servlet.Filter filter, String contextSelector) {
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        FilterRegistration filterRegistration = (FilterRegistration)contextRegistrations.remove(filter);
        if (filterRegistration == null) {
            throw new IllegalArgumentException("Filter not found: " + filter);
        }
        filterRegistration.destroy();
    }

    @Override
    public synchronized void unregisterListener(EventListener eventListener, String contextSelector) {
        this.checkShutdown();
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ListenerRegistration listenerRegistration = (ListenerRegistration)contextRegistrations.remove(eventListener);
        if (listenerRegistration == null) {
            throw new IllegalArgumentException("EventListener not found: " + eventListener);
        }
        listenerRegistration.destroy();
    }

    @Override
    public synchronized void unregisterServlet(Servlet servlet, String contextSelector) {
        ContextController contextController = this.getContextController(contextSelector, null);
        Map<Object, Registration<?, ?>> contextRegistrations = this.getContextRegistrations(contextController);
        ServletRegistration servletRegistration = null;
        for (Registration<?, ?> curRegistration : contextRegistrations.values()) {
            if (!curRegistration.getT().equals(servlet)) continue;
            servletRegistration = (ServletRegistration)curRegistration;
            break;
        }
        if (servletRegistration != null) {
            ErrorPageDTO errorPageDTO;
            int n;
            String[] patterns = servletRegistration.getPatterns();
            if (patterns != null) {
                String[] stringArray = servletRegistration.getPatterns();
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    contextRegistrations.remove(pattern);
                    ++n2;
                }
            }
            if ((errorPageDTO = servletRegistration.getErrorPageDTO()) != null) {
                long[] lArray = errorPageDTO.errorCodes;
                int n3 = errorPageDTO.errorCodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    long errorCode = lArray[n4];
                    contextRegistrations.remove(String.valueOf(errorCode));
                    ++n4;
                }
                String[] stringArray = errorPageDTO.exceptions;
                n4 = errorPageDTO.exceptions.length;
                n = 0;
                while (n < n4) {
                    String exception = stringArray[n];
                    contextRegistrations.remove(exception);
                    ++n;
                }
            }
        } else {
            throw new IllegalArgumentException("Servlet not found: " + servlet);
        }
        servletRegistration.destroy();
    }

    @Override
    public synchronized void unregisterServletContextHelper(ServletContextHelper servletContextHelper) {
        this.checkShutdown();
        ContextController contextController = (ContextController)this.servletContextHelperRegistrations.remove(servletContextHelper);
        if (contextController == null) {
            throw new IllegalArgumentException("ServletContextHelper not found: " + servletContextHelper);
        }
        this.httpServiceRuntime.removeContextController(contextController);
    }

    synchronized void shutdown() {
        for (ContextController contextController : this.servletContextHelperRegistrations.values()) {
            contextController.destroy();
        }
        this.servletContextHelperRegistrations.clear();
        this.shutdown = true;
    }

    private void checkResourcePatterns(String[] patterns, ContextController contextController) throws NamespaceException {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("Patterns must contain a value.");
        }
        for (EndpointRegistration<?> endpointRegistration : contextController.getEndpointRegistrations()) {
            Object[] registeredPatterns = endpointRegistration.getPatterns();
            if (registeredPatterns == null) continue;
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                int pos = Arrays.binarySearch(registeredPatterns, pattern);
                if (pos > -1) {
                    throw new PatternInUseException(pattern);
                }
                ++n2;
            }
        }
    }

    private void checkServletPatterns(String[] patterns, String[] errorPages, ContextController contextController) throws NamespaceException {
        if (!(patterns != null && patterns.length != 0 || errorPages != null && errorPages.length != 0)) {
            throw new IllegalArgumentException("Patterns or servletNames must contain a value.");
        }
        for (EndpointRegistration<?> endpointRegistration : contextController.getEndpointRegistrations()) {
            ServletRegistration servletRegistration;
            ErrorPageDTO errorPageDTO;
            int pos;
            Object[] registeredPatterns = endpointRegistration.getPatterns();
            if (patterns != null && registeredPatterns != null) {
                String[] stringArray = patterns;
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    pos = Arrays.binarySearch(registeredPatterns, pattern);
                    if (pos > -1) {
                        throw new PatternInUseException(pattern);
                    }
                    ++n2;
                }
            }
            if (errorPages == null || !(endpointRegistration instanceof ServletRegistration) || (errorPageDTO = (servletRegistration = (ServletRegistration)endpointRegistration).getErrorPageDTO()) == null) continue;
            Object[] exceptions = errorPageDTO.exceptions;
            String[] stringArray = errorPages;
            int n = errorPages.length;
            pos = 0;
            while (pos < n) {
                String errorPage = stringArray[pos];
                int pos2 = Arrays.binarySearch(exceptions, errorPage);
                if (pos2 > -1) {
                    throw new NamespaceException("Error page already registered: " + errorPage);
                }
                ++pos;
            }
            long[] errorCodes = errorPageDTO.errorCodes;
            String[] stringArray2 = errorPages;
            int n3 = errorPages.length;
            n = 0;
            while (n < n3) {
                String errorPage = stringArray2[n];
                try {
                    long longValue = Long.parseLong(errorPage);
                    int pos3 = Arrays.binarySearch(errorCodes, longValue);
                    if (pos3 > -1) {
                        throw new NamespaceException("Error page already registered: " + errorPage);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++n;
            }
        }
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Service instance is already shutdown");
        }
    }

    private synchronized ContextController getContextController(String contextSelector, HttpContext httpContext) {
        String calculatedContextSelector = this.calculateContextSelector(contextSelector, httpContext);
        Filter targetFilter = this.httpServiceRuntime.getContextSelectorFilter(this.bundle, calculatedContextSelector);
        ContextController contextController = this.httpServiceRuntime.getContextController(targetFilter);
        if (contextController != null) {
            return contextController;
        }
        if (contextSelector != null) {
            throw new IllegalArgumentException("No valid ServletContextHelper for filter '" + targetFilter.toString() + '\'');
        }
        DefaultServletContextHelper servletContextHelper = this.defaultServletContextHelper;
        if (httpContext != null) {
            servletContextHelper = (ServletContextHelper)this.contextMap.get(httpContext);
        }
        contextController = this.httpServiceRuntime.addServletContextHelper(this.bundle, servletContextHelper, Collections.singletonList(calculatedContextSelector), null, this.legacyServiceIdGenerator.decrementAndGet(), this.httpServiceRuntime.getAttributes());
        this.servletContextHelperRegistrations.put(servletContextHelper, contextController);
        return contextController;
    }

    private Map<Object, Registration<?, ?>> getContextRegistrations(ContextController contextController) {
        Map existing;
        Map map = (ConcurrentHashMap)this.registrations.get(contextController);
        if (map == null && (existing = (Map)this.registrations.putIfAbsent(contextController, map = new ConcurrentHashMap())) != null) {
            map = existing;
        }
        return map;
    }

    private String calculateContextSelector(String contextSelector, HttpContext httpContext) {
        if (contextSelector != null) {
            return contextSelector;
        }
        Object servletContextHelper = null;
        if (httpContext == null) {
            httpContext = this.defaultServletContextHelper;
        }
        if ((servletContextHelper = (ServletContextHelper)this.contextMap.get(httpContext)) == null) {
            servletContextHelper = httpContext instanceof ServletContextHelper ? (ServletContextHelper)httpContext : new ServletContextHelperWrapper(httpContext, this.bundle);
            this.contextMap.putIfAbsent(httpContext, (ServletContextHelper)servletContextHelper);
        }
        return String.valueOf(String.valueOf(this.bundle.getBundleId())) + '#' + httpContext.hashCode();
    }
}

