/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;

public class ServletContextHelperWrapper
extends ServletContextHelper
implements HttpContext {
    private final Bundle _bundle;
    private final HttpContext _httpContext;

    public ServletContextHelperWrapper(HttpContext httpContext, Bundle bundle) {
        super(bundle);
        this._httpContext = httpContext;
        this._bundle = bundle;
    }

    public String getMimeType(String name) {
        return this._httpContext.getMimeType(name);
    }

    public String getRealPath(String path) {
        return null;
    }

    public URL getResource(String name) {
        return this._httpContext.getResource(name);
    }

    public Set<String> getResourcePaths(String path) {
        if (path == null || this._bundle == null) {
            return null;
        }
        Enumeration enumeration = this._bundle.findEntries(path, null, false);
        if (enumeration == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            result.add(((URL)enumeration.nextElement()).getPath());
        }
        return result;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this._httpContext.handleSecurity(request, response);
    }
}

