/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextFilterTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Filter, FilterRegistration> {
    private ContextController contextController;

    public ContextFilterTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public FilterRegistration addingService(ServiceReference<Filter> serviceReference) {
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return null;
        }
        String contextSelector = (String)serviceReference.getProperty("osgi.http.whiteboard.context.select");
        if (!this.contextController.matches(contextSelector)) {
            return null;
        }
        boolean asyncSupported = this.parseBoolean(serviceReference, "osgi.http.whiteboard.filter.asyncSupported");
        List<String> dispatcherList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.dispatcher"));
        String[] dispatchers = dispatcherList.toArray(new String[dispatcherList.size()]);
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        Integer filterPriority = (Integer)serviceReference.getProperty("service.ranking");
        if (filterPriority == null) {
            filterPriority = 0;
        }
        Map<String, String> initParams = this.parseInitParams(serviceReference, "filter.init.");
        List<String> patternList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        List<String> servletList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.servlet"));
        String[] servlets = servletList.toArray(new String[servletList.size()]);
        Filter filter = (Filter)this.bundleContext.getService(serviceReference);
        String name = this.parseName(serviceReference.getProperty("osgi.http.whiteboard.filter.name"), filter);
        try {
            return this.contextController.addFilterRegistration(filter, asyncSupported, dispatchers, filterPriority, initParams, name, patterns, serviceId, servlets);
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
            return null;
        }
    }

    public void modifiedService(ServiceReference<Filter> serviceReference, FilterRegistration filterRegistration) {
    }

    public void removedService(ServiceReference<Filter> serviceReference, FilterRegistration filterRegistration) {
        this.bundleContext.ungetService(serviceReference);
        filterRegistration.destroy();
    }
}

