/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextResourceTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, ResourceRegistration> {
    private ContextController contextController;

    public ContextResourceTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public ResourceRegistration addingService(ServiceReference<Servlet> serviceReference) {
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return null;
        }
        String contextSelector = (String)serviceReference.getProperty("osgi.http.whiteboard.context.select");
        if (!this.contextController.matches(contextSelector)) {
            return null;
        }
        List<String> patternList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        String prefix = (String)serviceReference.getProperty("osgi.http.whiteboard.resource.prefix");
        return this.contextController.addResourceRegistration(patterns, prefix, serviceId, false);
    }

    public void modifiedService(ServiceReference<Servlet> serviceReference, ResourceRegistration resourceRegistration) {
    }

    public void removedService(ServiceReference<Servlet> serviceReference, ResourceRegistration resourceRegistration) {
        this.bundleContext.ungetService(serviceReference);
        resourceRegistration.destroy();
    }
}

