/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.StickyViewDescriptor;
import org.eclipse.ui.internal.registry.ViewCategory;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewRegistry
implements IViewRegistry {
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IExtensionRegistry extensionRegistry;
    @Inject
    private IWorkbench workbench;
    @Inject
    Logger logger;
    private Map<String, IViewDescriptor> descriptors = new HashMap<String, IViewDescriptor>();
    private List<IStickyViewDescriptor> stickyDescriptors = new ArrayList<IStickyViewDescriptor>();
    private HashMap<String, ViewCategory> categories = new HashMap();
    private Category miscCategory = new Category();

    @PostConstruct
    void postConstruct() {
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtensionPoint point = this.extensionRegistry.getExtensionPoint("org.eclipse.ui.views");
        IExtension[] iExtensionArray = point.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals("category")) {
                    ViewCategory category = new ViewCategory(element.getAttribute("id"), element.getAttribute("name"));
                    this.categories.put(category.getId(), category);
                } else if (element.getName().equals("stickyView")) {
                    try {
                        this.stickyDescriptors.add(new StickyViewDescriptor(element));
                    }
                    catch (CoreException e) {
                        this.logger.error("Unable to create sticky view descriptor.", (Object)e.getStatus());
                    }
                }
                ++n;
            }
            ++n4;
        }
        if (!this.categories.containsKey(this.miscCategory.getId())) {
            this.categories.put(this.miscCategory.getId(), new ViewCategory(this.miscCategory.getId(), this.miscCategory.getLabel()));
        }
        iExtensionArray = point.getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals("view")) {
                    this.createDescriptor(element, false);
                }
                if (element.getName().equals("e4view")) {
                    this.createDescriptor(element, true);
                }
                ++n;
            }
            ++n4;
        }
    }

    private void createDescriptor(IConfigurationElement element, boolean e4View) {
        String id = element.getAttribute("id");
        MPartDescriptor descriptor = null;
        List currentDescriptors = this.application.getDescriptors();
        for (MPartDescriptor desc : currentDescriptors) {
            if (!desc.getElementId().equals(id)) continue;
            descriptor = desc;
            break;
        }
        if (descriptor == null) {
            descriptor = (MPartDescriptor)this.modelService.createModelElement(MPartDescriptor.class);
            descriptor.setElementId(id);
            this.application.getDescriptors().add(descriptor);
        }
        descriptor.setLabel(element.getAttribute("name"));
        if (id.equals("org.eclipse.ui.views.ResourceNavigator") || id.equals("org.eclipse.ui.navigator.ProjectExplorer")) {
            descriptor.setCategory("org.eclipse.e4.primaryNavigationStack");
        } else if (id.equals("org.eclipse.ui.views.ContentOutline")) {
            descriptor.setCategory("org.eclipse.e4.secondaryNavigationStack");
        } else {
            descriptor.setCategory("org.eclipse.e4.secondaryDataStack");
        }
        List tags = descriptor.getTags();
        tags.add("View");
        descriptor.setCloseable(true);
        descriptor.setAllowMultiple(Boolean.parseBoolean(element.getAttribute("allowMultiple")));
        String viewDescription = RegistryReader.getDescription(element);
        descriptor.setTooltip(viewDescription);
        String clsSpec = element.getAttribute("class");
        String implementationURI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
        if (e4View) {
            implementationURI = "bundleclass://" + element.getContributor().getName() + "/" + clsSpec;
        }
        descriptor.setContributionURI(implementationURI);
        String iconURI = MenuHelper.getIconURI(element, "icon");
        if (iconURI == null) {
            descriptor.setIconURI(MenuHelper.getImageUrl(this.workbench.getSharedImages().getImageDescriptor("IMG_DEF_VIEW")));
        } else {
            descriptor.setIconURI(iconURI);
        }
        String categoryId = element.getAttribute("category");
        ViewCategory category = this.findCategory(categoryId);
        if (category == null) {
            category = this.findCategory(this.miscCategory.getId());
        }
        if (category != null) {
            tags.add("categoryTag:" + category.getLabel());
        }
        ViewDescriptor viewDescriptor = new ViewDescriptor(this.application, descriptor, element);
        this.descriptors.put(descriptor.getElementId(), viewDescriptor);
        if (category != null) {
            category.addDescriptor(viewDescriptor);
        }
    }

    @Override
    public IViewDescriptor find(String id) {
        IViewDescriptor candidate = this.descriptors.get(id);
        if (WorkbenchActivityHelper.restrictUseOf(candidate)) {
            return null;
        }
        return candidate;
    }

    @Override
    public IViewCategory[] getCategories() {
        return this.categories.values().toArray(new IViewCategory[this.categories.size()]);
    }

    @Override
    public IViewDescriptor[] getViews() {
        Collection allowedViews = WorkbenchActivityHelper.restrictCollection(this.descriptors.values(), new ArrayList());
        return allowedViews.toArray(new IViewDescriptor[allowedViews.size()]);
    }

    @Override
    public IStickyViewDescriptor[] getStickyViews() {
        Collection allowedViews = WorkbenchActivityHelper.restrictCollection(this.stickyDescriptors, new ArrayList());
        return allowedViews.toArray(new IStickyViewDescriptor[allowedViews.size()]);
    }

    public ViewCategory findCategory(String id) {
        if (id == null) {
            return this.categories.get(this.miscCategory.getId());
        }
        return this.categories.get(id);
    }

    public Category getMiscCategory() {
        return this.miscCategory;
    }
}

