/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.rcptt.ecl.internal.core.ScriptletManager;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.ecl.core";
    public static final String ECL_EDITOR_LINE_WIDTH = "ECL_EDITOR_LINE_WIDTH";
    public static final int ECL_EDITOR_LINE_WIDTH_DEFAULT = 120;
    public static final String ECL_EDITOR_INDENT = "ECL_EDITOR_INDENT";
    public static final int ECL_EDITOR_INDENT_DEFAULT = 4;
    private static CorePlugin plugin;
    private ScriptletManager manager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.manager = new ScriptletManager();
    }

    public void stop(BundleContext context) throws Exception {
        this.manager = null;
        plugin = null;
        super.stop(context);
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static ScriptletManager getScriptletManager() {
        if (plugin != null) {
            return CorePlugin.plugin.manager;
        }
        return null;
    }

    public static IStatus err(String message) {
        return CorePlugin.err(message, null);
    }

    public static IStatus err(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, message, throwable);
    }

    public static IStatus err(Throwable throwable) {
        return new Status(4, PLUGIN_ID, throwable.getMessage(), throwable);
    }

    public static void log(IStatus status) {
        if (CorePlugin.getDefault() != null) {
            CorePlugin.getDefault().getLog().log(status);
        }
    }

    public static void log(String message) {
        CorePlugin.log(CorePlugin.err(message));
    }

    public static void log(String message, Throwable throwable) {
        CorePlugin.log(CorePlugin.err(message, throwable));
    }

    public static void log(Throwable throwable) {
        CorePlugin.log(CorePlugin.err(throwable.getMessage(), throwable));
    }

    public static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public static int getECLEditorLineWidth() {
        IEclipsePreferences preferences = CorePlugin.getPreferences();
        return preferences.getInt(ECL_EDITOR_LINE_WIDTH, 120);
    }

    public static void setECLEditorLineWidth(int width) {
        IEclipsePreferences preferences = CorePlugin.getPreferences();
        preferences.putInt(ECL_EDITOR_LINE_WIDTH, width);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getECLEditorIndent() {
        IEclipsePreferences preferences = CorePlugin.getPreferences();
        return preferences.getInt(ECL_EDITOR_INDENT, 4);
    }

    public static void setECLEditorIndent(int width) {
        IEclipsePreferences preferences = CorePlugin.getPreferences();
        preferences.putInt(ECL_EDITOR_INDENT, width);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

