/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.BecomeWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.DiscardWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7Folder;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;

public abstract class Q7NamedElement
extends Openable
implements IQ7NamedElement {
    protected String name;
    protected boolean workingCopyMode = false;
    protected boolean indexing = false;

    public Q7NamedElement(Q7Element parent, String name) throws IllegalArgumentException {
        super(parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IResource getResource() {
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getName()));
    }

    @Override
    protected Object createElementInfo() {
        return new Q7ResourceInfo();
    }

    protected abstract NamedElement createNamedElement();

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map<IQ7Element, Object> newElements, IResource underlyingResource) throws ModelException {
        if (!this.isInWorkingCopyMode() && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        if (!this.getResource().isSynchronized(2)) {
            if (!ModelManager.getModelManager().isProjectBuilding() && !this.indexing) {
                try {
                    this.getResource().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
            }
            if (!this.getResource().isSynchronized(2)) {
                throw this.newNotPresentException();
            }
        }
        Q7ResourceInfo resourceInfo = (Q7ResourceInfo)info;
        resourceInfo.load((IFile)this.getResource());
        if (this.isInWorkingCopyMode() && !this.indexing && resourceInfo.getNamedElement() == null) {
            resourceInfo.createNamedElement(this.createNamedElement());
        }
        return true;
    }

    @Override
    protected void closing(Object info) throws ModelException {
        if (info instanceof Q7ResourceInfo) {
            ((Q7ResourceInfo)info).unload();
        }
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    protected Q7ResourceInfo getInfo() throws ModelException {
        Q7ResourceInfo info = null;
        if (this.isWorkingCopy()) {
            info = this.getPerWorkingCopyInfo().resourceInfo;
        }
        if (info == null) {
            info = (Q7ResourceInfo)this.getElementInfo();
        }
        if (info == null || info.getNamedElement() == null) {
            throw this.newNotPresentException();
        }
        return info;
    }

    @Override
    public String getID() throws ModelException {
        return this.getInfo().getNamedElement().getId();
    }

    @Override
    public String getElementName() throws ModelException {
        return this.getInfo().getNamedElement().getName();
    }

    @Override
    public String getDescription() throws ModelException {
        return this.getInfo().getNamedElement().getDescription();
    }

    @Override
    public String getVersion() throws ModelException {
        return this.getInfo().getNamedElement().getVersion();
    }

    @Override
    public String getTags() throws ModelException {
        return this.getInfo().getNamedElement().getTags();
    }

    public NamedElement getMeta() throws ModelException {
        return this.getInfo().getNamedElement();
    }

    @Override
    public boolean isWorkingCopy() {
        return this.getPerWorkingCopyInfo() != null && this.workingCopyMode;
    }

    public ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return ModelManager.getModelManager().getPerWorkingCopyInfo(this, false, false);
    }

    @Override
    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = ModelManager.getModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((Q7ResourceInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    @Override
    public IQ7NamedElement getIndexingWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.internalGetWorkingCopy(monitor, true);
    }

    @Override
    public IQ7NamedElement getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.internalGetWorkingCopy(monitor, false);
    }

    public IQ7NamedElement internalGetWorkingCopy(IProgressMonitor monitor, boolean indexing) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        Q7NamedElement workingCopy = this.createWorkingCopy();
        workingCopy.workingCopyMode = true;
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, indexing);
        op.runOperation(monitor);
        return workingCopy;
    }

    protected abstract Q7NamedElement createWorkingCopy();

    public void extractAllPersistence() throws ModelException {
        this.getInfo().extractAllPersistence();
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    @Override
    public void discardWorkingCopy() throws ModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this, this.indexing);
        op.runOperation(null);
    }

    public IQ7NamedElement getPrimary() {
        return ((Q7Folder)this.getParent()).getNamedElement(this.getName());
    }

    public void updateTimeStamp(Q7NamedElement primary) throws ModelException {
        long timeStamp = ((IFile)primary.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new Q7Status(0, "Invalid Resource"));
        }
        this.getInfo().timestamp = timeStamp;
    }

    @Override
    public NamedElement getNamedElement() throws ModelException {
        return this.getInfo().getNamedElement();
    }

    @Override
    public NamedElement getModifiedNamedElement() throws ModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return this.getPerWorkingCopyInfo().resourceInfo.getNamedElement();
        }
        return this.getInfo().getNamedElement();
    }

    @Override
    public IPersistenceModel getModifiedPersistenceModel() throws ModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return this.getPerWorkingCopyInfo().resourceInfo.getPersistenceModel();
        }
        return this.getInfo().getPersistenceModel();
    }

    @Override
    public IPersistenceModel getPersistenceModel() throws ModelException {
        return this.getInfo().getModel();
    }

    @Override
    public void setDescription(String description) throws ModelException {
        if (this.isWorkingCopy()) {
            this.getInfo().getNamedElement().setDescription(description);
        }
    }

    @Override
    public void setElementName(String name) throws ModelException {
        if (this.isWorkingCopy()) {
            this.getInfo().getNamedElement().setName(name);
        }
    }

    @Override
    public void setID(String id) throws ModelException {
        if (this.isWorkingCopy()) {
            this.getInfo().getNamedElement().setId(id);
        }
    }

    @Override
    public void setVersion(String version) throws ModelException {
        if (this.isWorkingCopy()) {
            this.getInfo().getNamedElement().setVersion(version);
        }
    }

    @Override
    public void setTags(String tags) throws ModelException {
        if (this.isWorkingCopy()) {
            this.getInfo().getNamedElement().setTags(tags);
        }
    }

    @Override
    public boolean hasUnsavedChanges() throws ModelException {
        Q7ResourceInfo info = null;
        if (this.isWorkingCopy() && (info = this.getPerWorkingCopyInfo().resourceInfo) != null) {
            return info.hasChanges();
        }
        ModelManager manager = ModelManager.getModelManager();
        info = (Q7ResourceInfo)manager.getInfo(this);
        if (info == null) {
            return false;
        }
        return info.hasChanges();
    }

    @Override
    protected boolean isInWorkingCopyMode() {
        return this.workingCopyMode;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Q7NamedElement)) {
            return false;
        }
        return super.equals(obj);
    }

    public void updatePersistenceModel(IPersistenceModel newModel) throws ModelException {
        this.getInfo().updatePersistenceModel(newModel);
    }

    public void setIndexing(boolean indexing) {
        this.indexing = indexing;
    }
}

